/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.unboundidds.controls;

import com.unboundid.asn1.ASN1Boolean;
import com.unboundid.asn1.ASN1Element;
import com.unboundid.asn1.ASN1Integer;
import com.unboundid.asn1.ASN1Long;
import com.unboundid.asn1.ASN1OctetString;
import com.unboundid.asn1.ASN1Sequence;
import com.unboundid.ldap.sdk.Control;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.LDAPInterface;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.ldap.sdk.RootDSE;
import com.unboundid.ldap.sdk.unboundidds.controls.ControlMessages;
import com.unboundid.ldap.sdk.unboundidds.controls.MatchingEntryCountRequestControlProperties;
import com.unboundid.util.Debug;
import com.unboundid.util.NotMutable;
import com.unboundid.util.NotNull;
import com.unboundid.util.Nullable;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import com.unboundid.util.Validator;
import java.util.ArrayList;

@NotMutable
@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class MatchingEntryCountRequestControl
extends Control {
    @NotNull
    public static final String MATCHING_ENTRY_COUNT_REQUEST_OID = "1.3.6.1.4.1.30221.2.5.36";
    @NotNull
    public static final String EXTENDED_RESPONSE_DATA_FEATURE_OID = "1.3.6.1.4.1.30221.2.12.7";
    private static final byte TYPE_MAX_CANDIDATES_TO_EXAMINE = -128;
    private static final byte TYPE_ALWAYS_EXAMINE_CANDIDATES = -127;
    private static final byte TYPE_PROCESS_SEARCH_IF_UNINDEXED = -126;
    private static final byte TYPE_INCLUDE_DEBUG_INFO = -125;
    private static final byte TYPE_SKIP_RESOLVING_EXPLODED_INDEXES = -124;
    private static final byte TYPE_FAST_SHORT_CIRCUIT_THRESHOLD = -123;
    private static final byte TYPE_SLOW_SHORT_CIRCUIT_THRESHOLD = -122;
    private static final byte TYPE_INCLUDE_EXTENDED_RESPONSE_DATA = -121;
    private static final long serialVersionUID = 8670611963939571953L;
    private final boolean alwaysExamineCandidates;
    private final boolean includeDebugInfo;
    private final boolean includeExtendedResponseData;
    private final boolean processSearchIfUnindexed;
    private final boolean skipResolvingExplodedIndexes;
    private final int maxCandidatesToExamine;
    @Nullable
    private final Long slowShortCircuitThreshold;
    @Nullable
    private final Long fastShortCircuitThreshold;

    public MatchingEntryCountRequestControl() {
        this(true, 0, false, false, false);
    }

    public MatchingEntryCountRequestControl(boolean isCritical, int maxCandidatesToExamine, boolean alwaysExamineCandidates, boolean processSearchIfUnindexed, boolean includeDebugInfo) {
        this(isCritical, maxCandidatesToExamine, alwaysExamineCandidates, processSearchIfUnindexed, false, null, null, includeDebugInfo);
    }

    public MatchingEntryCountRequestControl(boolean isCritical, int maxCandidatesToExamine, boolean alwaysExamineCandidates, boolean processSearchIfUnindexed, boolean skipResolvingExplodedIndexes, @Nullable Long fastShortCircuitThreshold, @Nullable Long slowShortCircuitThreshold, boolean includeDebugInfo) {
        super(MATCHING_ENTRY_COUNT_REQUEST_OID, isCritical, MatchingEntryCountRequestControl.encodeValue(maxCandidatesToExamine, alwaysExamineCandidates, processSearchIfUnindexed, skipResolvingExplodedIndexes, fastShortCircuitThreshold, slowShortCircuitThreshold, false, includeDebugInfo));
        Validator.ensureTrue(maxCandidatesToExamine >= 0);
        this.maxCandidatesToExamine = maxCandidatesToExamine;
        this.alwaysExamineCandidates = alwaysExamineCandidates;
        this.processSearchIfUnindexed = processSearchIfUnindexed;
        this.skipResolvingExplodedIndexes = skipResolvingExplodedIndexes;
        this.includeDebugInfo = includeDebugInfo;
        this.fastShortCircuitThreshold = fastShortCircuitThreshold == null ? null : Long.valueOf(Math.max(0L, fastShortCircuitThreshold));
        this.slowShortCircuitThreshold = slowShortCircuitThreshold == null ? null : Long.valueOf(Math.max(0L, slowShortCircuitThreshold));
        this.includeExtendedResponseData = false;
    }

    public MatchingEntryCountRequestControl(boolean isCritical, @NotNull MatchingEntryCountRequestControlProperties properties) {
        super(MATCHING_ENTRY_COUNT_REQUEST_OID, isCritical, MatchingEntryCountRequestControl.encodeValue(properties.getMaxCandidatesToExamine(), properties.alwaysExamineCandidates(), properties.processSearchIfUnindexed(), properties.skipResolvingExplodedIndexes(), properties.getFastShortCircuitThreshold(), properties.getSlowShortCircuitThreshold(), properties.includeExtendedResponseData(), properties.includeDebugInfo()));
        this.maxCandidatesToExamine = properties.getMaxCandidatesToExamine();
        this.alwaysExamineCandidates = properties.alwaysExamineCandidates();
        this.processSearchIfUnindexed = properties.processSearchIfUnindexed();
        this.skipResolvingExplodedIndexes = properties.skipResolvingExplodedIndexes();
        this.fastShortCircuitThreshold = properties.getFastShortCircuitThreshold();
        this.slowShortCircuitThreshold = properties.getSlowShortCircuitThreshold();
        this.includeExtendedResponseData = properties.includeExtendedResponseData();
        this.includeDebugInfo = properties.includeDebugInfo();
    }

    public MatchingEntryCountRequestControl(@NotNull Control control) throws LDAPException {
        super(control);
        ASN1OctetString value = control.getValue();
        if (value == null) {
            throw new LDAPException(ResultCode.DECODING_ERROR, ControlMessages.ERR_MATCHING_ENTRY_COUNT_REQUEST_MISSING_VALUE.get());
        }
        try {
            ASN1Element[] elements;
            boolean alwaysExamine = false;
            boolean debug = false;
            boolean includeExtended = false;
            boolean processUnindexed = false;
            boolean skipExploded = false;
            int maxCandidates = 0;
            Long fastSCThreshold = null;
            Long slowSCThreshold = null;
            block13: for (ASN1Element e : elements = ASN1Sequence.decodeAsSequence(value.getValue()).elements()) {
                switch (e.getType()) {
                    case -128: {
                        maxCandidates = ASN1Integer.decodeAsInteger(e).intValue();
                        if (maxCandidates >= 0) continue block13;
                        throw new LDAPException(ResultCode.DECODING_ERROR, ControlMessages.ERR_MATCHING_ENTRY_COUNT_REQUEST_INVALID_MAX.get());
                    }
                    case -127: {
                        alwaysExamine = ASN1Boolean.decodeAsBoolean(e).booleanValue();
                        continue block13;
                    }
                    case -126: {
                        processUnindexed = ASN1Boolean.decodeAsBoolean(e).booleanValue();
                        continue block13;
                    }
                    case -125: {
                        debug = ASN1Boolean.decodeAsBoolean(e).booleanValue();
                        continue block13;
                    }
                    case -124: {
                        skipExploded = ASN1Boolean.decodeAsBoolean(e).booleanValue();
                        continue block13;
                    }
                    case -123: {
                        fastSCThreshold = Math.max(0L, ASN1Long.decodeAsLong(e).longValue());
                        continue block13;
                    }
                    case -122: {
                        slowSCThreshold = Math.max(0L, ASN1Long.decodeAsLong(e).longValue());
                        continue block13;
                    }
                    case -121: {
                        includeExtended = ASN1Boolean.decodeAsBoolean(e).booleanValue();
                    }
                }
            }
            this.maxCandidatesToExamine = maxCandidates;
            this.alwaysExamineCandidates = alwaysExamine;
            this.processSearchIfUnindexed = processUnindexed;
            this.includeDebugInfo = debug;
            this.includeExtendedResponseData = includeExtended;
            this.skipResolvingExplodedIndexes = skipExploded;
            this.fastShortCircuitThreshold = fastSCThreshold;
            this.slowShortCircuitThreshold = slowSCThreshold;
        }
        catch (LDAPException le) {
            Debug.debugException(le);
            throw le;
        }
        catch (Exception e) {
            Debug.debugException(e);
            throw new LDAPException(ResultCode.DECODING_ERROR, ControlMessages.ERR_MATCHING_ENTRY_COUNT_REQUEST_CANNOT_DECODE.get(StaticUtils.getExceptionMessage(e)), e);
        }
    }

    @NotNull
    private static ASN1OctetString encodeValue(int maxCandidatesToExamine, boolean alwaysExamineCandidates, boolean processSearchIfUnindexed, boolean skipResolvingExplodedIndexes, @Nullable Long fastShortCircuitThreshold, @Nullable Long slowShortCircuitThreshold, boolean includeExtendedResponseData, boolean includeDebugInfo) {
        ArrayList<ASN1Element> elements = new ArrayList<ASN1Element>(4);
        if (maxCandidatesToExamine > 0) {
            elements.add(new ASN1Integer(-128, maxCandidatesToExamine));
        }
        if (alwaysExamineCandidates) {
            elements.add(new ASN1Boolean(-127, true));
        }
        if (processSearchIfUnindexed) {
            elements.add(new ASN1Boolean(-126, true));
        }
        if (includeDebugInfo) {
            elements.add(new ASN1Boolean(-125, true));
        }
        if (skipResolvingExplodedIndexes) {
            elements.add(new ASN1Boolean(-124, true));
        }
        if (fastShortCircuitThreshold != null) {
            elements.add(new ASN1Long(-123, Math.max(0L, fastShortCircuitThreshold)));
        }
        if (slowShortCircuitThreshold != null) {
            elements.add(new ASN1Long(-122, Math.max(0L, slowShortCircuitThreshold)));
        }
        if (includeExtendedResponseData) {
            elements.add(new ASN1Boolean(-121, true));
        }
        return new ASN1OctetString(new ASN1Sequence(elements).encode());
    }

    public int getMaxCandidatesToExamine() {
        return this.maxCandidatesToExamine;
    }

    public boolean alwaysExamineCandidates() {
        return this.alwaysExamineCandidates;
    }

    public boolean processSearchIfUnindexed() {
        return this.processSearchIfUnindexed;
    }

    public boolean skipResolvingExplodedIndexes() {
        return this.skipResolvingExplodedIndexes;
    }

    @Nullable
    public Long getFastShortCircuitThreshold() {
        return this.fastShortCircuitThreshold;
    }

    @Nullable
    public Long getSlowShortCircuitThreshold() {
        return this.slowShortCircuitThreshold;
    }

    public boolean includeExtendedResponseData() {
        return this.includeExtendedResponseData;
    }

    public static boolean serverSupportsExtendedResponseData(@NotNull LDAPInterface connection) throws LDAPException {
        RootDSE rootDSE = connection.getRootDSE();
        return rootDSE != null && MatchingEntryCountRequestControl.serverSupportsExtendedResponseData(rootDSE);
    }

    public static boolean serverSupportsExtendedResponseData(@NotNull RootDSE rootDSE) {
        return rootDSE.supportsFeature(EXTENDED_RESPONSE_DATA_FEATURE_OID);
    }

    public boolean includeDebugInfo() {
        return this.includeDebugInfo;
    }

    @Override
    @NotNull
    public String getControlName() {
        return ControlMessages.INFO_CONTROL_NAME_MATCHING_ENTRY_COUNT_REQUEST.get();
    }

    @Override
    public void toString(@NotNull StringBuilder buffer) {
        buffer.append("MatchingEntryCountRequestControl(isCritical=");
        buffer.append(this.isCritical());
        buffer.append(", maxCandidatesToExamine=");
        buffer.append(this.maxCandidatesToExamine);
        buffer.append(", alwaysExamineCandidates=");
        buffer.append(this.alwaysExamineCandidates);
        buffer.append(", processSearchIfUnindexed=");
        buffer.append(this.processSearchIfUnindexed);
        buffer.append(", skipResolvingExplodedIndexes=");
        buffer.append(this.skipResolvingExplodedIndexes);
        buffer.append(", fastShortCircuitThreshold=");
        buffer.append(this.fastShortCircuitThreshold);
        buffer.append(", slowShortCircuitThreshold=");
        buffer.append(this.slowShortCircuitThreshold);
        buffer.append(", includeExtendedResponseData=");
        buffer.append(this.includeExtendedResponseData);
        buffer.append(", includeDebugInfo=");
        buffer.append(this.includeDebugInfo);
        buffer.append(')');
    }
}

