/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.action;

import java.io.IOException;
import java.util.List;
import org.elasticsearch.action.FailedNodeException;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.nodes.TransportNodesAction;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.core.security.action.ClearSecurityCacheRequest;
import org.elasticsearch.xpack.core.security.action.ClearSecurityCacheResponse;
import org.elasticsearch.xpack.security.support.CacheInvalidatorRegistry;

public class TransportClearSecurityCacheAction
extends TransportNodesAction<ClearSecurityCacheRequest, ClearSecurityCacheResponse, ClearSecurityCacheRequest.Node, ClearSecurityCacheResponse.Node> {
    private final CacheInvalidatorRegistry cacheInvalidatorRegistry;

    @Inject
    public TransportClearSecurityCacheAction(ThreadPool threadPool, ClusterService clusterService, TransportService transportService, ActionFilters actionFilters, CacheInvalidatorRegistry cacheInvalidatorRegistry) {
        super("cluster:admin/xpack/security/cache/clear", threadPool, clusterService, transportService, actionFilters, ClearSecurityCacheRequest::new, ClearSecurityCacheRequest.Node::new, "management", ClearSecurityCacheResponse.Node.class);
        this.cacheInvalidatorRegistry = cacheInvalidatorRegistry;
    }

    protected ClearSecurityCacheResponse newResponse(ClearSecurityCacheRequest request, List<ClearSecurityCacheResponse.Node> nodes, List<FailedNodeException> failures) {
        return new ClearSecurityCacheResponse(this.clusterService.getClusterName(), nodes, failures);
    }

    protected ClearSecurityCacheRequest.Node newNodeRequest(ClearSecurityCacheRequest request) {
        return new ClearSecurityCacheRequest.Node(request);
    }

    protected ClearSecurityCacheResponse.Node newNodeResponse(StreamInput in, DiscoveryNode node) throws IOException {
        return new ClearSecurityCacheResponse.Node(in);
    }

    protected ClearSecurityCacheResponse.Node nodeOperation(ClearSecurityCacheRequest.Node request, Task task) {
        if (request.getKeys() == null || request.getKeys().length == 0) {
            this.cacheInvalidatorRegistry.invalidateCache(request.getCacheName());
        } else {
            this.cacheInvalidatorRegistry.invalidateByKey(request.getCacheName(), List.of(request.getKeys()));
        }
        return new ClearSecurityCacheResponse.Node(this.clusterService.localNode());
    }
}

