/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.action.service;

import java.io.IOException;
import java.util.List;
import org.elasticsearch.action.FailedNodeException;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.nodes.TransportNodesAction;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.core.security.action.service.GetServiceAccountCredentialsNodesRequest;
import org.elasticsearch.xpack.core.security.action.service.GetServiceAccountCredentialsNodesResponse;
import org.elasticsearch.xpack.core.security.action.service.TokenInfo;
import org.elasticsearch.xpack.security.authc.service.FileServiceAccountTokenStore;
import org.elasticsearch.xpack.security.authc.service.ServiceAccount;

public class TransportGetServiceAccountNodesCredentialsAction
extends TransportNodesAction<GetServiceAccountCredentialsNodesRequest, GetServiceAccountCredentialsNodesResponse, GetServiceAccountCredentialsNodesRequest.Node, GetServiceAccountCredentialsNodesResponse.Node> {
    private final FileServiceAccountTokenStore fileServiceAccountTokenStore;

    @Inject
    public TransportGetServiceAccountNodesCredentialsAction(ThreadPool threadPool, ClusterService clusterService, TransportService transportService, ActionFilters actionFilters, FileServiceAccountTokenStore fileServiceAccountTokenStore) {
        super("cluster:admin/xpack/security/service_account/credential/get[n]", threadPool, clusterService, transportService, actionFilters, GetServiceAccountCredentialsNodesRequest::new, GetServiceAccountCredentialsNodesRequest.Node::new, "same", GetServiceAccountCredentialsNodesResponse.Node.class);
        this.fileServiceAccountTokenStore = fileServiceAccountTokenStore;
    }

    protected GetServiceAccountCredentialsNodesResponse newResponse(GetServiceAccountCredentialsNodesRequest request, List<GetServiceAccountCredentialsNodesResponse.Node> nodes, List<FailedNodeException> failures) {
        return new GetServiceAccountCredentialsNodesResponse(this.clusterService.getClusterName(), nodes, failures);
    }

    protected GetServiceAccountCredentialsNodesRequest.Node newNodeRequest(GetServiceAccountCredentialsNodesRequest request) {
        return new GetServiceAccountCredentialsNodesRequest.Node(request);
    }

    protected GetServiceAccountCredentialsNodesResponse.Node newNodeResponse(StreamInput in, DiscoveryNode node) throws IOException {
        return new GetServiceAccountCredentialsNodesResponse.Node(in);
    }

    protected GetServiceAccountCredentialsNodesResponse.Node nodeOperation(GetServiceAccountCredentialsNodesRequest.Node request, Task task) {
        ServiceAccount.ServiceAccountId accountId = new ServiceAccount.ServiceAccountId(request.getNamespace(), request.getServiceName());
        List<TokenInfo> tokenInfos = this.fileServiceAccountTokenStore.findTokensFor(accountId);
        return new GetServiceAccountCredentialsNodesResponse.Node(this.clusterService.localNode(), (String[])tokenInfos.stream().map(TokenInfo::getName).toArray(String[]::new));
    }
}

