/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.authc.esnative;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.common.logging.DeprecationCategory;
import org.elasticsearch.common.logging.DeprecationLogger;
import org.elasticsearch.common.settings.KeyStoreWrapper;
import org.elasticsearch.common.settings.SecureSetting;
import org.elasticsearch.common.settings.SecureString;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.env.Environment;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.xpack.core.XPackSettings;
import org.elasticsearch.xpack.core.security.authc.AuthenticationResult;
import org.elasticsearch.xpack.core.security.authc.RealmConfig;
import org.elasticsearch.xpack.core.security.authc.RealmSettings;
import org.elasticsearch.xpack.core.security.authc.esnative.ClientReservedRealm;
import org.elasticsearch.xpack.core.security.authc.support.Hasher;
import org.elasticsearch.xpack.core.security.authc.support.UsernamePasswordToken;
import org.elasticsearch.xpack.core.security.support.Exceptions;
import org.elasticsearch.xpack.core.security.user.APMSystemUser;
import org.elasticsearch.xpack.core.security.user.AnonymousUser;
import org.elasticsearch.xpack.core.security.user.BeatsSystemUser;
import org.elasticsearch.xpack.core.security.user.ElasticUser;
import org.elasticsearch.xpack.core.security.user.KibanaSystemUser;
import org.elasticsearch.xpack.core.security.user.KibanaUser;
import org.elasticsearch.xpack.core.security.user.LogstashSystemUser;
import org.elasticsearch.xpack.core.security.user.RemoteMonitoringUser;
import org.elasticsearch.xpack.core.security.user.User;
import org.elasticsearch.xpack.security.authc.esnative.NativeUsersStore;
import org.elasticsearch.xpack.security.authc.support.CachingUsernamePasswordRealm;

public class ReservedRealm
extends CachingUsernamePasswordRealm {
    public static final String TYPE = "reserved";
    public static final String NAME = "reserved";
    private final NativeUsersStore.ReservedUserInfo bootstrapUserInfo;
    private final NativeUsersStore.ReservedUserInfo autoconfigUserInfo;
    public static final Setting<SecureString> BOOTSTRAP_ELASTIC_PASSWORD = SecureSetting.secureString((String)"bootstrap.password", (Setting)KeyStoreWrapper.SEED_SETTING, (Setting.Property[])new Setting.Property[0]);
    public static final Setting<SecureString> AUTOCONFIG_ELASTIC_PASSWORD_HASH = SecureSetting.secureString((String)"autoconfiguration.password_hash", null, (Setting.Property[])new Setting.Property[0]);
    private final NativeUsersStore nativeUsersStore;
    private final AnonymousUser anonymousUser;
    private final boolean realmEnabled;
    private final boolean anonymousEnabled;
    private final boolean elasticUserAutoconfigured;
    private final DeprecationLogger deprecationLogger;

    public ReservedRealm(Environment env, Settings settings, NativeUsersStore nativeUsersStore, AnonymousUser anonymousUser, ThreadPool threadPool) {
        super(new RealmConfig(new RealmConfig.RealmIdentifier("reserved", "reserved"), Settings.builder().put(settings).put(RealmSettings.realmSettingPrefix((RealmConfig.RealmIdentifier)new RealmConfig.RealmIdentifier("reserved", "reserved")) + "order", Integer.MIN_VALUE).build(), env, threadPool.getThreadContext()), threadPool);
        this.deprecationLogger = DeprecationLogger.getLogger((String)this.logger.getName());
        this.nativeUsersStore = nativeUsersStore;
        this.realmEnabled = (Boolean)XPackSettings.RESERVED_REALM_ENABLED_SETTING.get(settings);
        this.anonymousUser = anonymousUser;
        this.anonymousEnabled = AnonymousUser.isAnonymousEnabled((Settings)settings);
        char[] autoconfigPasswordHash = null;
        if (AUTOCONFIG_ELASTIC_PASSWORD_HASH.exists(settings) && ((autoconfigPasswordHash = ((SecureString)AUTOCONFIG_ELASTIC_PASSWORD_HASH.get(settings)).getChars()).length == 0 || Set.of(Hasher.SHA1, Hasher.MD5, Hasher.SSHA256, Hasher.NOOP).contains(Hasher.resolveFromHash((char[])autoconfigPasswordHash)))) {
            throw new IllegalArgumentException("Invalid password hash for elastic user auto configuration");
        }
        boolean bl = this.elasticUserAutoconfigured = AUTOCONFIG_ELASTIC_PASSWORD_HASH.exists(settings) && false == BOOTSTRAP_ELASTIC_PASSWORD.exists(settings);
        if (this.elasticUserAutoconfigured) {
            this.autoconfigUserInfo = new NativeUsersStore.ReservedUserInfo(autoconfigPasswordHash, true);
            this.bootstrapUserInfo = null;
        } else {
            this.autoconfigUserInfo = null;
            Hasher reservedRealmHasher = Hasher.resolve((String)((String)XPackSettings.PASSWORD_HASHING_ALGORITHM.get(settings)));
            char[] hash = ((SecureString)BOOTSTRAP_ELASTIC_PASSWORD.get(settings)).length() == 0 ? new char[]{} : reservedRealmHasher.hash((SecureString)BOOTSTRAP_ELASTIC_PASSWORD.get(settings));
            this.bootstrapUserInfo = new NativeUsersStore.ReservedUserInfo(hash, true);
        }
    }

    @Override
    protected void doAuthenticate(UsernamePasswordToken token, ActionListener<AuthenticationResult<User>> listener) {
        if (!this.realmEnabled) {
            listener.onResponse((Object)AuthenticationResult.notHandled());
        } else if (!ClientReservedRealm.isReserved((String)token.principal(), (Settings)this.config.settings())) {
            listener.onResponse((Object)AuthenticationResult.notHandled());
        } else {
            this.getUserInfo(token.principal(), userInfo -> {
                if (userInfo != null) {
                    if (userInfo.hasEmptyPassword()) {
                        listener.onResponse((Object)AuthenticationResult.terminate((String)("failed to authenticate user [" + token.principal() + "]")));
                    } else {
                        ActionListener hashCleanupListener = ActionListener.runBefore((ActionListener)listener, () -> {
                            if (userInfo != this.bootstrapUserInfo && userInfo != this.autoconfigUserInfo) {
                                Arrays.fill(userInfo.passwordHash, '\u0000');
                            }
                        });
                        if (userInfo.verifyPassword(token.credentials())) {
                            User user = this.getUser(token.principal(), (NativeUsersStore.ReservedUserInfo)userInfo);
                            this.logDeprecatedUser(user);
                            if (userInfo == this.autoconfigUserInfo) {
                                assert ("elastic".equals(token.principal()));
                                this.nativeUsersStore.createElasticUser(userInfo.passwordHash, (ActionListener<Void>)ActionListener.wrap(aVoid -> hashCleanupListener.onResponse((Object)AuthenticationResult.success((Object)user)), e -> listener.onFailure((Exception)Exceptions.authenticationProcessError((String)"failed to promote the auto-configured elastic password hash", (Exception)e, (Object[])new Object[0]))));
                            } else {
                                hashCleanupListener.onResponse((Object)AuthenticationResult.success((Object)user));
                            }
                        } else {
                            hashCleanupListener.onResponse((Object)AuthenticationResult.terminate((String)("failed to authenticate user [" + token.principal() + "]")));
                        }
                    }
                } else {
                    listener.onResponse((Object)AuthenticationResult.terminate((String)("failed to authenticate user [" + token.principal() + "]")));
                }
            });
        }
    }

    @Override
    protected void doLookupUser(String username, ActionListener<User> listener) {
        if (!this.realmEnabled) {
            if (this.anonymousEnabled && AnonymousUser.isAnonymousUsername((String)username, (Settings)this.config.settings())) {
                listener.onResponse((Object)this.anonymousUser);
            } else {
                listener.onResponse(null);
            }
        } else if (!ClientReservedRealm.isReserved((String)username, (Settings)this.config.settings())) {
            listener.onResponse(null);
        } else if (AnonymousUser.isAnonymousUsername((String)username, (Settings)this.config.settings())) {
            listener.onResponse((Object)(this.anonymousEnabled ? this.anonymousUser : null));
        } else {
            this.getUserInfo(username, userInfo -> {
                if (userInfo != null) {
                    listener.onResponse((Object)this.getUser(username, (NativeUsersStore.ReservedUserInfo)userInfo));
                } else {
                    listener.onFailure((Exception)Exceptions.authenticationError((String)"failed to lookup user [{}]", (Object[])new Object[]{username}));
                }
            });
        }
    }

    private User getUser(String username, NativeUsersStore.ReservedUserInfo userInfo) {
        assert (username != null);
        switch (username) {
            case "elastic": {
                return new ElasticUser(userInfo.enabled);
            }
            case "kibana": {
                return new KibanaUser(userInfo.enabled);
            }
            case "kibana_system": {
                return new KibanaSystemUser(userInfo.enabled);
            }
            case "logstash_system": {
                return new LogstashSystemUser(userInfo.enabled);
            }
            case "beats_system": {
                return new BeatsSystemUser(userInfo.enabled);
            }
            case "apm_system": {
                return new APMSystemUser(userInfo.enabled);
            }
            case "remote_monitoring_user": {
                return new RemoteMonitoringUser(userInfo.enabled);
            }
        }
        if (this.anonymousEnabled && this.anonymousUser.principal().equals(username)) {
            return this.anonymousUser;
        }
        return null;
    }

    public void users(ActionListener<Collection<User>> listener) {
        if (!this.realmEnabled) {
            listener.onResponse(this.anonymousEnabled ? Collections.singletonList(this.anonymousUser) : Collections.emptyList());
        } else {
            this.nativeUsersStore.getAllReservedUserInfo((ActionListener<Map<String, NativeUsersStore.ReservedUserInfo>>)ActionListener.wrap(reservedUserInfos -> {
                ArrayList<Object> users = new ArrayList<Object>(4);
                NativeUsersStore.ReservedUserInfo userInfo = (NativeUsersStore.ReservedUserInfo)reservedUserInfos.get("elastic");
                users.add(new ElasticUser(userInfo == null || userInfo.enabled));
                userInfo = (NativeUsersStore.ReservedUserInfo)reservedUserInfos.get("kibana");
                users.add(new KibanaUser(userInfo == null || userInfo.enabled));
                userInfo = (NativeUsersStore.ReservedUserInfo)reservedUserInfos.get("kibana_system");
                users.add(new KibanaSystemUser(userInfo == null || userInfo.enabled));
                userInfo = (NativeUsersStore.ReservedUserInfo)reservedUserInfos.get("logstash_system");
                users.add(new LogstashSystemUser(userInfo == null || userInfo.enabled));
                userInfo = (NativeUsersStore.ReservedUserInfo)reservedUserInfos.get("beats_system");
                users.add(new BeatsSystemUser(userInfo == null || userInfo.enabled));
                userInfo = (NativeUsersStore.ReservedUserInfo)reservedUserInfos.get("apm_system");
                users.add(new APMSystemUser(userInfo == null || userInfo.enabled));
                userInfo = (NativeUsersStore.ReservedUserInfo)reservedUserInfos.get("remote_monitoring_user");
                users.add(new RemoteMonitoringUser(userInfo == null || userInfo.enabled));
                if (this.anonymousEnabled) {
                    users.add(this.anonymousUser);
                }
                listener.onResponse(users);
            }, e -> {
                this.logger.error("failed to retrieve reserved users", (Throwable)e);
                listener.onResponse(this.anonymousEnabled ? Collections.singletonList(this.anonymousUser) : Collections.emptyList());
            }));
        }
    }

    private void getUserInfo(String username, Consumer<NativeUsersStore.ReservedUserInfo> consumer) {
        this.nativeUsersStore.getReservedUserInfo(username, (ActionListener<NativeUsersStore.ReservedUserInfo>)ActionListener.wrap(userInfo -> {
            if (userInfo == null) {
                consumer.accept(this.getDefaultUserInfo(username));
            } else {
                consumer.accept((NativeUsersStore.ReservedUserInfo)userInfo);
            }
        }, e -> {
            this.logger.error(() -> new ParameterizedMessage("failed to retrieve password hash for reserved user [{}]", (Object)username), (Throwable)e);
            consumer.accept(null);
        }));
    }

    private void logDeprecatedUser(User user) {
        Map metadata = user.metadata();
        if (Boolean.TRUE.equals(metadata.get("_deprecated"))) {
            this.deprecationLogger.critical(DeprecationCategory.SECURITY, "deprecated_user-" + user.principal(), "The user [" + user.principal() + "] is deprecated and will be removed in a future version of Elasticsearch. " + metadata.get("_deprecated_reason"), new Object[0]);
        }
    }

    private NativeUsersStore.ReservedUserInfo getDefaultUserInfo(String username) {
        if ("elastic".equals(username)) {
            if (this.elasticUserAutoconfigured) {
                assert (this.bootstrapUserInfo == null);
                assert (this.autoconfigUserInfo != null);
                return this.autoconfigUserInfo;
            }
            assert (this.bootstrapUserInfo != null);
            assert (this.autoconfigUserInfo == null);
            return this.bootstrapUserInfo;
        }
        return NativeUsersStore.ReservedUserInfo.defaultEnabledUserInfo();
    }

    public static void addSettings(List<Setting<?>> settingsList) {
        settingsList.add(BOOTSTRAP_ELASTIC_PASSWORD);
        settingsList.add(AUTOCONFIG_ELASTIC_PASSWORD_HASH);
    }
}

