/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.authc.ldap;

import com.unboundid.ldap.sdk.Attribute;
import com.unboundid.ldap.sdk.LDAPInterface;
import com.unboundid.ldap.sdk.SearchResultEntry;
import com.unboundid.ldap.sdk.SearchScope;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.xpack.core.security.authc.RealmConfig;
import org.elasticsearch.xpack.core.security.authc.ldap.UserAttributeGroupsResolverSettings;
import org.elasticsearch.xpack.core.security.authc.ldap.support.SessionFactorySettings;
import org.elasticsearch.xpack.security.authc.ldap.support.LdapSession;
import org.elasticsearch.xpack.security.authc.ldap.support.LdapUtils;

class UserAttributeGroupsResolver
implements LdapSession.GroupsResolver {
    private final String attribute;
    private final boolean ignoreReferralErrors;

    UserAttributeGroupsResolver(RealmConfig realmConfig) {
        this((String)realmConfig.getSetting(UserAttributeGroupsResolverSettings.ATTRIBUTE), (Boolean)realmConfig.getSetting(SessionFactorySettings.IGNORE_REFERRAL_ERRORS_SETTING));
    }

    private UserAttributeGroupsResolver(String attribute, boolean ignoreReferralErrors) {
        this.attribute = Objects.requireNonNull(attribute);
        this.ignoreReferralErrors = ignoreReferralErrors;
    }

    @Override
    public void resolve(LDAPInterface connection, String userDn, TimeValue timeout, Logger logger, Collection<Attribute> attributes, ActionListener<List<String>> listener) {
        if (attributes != null) {
            List groups = attributes.stream().filter(attr -> attr.getName().equals(this.attribute)).flatMap(attr -> Arrays.stream(attr.getValues())).collect(Collectors.toUnmodifiableList());
            listener.onResponse(groups);
        } else {
            LdapUtils.searchForEntry(connection, userDn, SearchScope.BASE, LdapUtils.OBJECT_CLASS_PRESENCE_FILTER, Math.toIntExact(timeout.seconds()), this.ignoreReferralErrors, (ActionListener<SearchResultEntry>)ActionListener.wrap(entry -> {
                if (entry == null || !entry.hasAttribute(this.attribute)) {
                    listener.onResponse(List.of());
                } else {
                    listener.onResponse(List.of(entry.getAttributeValues(this.attribute)));
                }
            }, arg_0 -> listener.onFailure(arg_0)), this.attribute);
        }
    }

    @Override
    public String[] attributes() {
        return new String[]{this.attribute};
    }
}

