/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.transport;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.Version;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.support.DestructiveOperations;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.ssl.SslConfiguration;
import org.elasticsearch.common.util.concurrent.AbstractRunnable;
import org.elasticsearch.common.util.concurrent.RunOnce;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.gateway.GatewayService;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.SendRequestTransportException;
import org.elasticsearch.transport.Transport;
import org.elasticsearch.transport.TransportChannel;
import org.elasticsearch.transport.TransportException;
import org.elasticsearch.transport.TransportInterceptor;
import org.elasticsearch.transport.TransportRequest;
import org.elasticsearch.transport.TransportRequestHandler;
import org.elasticsearch.transport.TransportRequestOptions;
import org.elasticsearch.transport.TransportResponse;
import org.elasticsearch.transport.TransportResponseHandler;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.core.XPackSettings;
import org.elasticsearch.xpack.core.security.SecurityContext;
import org.elasticsearch.xpack.core.security.SecurityField;
import org.elasticsearch.xpack.core.security.transport.ProfileConfigurations;
import org.elasticsearch.xpack.core.security.user.SystemUser;
import org.elasticsearch.xpack.core.ssl.SSLService;
import org.elasticsearch.xpack.security.authc.AuthenticationService;
import org.elasticsearch.xpack.security.authz.AuthorizationService;
import org.elasticsearch.xpack.security.authz.AuthorizationUtils;
import org.elasticsearch.xpack.security.transport.ServerTransportFilter;

public class SecurityServerTransportInterceptor
implements TransportInterceptor {
    private static final Logger logger = LogManager.getLogger(SecurityServerTransportInterceptor.class);
    private final AuthenticationService authcService;
    private final AuthorizationService authzService;
    private final SSLService sslService;
    private final Map<String, ServerTransportFilter> profileFilters;
    private final ThreadPool threadPool;
    private final Settings settings;
    private final SecurityContext securityContext;
    private volatile boolean isStateNotRecovered = true;

    public SecurityServerTransportInterceptor(Settings settings, ThreadPool threadPool, AuthenticationService authcService, AuthorizationService authzService, SSLService sslService, SecurityContext securityContext, DestructiveOperations destructiveOperations, ClusterService clusterService) {
        this.settings = settings;
        this.threadPool = threadPool;
        this.authcService = authcService;
        this.authzService = authzService;
        this.sslService = sslService;
        this.securityContext = securityContext;
        this.profileFilters = this.initializeProfileFilters(destructiveOperations);
        clusterService.addListener(e -> {
            this.isStateNotRecovered = e.state().blocks().hasGlobalBlock(GatewayService.STATE_NOT_RECOVERED_BLOCK);
        });
    }

    public TransportInterceptor.AsyncSender interceptSender(final TransportInterceptor.AsyncSender sender) {
        return new TransportInterceptor.AsyncSender(){

            public <T extends TransportResponse> void sendRequest(Transport.Connection connection, String action, TransportRequest request, TransportRequestOptions options, TransportResponseHandler<T> handler) {
                Version minVersion = Version.min((Version)connection.getVersion(), (Version)Version.CURRENT);
                if (AuthorizationUtils.shouldReplaceUserWithSystem(SecurityServerTransportInterceptor.this.threadPool.getThreadContext(), action)) {
                    SecurityServerTransportInterceptor.this.securityContext.executeAsUser(SystemUser.INSTANCE, original -> SecurityServerTransportInterceptor.this.sendWithUser(connection, action, request, options, new TransportService.ContextRestoreResponseHandler(SecurityServerTransportInterceptor.this.threadPool.getThreadContext().wrapRestorable(original), handler), sender), minVersion);
                } else if (AuthorizationUtils.shouldSetUserBasedOnActionOrigin(SecurityServerTransportInterceptor.this.threadPool.getThreadContext())) {
                    AuthorizationUtils.switchUserBasedOnActionOriginAndExecute(SecurityServerTransportInterceptor.this.threadPool.getThreadContext(), SecurityServerTransportInterceptor.this.securityContext, original -> SecurityServerTransportInterceptor.this.sendWithUser(connection, action, request, options, new TransportService.ContextRestoreResponseHandler(SecurityServerTransportInterceptor.this.threadPool.getThreadContext().wrapRestorable(original), handler), sender));
                } else if (SecurityServerTransportInterceptor.this.securityContext.getAuthentication() != null && !SecurityServerTransportInterceptor.this.securityContext.getAuthentication().getVersion().equals((Object)minVersion)) {
                    SecurityServerTransportInterceptor.this.securityContext.executeAfterRewritingAuthentication(original -> SecurityServerTransportInterceptor.this.sendWithUser(connection, action, request, options, new TransportService.ContextRestoreResponseHandler(SecurityServerTransportInterceptor.this.threadPool.getThreadContext().wrapRestorable(original), handler), sender), minVersion);
                } else {
                    SecurityServerTransportInterceptor.this.sendWithUser(connection, action, request, options, handler, sender);
                }
            }
        };
    }

    private <T extends TransportResponse> void sendWithUser(Transport.Connection connection, String action, TransportRequest request, TransportRequestOptions options, TransportResponseHandler<T> handler, TransportInterceptor.AsyncSender sender) {
        if (this.securityContext.getAuthentication() == null) {
            this.assertNoAuthentication(action);
            throw new IllegalStateException("there should always be a user when sending a message for action [" + action + "]");
        }
        try {
            sender.sendRequest(connection, action, request, options, handler);
        }
        catch (Exception e) {
            handler.handleException((TransportException)new SendRequestTransportException(connection.getNode(), action, (Throwable)e));
        }
    }

    void assertNoAuthentication(String action) {
        assert (false) : "there should always be a user when sending a message for action [" + action + "]";
    }

    public <T extends TransportRequest> TransportRequestHandler<T> interceptHandler(String action, String executor, boolean forceExecution, TransportRequestHandler<T> actualHandler) {
        return new ProfileSecuredRequestHandler<T>(logger, action, forceExecution, executor, actualHandler, this.profileFilters, this.settings, this.threadPool);
    }

    private Map<String, ServerTransportFilter> initializeProfileFilters(DestructiveOperations destructiveOperations) {
        SslConfiguration sslConfiguration = this.sslService.getSSLConfiguration(SecurityField.setting((String)"transport.ssl"));
        Map<String, SslConfiguration> profileConfigurations = ProfileConfigurations.get(this.settings, this.sslService, sslConfiguration);
        HashMap<String, ServerTransportFilter> profileFilters = new HashMap<String, ServerTransportFilter>(profileConfigurations.size() + 1);
        boolean transportSSLEnabled = (Boolean)XPackSettings.TRANSPORT_SSL_ENABLED.get(this.settings);
        for (Map.Entry<String, SslConfiguration> entry : profileConfigurations.entrySet()) {
            SslConfiguration profileConfiguration = entry.getValue();
            boolean extractClientCert = transportSSLEnabled && this.sslService.isSSLClientAuthEnabled(profileConfiguration);
            profileFilters.put(entry.getKey(), new ServerTransportFilter(this.authcService, this.authzService, this.threadPool.getThreadContext(), extractClientCert, destructiveOperations, this.securityContext));
        }
        return Collections.unmodifiableMap(profileFilters);
    }

    public static class ProfileSecuredRequestHandler<T extends TransportRequest>
    implements TransportRequestHandler<T> {
        private final String action;
        private final TransportRequestHandler<T> handler;
        private final Map<String, ServerTransportFilter> profileFilters;
        private final ThreadContext threadContext;
        private final String executorName;
        private final ThreadPool threadPool;
        private final boolean forceExecution;
        private final Logger logger;

        ProfileSecuredRequestHandler(Logger logger, String action, boolean forceExecution, String executorName, TransportRequestHandler<T> handler, Map<String, ServerTransportFilter> profileFilters, Settings settings, ThreadPool threadPool) {
            this.logger = logger;
            this.action = action;
            this.executorName = executorName;
            this.handler = handler;
            this.profileFilters = profileFilters;
            this.threadContext = threadPool.getThreadContext();
            this.threadPool = threadPool;
            this.forceExecution = forceExecution;
        }

        AbstractRunnable getReceiveRunnable(T request, final TransportChannel channel, Task task) {
            RunOnce releaseRequest = new RunOnce(() -> request.decRef());
            request.incRef();
            return new AbstractRunnable((TransportRequest)request, task, (Runnable)releaseRequest){
                final /* synthetic */ TransportRequest val$request;
                final /* synthetic */ Task val$task;
                final /* synthetic */ Runnable val$releaseRequest;
                {
                    this.val$request = transportRequest;
                    this.val$task = task;
                    this.val$releaseRequest = runnable;
                }

                public boolean isForceExecution() {
                    return forceExecution;
                }

                public void onFailure(Exception e) {
                    try {
                        channel.sendResponse(e);
                    }
                    catch (Exception e1) {
                        e1.addSuppressed(e);
                        logger.warn("failed to send exception response for action [" + action + "]", (Throwable)e1);
                    }
                }

                protected void doRun() throws Exception {
                    handler.messageReceived(this.val$request, channel, this.val$task);
                }

                public void onAfter() {
                    this.val$releaseRequest.run();
                }
            };
        }

        public String toString() {
            return "ProfileSecuredRequestHandler{action='" + this.action + "', executorName='" + this.executorName + "', forceExecution=" + this.forceExecution + "}";
        }

        public void messageReceived(T request, TransportChannel channel, Task task) {
            try (ThreadContext.StoredContext ctx = this.threadContext.newStoredContext(true);){
                AbstractFilterListener filterListener;
                String profile = channel.getProfileName();
                ServerTransportFilter filter = this.profileFilters.get(profile);
                if (filter == null) {
                    if (".direct".equals(profile)) {
                        filter = this.profileFilters.get("default");
                    } else {
                        String msg = "transport profile [" + profile + "] is not associated with a transport filter";
                        throw new IllegalStateException(msg);
                    }
                }
                assert (filter != null);
                AbstractRunnable receiveMessage = this.getReceiveRunnable(request, channel, task);
                if ("same".equals(this.executorName)) {
                    filterListener = new AbstractFilterListener(receiveMessage){

                        public void onResponse(Void unused) {
                            this.receiveMessage.run();
                        }
                    };
                } else {
                    final Thread executingThread = Thread.currentThread();
                    filterListener = new AbstractFilterListener(receiveMessage){

                        public void onResponse(Void unused) {
                            if (executingThread == Thread.currentThread()) {
                                this.receiveMessage.run();
                            } else {
                                try {
                                    threadPool.executor(executorName).execute((Runnable)this.receiveMessage);
                                }
                                catch (Exception e) {
                                    this.onFailure(e);
                                }
                            }
                        }
                    };
                }
                filter.inbound(this.action, (TransportRequest)request, channel, filterListener);
            }
        }
    }

    private static abstract class AbstractFilterListener
    implements ActionListener<Void> {
        protected final AbstractRunnable receiveMessage;

        protected AbstractFilterListener(AbstractRunnable receiveMessage) {
            this.receiveMessage = receiveMessage;
        }

        public void onFailure(Exception e) {
            try {
                this.receiveMessage.onFailure(e);
            }
            finally {
                this.receiveMessage.onAfter();
            }
        }
    }
}

