/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.action;

import java.time.Clock;
import java.time.Duration;
import java.time.Instant;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.function.BooleanSupplier;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.HandledTransportAction;
import org.elasticsearch.action.support.ThreadedActionListener;
import org.elasticsearch.client.Client;
import org.elasticsearch.client.OriginSettingClient;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.tasks.TaskId;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.core.ml.action.DeleteExpiredDataAction;
import org.elasticsearch.xpack.core.ml.job.config.Job;
import org.elasticsearch.xpack.ml.job.persistence.JobConfigProvider;
import org.elasticsearch.xpack.ml.job.persistence.JobResultsProvider;
import org.elasticsearch.xpack.ml.job.persistence.SearchAfterJobsIterator;
import org.elasticsearch.xpack.ml.job.retention.EmptyStateIndexRemover;
import org.elasticsearch.xpack.ml.job.retention.ExpiredAnnotationsRemover;
import org.elasticsearch.xpack.ml.job.retention.ExpiredForecastsRemover;
import org.elasticsearch.xpack.ml.job.retention.ExpiredModelSnapshotsRemover;
import org.elasticsearch.xpack.ml.job.retention.ExpiredResultsRemover;
import org.elasticsearch.xpack.ml.job.retention.MlDataRemover;
import org.elasticsearch.xpack.ml.job.retention.UnusedStateRemover;
import org.elasticsearch.xpack.ml.job.retention.UnusedStatsRemover;
import org.elasticsearch.xpack.ml.notifications.AnomalyDetectionAuditor;
import org.elasticsearch.xpack.ml.utils.VolatileCursorIterator;
import org.elasticsearch.xpack.ml.utils.persistence.WrappedBatchedJobsIterator;

public class TransportDeleteExpiredDataAction
extends HandledTransportAction<DeleteExpiredDataAction.Request, DeleteExpiredDataAction.Response> {
    private static final Logger logger = LogManager.getLogger(TransportDeleteExpiredDataAction.class);
    private final ThreadPool threadPool;
    private final String executor;
    private final OriginSettingClient client;
    private final ClusterService clusterService;
    private final Clock clock;
    private final JobConfigProvider jobConfigProvider;
    private final JobResultsProvider jobResultsProvider;
    private final AnomalyDetectionAuditor auditor;

    @Inject
    public TransportDeleteExpiredDataAction(ThreadPool threadPool, TransportService transportService, ActionFilters actionFilters, Client client, ClusterService clusterService, JobConfigProvider jobConfigProvider, JobResultsProvider jobResultsProvider, AnomalyDetectionAuditor auditor) {
        this(threadPool, "ml_utility", transportService, actionFilters, client, clusterService, jobConfigProvider, jobResultsProvider, auditor, Clock.systemUTC());
    }

    TransportDeleteExpiredDataAction(ThreadPool threadPool, String executor, TransportService transportService, ActionFilters actionFilters, Client client, ClusterService clusterService, JobConfigProvider jobConfigProvider, JobResultsProvider jobResultsProvider, AnomalyDetectionAuditor auditor, Clock clock) {
        super("cluster:admin/xpack/ml/delete_expired_data", transportService, actionFilters, DeleteExpiredDataAction.Request::new, executor);
        this.threadPool = threadPool;
        this.executor = executor;
        this.client = new OriginSettingClient(client, "ml");
        this.clusterService = clusterService;
        this.clock = clock;
        this.jobConfigProvider = jobConfigProvider;
        this.jobResultsProvider = jobResultsProvider;
        this.auditor = auditor;
    }

    protected void doExecute(Task task, DeleteExpiredDataAction.Request request, ActionListener<DeleteExpiredDataAction.Response> listener) {
        logger.info("Deleting expired data");
        Instant timeoutTime = Instant.now(this.clock).plus(request.getTimeout() == null ? Duration.ofMillis(MlDataRemover.DEFAULT_MAX_DURATION.getMillis()) : Duration.ofMillis(request.getTimeout().millis()));
        TaskId taskId = new TaskId(this.clusterService.localNode().getId(), task.getId());
        BooleanSupplier isTimedOutSupplier = () -> Instant.now(this.clock).isAfter(timeoutTime);
        AnomalyDetectionAuditor auditor = new AnomalyDetectionAuditor((Client)this.client, this.clusterService);
        if (Strings.isNullOrEmpty((String)request.getJobId()) || Strings.isAllOrWildcard((String)request.getJobId())) {
            List<MlDataRemover> dataRemovers = this.createDataRemovers(this.client, taskId, auditor);
            this.threadPool.executor("ml_utility").execute(() -> this.deleteExpiredData(request, dataRemovers, listener, isTimedOutSupplier));
        } else {
            this.jobConfigProvider.expandJobs(request.getJobId(), false, true, (ActionListener<List<Job.Builder>>)ActionListener.wrap(jobBuilders -> this.threadPool.executor("ml_utility").execute(() -> {
                List<Job> jobs = jobBuilders.stream().map(Job.Builder::build).collect(Collectors.toList());
                String[] jobIds = (String[])jobs.stream().map(Job::getId).toArray(String[]::new);
                request.setExpandedJobIds(jobIds);
                List<MlDataRemover> dataRemovers = this.createDataRemovers(jobs, taskId, auditor);
                this.deleteExpiredData(request, dataRemovers, listener, isTimedOutSupplier);
            }), arg_0 -> listener.onFailure(arg_0)));
        }
    }

    private void deleteExpiredData(DeleteExpiredDataAction.Request request, List<MlDataRemover> dataRemovers, ActionListener<DeleteExpiredDataAction.Response> listener, BooleanSupplier isTimedOutSupplier) {
        VolatileCursorIterator<MlDataRemover> dataRemoversIterator = new VolatileCursorIterator<MlDataRemover>(dataRemovers);
        float requestsPerSec = request.getRequestsPerSecond() == null ? Float.POSITIVE_INFINITY : request.getRequestsPerSecond().floatValue();
        int numberOfDatanodes = Math.max(this.clusterService.state().getNodes().getDataNodes().size(), 1);
        if (requestsPerSec == -1.0f) {
            requestsPerSec = numberOfDatanodes < 5 ? 200.0f * (float)numberOfDatanodes : Float.POSITIVE_INFINITY;
        }
        this.deleteExpiredData(request, dataRemoversIterator, requestsPerSec, listener, isTimedOutSupplier, true);
    }

    void deleteExpiredData(DeleteExpiredDataAction.Request request, Iterator<MlDataRemover> mlDataRemoversIterator, float requestsPerSecond, ActionListener<DeleteExpiredDataAction.Response> listener, BooleanSupplier isTimedOutSupplier, boolean haveAllPreviousDeletionsCompleted) {
        if (haveAllPreviousDeletionsCompleted && mlDataRemoversIterator.hasNext()) {
            MlDataRemover remover = mlDataRemoversIterator.next();
            ActionListener nextListener = ActionListener.wrap(booleanResponse -> this.deleteExpiredData(request, mlDataRemoversIterator, requestsPerSecond, listener, isTimedOutSupplier, (boolean)booleanResponse), arg_0 -> listener.onFailure(arg_0));
            remover.remove(requestsPerSecond, (ActionListener<Boolean>)new ThreadedActionListener(logger, this.threadPool, this.executor, nextListener, false), isTimedOutSupplier);
        } else {
            if (haveAllPreviousDeletionsCompleted) {
                logger.info("Completed deletion of expired ML data");
            } else if (isTimedOutSupplier.getAsBoolean()) {
                TimeValue timeoutPeriod = request.getTimeout() == null ? MlDataRemover.DEFAULT_MAX_DURATION : request.getTimeout();
                String msg = "Deleting expired ML data was cancelled after the timeout period of [" + timeoutPeriod + "] was exceeded. The setting [xpack.ml.nightly_maintenance_requests_per_second] controls the deletion rate, consider increasing the value to assist in pruning old data";
                logger.warn(msg);
                if (Strings.isNullOrEmpty((String)request.getJobId()) || Strings.isAllOrWildcard((String)request.getJobId()) || request.getExpandedJobIds() == null) {
                    this.auditor.warning("", msg);
                } else {
                    for (String jobId : request.getExpandedJobIds()) {
                        this.auditor.warning(jobId, msg);
                    }
                }
            } else {
                logger.info("Halted deletion of expired ML data until next invocation");
            }
            listener.onResponse((Object)new DeleteExpiredDataAction.Response(haveAllPreviousDeletionsCompleted));
        }
    }

    private List<MlDataRemover> createDataRemovers(OriginSettingClient client, TaskId parentTaskId, AnomalyDetectionAuditor auditor) {
        return Arrays.asList(new ExpiredResultsRemover(client, new WrappedBatchedJobsIterator(new SearchAfterJobsIterator(client)), parentTaskId, auditor, this.threadPool), new ExpiredForecastsRemover(client, this.threadPool, parentTaskId), new ExpiredModelSnapshotsRemover(client, new WrappedBatchedJobsIterator(new SearchAfterJobsIterator(client)), this.threadPool, parentTaskId, this.jobResultsProvider, auditor), new UnusedStateRemover(client, parentTaskId), new EmptyStateIndexRemover(client, parentTaskId), new UnusedStatsRemover(client, parentTaskId), new ExpiredAnnotationsRemover(client, new WrappedBatchedJobsIterator(new SearchAfterJobsIterator(client)), parentTaskId, auditor, this.threadPool));
    }

    private List<MlDataRemover> createDataRemovers(List<Job> jobs, TaskId parentTaskId, AnomalyDetectionAuditor auditor) {
        return Arrays.asList(new ExpiredResultsRemover(this.client, new VolatileCursorIterator<Job>(jobs), parentTaskId, auditor, this.threadPool), new ExpiredForecastsRemover(this.client, this.threadPool, parentTaskId), new ExpiredModelSnapshotsRemover(this.client, new VolatileCursorIterator<Job>(jobs), this.threadPool, parentTaskId, this.jobResultsProvider, auditor), new UnusedStateRemover(this.client, parentTaskId), new EmptyStateIndexRemover(this.client, parentTaskId), new UnusedStatsRemover(this.client, parentTaskId), new ExpiredAnnotationsRemover(this.client, new VolatileCursorIterator<Job>(jobs), parentTaskId, auditor, this.threadPool));
    }
}

