/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.inference.nlp;

import java.util.List;
import java.util.Optional;
import org.elasticsearch.xpack.core.ml.inference.results.InferenceResults;
import org.elasticsearch.xpack.core.ml.inference.results.PyTorchPassThroughResults;
import org.elasticsearch.xpack.core.ml.inference.trainedmodel.NlpConfig;
import org.elasticsearch.xpack.core.ml.inference.trainedmodel.PassThroughConfig;
import org.elasticsearch.xpack.ml.inference.deployment.PyTorchResult;
import org.elasticsearch.xpack.ml.inference.nlp.NlpTask;
import org.elasticsearch.xpack.ml.inference.nlp.tokenizers.NlpTokenizer;
import org.elasticsearch.xpack.ml.inference.nlp.tokenizers.TokenizationResult;

public class PassThroughProcessor
implements NlpTask.Processor {
    private final NlpTask.RequestBuilder requestBuilder;
    private final String resultsField;

    PassThroughProcessor(NlpTokenizer tokenizer, PassThroughConfig config) {
        this.requestBuilder = tokenizer.requestBuilder();
        this.resultsField = config.getResultsField();
    }

    @Override
    public void validateInputs(List<String> inputs) {
    }

    @Override
    public NlpTask.RequestBuilder getRequestBuilder(NlpConfig config) {
        return this.requestBuilder;
    }

    @Override
    public NlpTask.ResultProcessor getResultProcessor(NlpConfig config) {
        return (tokenization, pyTorchResult) -> PassThroughProcessor.processResult(tokenization, pyTorchResult, config.getResultsField());
    }

    private static InferenceResults processResult(TokenizationResult tokenization, PyTorchResult pyTorchResult, String resultsField) {
        return new PyTorchPassThroughResults(Optional.ofNullable(resultsField).orElse("predicted_value"), pyTorchResult.getInferenceResult()[0], tokenization.anyTruncated());
    }
}

