/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.inference.pytorch.process;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.elasticsearch.xpack.ml.process.NativeController;
import org.elasticsearch.xpack.ml.process.ProcessPipes;

public class PyTorchBuilder {
    public static final String PROCESS_NAME = "pytorch_inference";
    private static final String PROCESS_PATH = "./pytorch_inference";
    private static final String LICENSE_KEY_VALIDATED_ARG = "--validElasticLicenseKeyConfirmed=";
    private static final String INFERENCE_THREADS_ARG = "--inferenceThreads=";
    private static final String MODEL_THREADS_ARG = "--modelThreads=";
    private final NativeController nativeController;
    private final ProcessPipes processPipes;
    private final int inferenceThreads;
    private final int modelThreads;

    public PyTorchBuilder(NativeController nativeController, ProcessPipes processPipes, int inferenceThreads, int modelThreads) {
        this.nativeController = Objects.requireNonNull(nativeController);
        this.processPipes = Objects.requireNonNull(processPipes);
        this.inferenceThreads = inferenceThreads;
        this.modelThreads = modelThreads;
    }

    public void build() throws IOException, InterruptedException {
        List<String> command = this.buildCommand();
        this.processPipes.addArgs(command);
        this.nativeController.startProcess(command);
    }

    private List<String> buildCommand() {
        ArrayList<String> command = new ArrayList<String>();
        command.add(PROCESS_PATH);
        command.add("--validElasticLicenseKeyConfirmed=true");
        command.add(INFERENCE_THREADS_ARG + this.inferenceThreads);
        command.add(MODEL_THREADS_ARG + this.modelThreads);
        return command;
    }
}

