/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.job.process;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.AbstractExecutorService;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.elasticsearch.ElasticsearchStatusException;
import org.elasticsearch.common.util.concurrent.AbstractRunnable;
import org.elasticsearch.common.util.concurrent.EsExecutors;
import org.elasticsearch.common.util.concurrent.EsRejectedExecutionException;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.core.SuppressForbidden;
import org.elasticsearch.rest.RestStatus;

public class ProcessWorkerExecutorService
extends AbstractExecutorService {
    private static final Logger logger = LogManager.getLogger(ProcessWorkerExecutorService.class);
    private final ThreadContext contextHolder;
    private final String processName;
    private final CountDownLatch awaitTermination = new CountDownLatch(1);
    private final BlockingQueue<Runnable> queue;
    private volatile boolean running = true;

    @SuppressForbidden(reason="properly rethrowing errors, see EsExecutors.rethrowErrors")
    public ProcessWorkerExecutorService(ThreadContext contextHolder, String processName, int queueCapacity) {
        this.contextHolder = Objects.requireNonNull(contextHolder);
        this.processName = Objects.requireNonNull(processName);
        this.queue = new LinkedBlockingQueue<Runnable>(queueCapacity);
    }

    public int queueSize() {
        return this.queue.size();
    }

    @Override
    public void shutdown() {
        this.running = false;
    }

    @Override
    public List<Runnable> shutdownNow() {
        throw new UnsupportedOperationException("not supported");
    }

    @Override
    public boolean isShutdown() {
        return !this.running;
    }

    @Override
    public boolean isTerminated() {
        return this.awaitTermination.getCount() == 0L;
    }

    @Override
    public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
        return this.awaitTermination.await(timeout, unit);
    }

    @Override
    public synchronized void execute(Runnable command) {
        boolean added;
        if (this.isShutdown()) {
            EsRejectedExecutionException rejected = new EsRejectedExecutionException(this.processName + " worker service has shutdown", true);
            if (command instanceof AbstractRunnable) {
                ((AbstractRunnable)command).onRejection((Exception)((Object)rejected));
            } else {
                throw rejected;
            }
        }
        if (!(added = this.queue.offer(this.contextHolder.preserveContext(command)))) {
            throw new ElasticsearchStatusException("Unable to execute on [{}] as queue is full", RestStatus.TOO_MANY_REQUESTS, new Object[]{this.processName});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        try {
            Object runnable;
            while (this.running) {
                runnable = this.queue.poll(500L, TimeUnit.MILLISECONDS);
                if (runnable == null) continue;
                try {
                    runnable.run();
                }
                catch (Exception e) {
                    logger.error(() -> new ParameterizedMessage("error handling process [{}] operation", (Object)this.processName), (Throwable)e);
                }
                EsExecutors.rethrowErrors((Runnable)this.contextHolder.unwrap((Runnable)runnable));
            }
            runnable = this;
            synchronized (runnable) {
                if (!this.queue.isEmpty()) {
                    ArrayList notExecuted = new ArrayList();
                    this.queue.drainTo(notExecuted);
                    String msg = "unable to process as " + this.processName + " worker service has shutdown";
                    for (Runnable runnable2 : notExecuted) {
                        if (!(runnable2 instanceof AbstractRunnable)) continue;
                        ((AbstractRunnable)runnable2).onRejection((Exception)((Object)new EsRejectedExecutionException(msg, true)));
                    }
                }
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        finally {
            this.awaitTermination.countDown();
        }
    }
}

