/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.rest.job;

import java.io.IOException;
import java.util.List;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.client.node.NodeClient;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.BytesRestResponse;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.RestResponse;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.rest.action.RestToXContentListener;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.tasks.TaskListener;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xpack.core.ml.action.ResetJobAction;
import org.elasticsearch.xpack.core.ml.job.config.Job;

public class RestResetJobAction
extends BaseRestHandler {
    public List<RestHandler.Route> routes() {
        return List.of(new RestHandler.Route(RestRequest.Method.POST, "/_ml/anomaly_detectors/{" + Job.ID + "}/_reset"));
    }

    public String getName() {
        return "ml_reset_job_action";
    }

    protected BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest restRequest, NodeClient client) throws IOException {
        ResetJobAction.Request request = new ResetJobAction.Request(restRequest.param(Job.ID.getPreferredName()));
        request.timeout(restRequest.paramAsTime("timeout", request.timeout()));
        request.masterNodeTimeout(restRequest.paramAsTime("master_timeout", request.masterNodeTimeout()));
        if (restRequest.paramAsBoolean("wait_for_completion", true)) {
            return channel -> client.execute((ActionType)ResetJobAction.INSTANCE, (ActionRequest)request, (ActionListener)new RestToXContentListener(channel));
        }
        request.setShouldStoreResult(true);
        Task task = client.executeLocally((ActionType)ResetJobAction.INSTANCE, (ActionRequest)request, RestResetJobAction.nullTaskListener());
        return channel -> {
            try (XContentBuilder builder = channel.newBuilder();){
                builder.startObject();
                builder.field("task", client.getLocalNodeId() + ":" + task.getId());
                builder.endObject();
                channel.sendResponse((RestResponse)new BytesRestResponse(RestStatus.OK, builder));
            }
        };
    }

    private static <T> TaskListener<T> nullTaskListener() {
        return new TaskListener<T>(){

            public void onResponse(Task task, T o) {
            }

            public void onFailure(Task task, Exception e) {
            }
        };
    }
}

