/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.vectors;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.node.DiscoveryNodes;
import org.elasticsearch.common.settings.ClusterSettings;
import org.elasticsearch.common.settings.IndexScopedSettings;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.settings.SettingsFilter;
import org.elasticsearch.index.mapper.FieldMapper;
import org.elasticsearch.index.mapper.Mapper;
import org.elasticsearch.plugins.ActionPlugin;
import org.elasticsearch.plugins.MapperPlugin;
import org.elasticsearch.plugins.Plugin;
import org.elasticsearch.plugins.SearchPlugin;
import org.elasticsearch.rest.RestController;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.xpack.vectors.action.RestKnnSearchAction;
import org.elasticsearch.xpack.vectors.mapper.DenseVectorFieldMapper;
import org.elasticsearch.xpack.vectors.mapper.SparseVectorFieldMapper;
import org.elasticsearch.xpack.vectors.query.KnnVectorQueryBuilder;

public class DenseVectorPlugin
extends Plugin
implements ActionPlugin,
MapperPlugin,
SearchPlugin {
    public Map<String, Mapper.TypeParser> getMappers() {
        LinkedHashMap<String, FieldMapper.TypeParser> mappers = new LinkedHashMap<String, FieldMapper.TypeParser>();
        mappers.put("dense_vector", DenseVectorFieldMapper.PARSER);
        mappers.put("sparse_vector", SparseVectorFieldMapper.PARSER);
        return Collections.unmodifiableMap(mappers);
    }

    public List<RestHandler> getRestHandlers(Settings settings, RestController restController, ClusterSettings clusterSettings, IndexScopedSettings indexScopedSettings, SettingsFilter settingsFilter, IndexNameExpressionResolver indexNameExpressionResolver, Supplier<DiscoveryNodes> nodesInCluster) {
        return List.of(new RestKnnSearchAction());
    }

    public List<SearchPlugin.QuerySpec<?>> getQueries() {
        return List.of(new SearchPlugin.QuerySpec("knn", KnnVectorQueryBuilder::new, parser -> {
            throw new IllegalArgumentException("[knn] queries cannot be provided directly, use the [_knn_search] endpoint instead");
        }));
    }
}

