/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.vectors.action;

import java.io.IOException;
import java.util.List;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.search.SearchRequestBuilder;
import org.elasticsearch.client.node.NodeClient;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.action.RestCancellableNodeClient;
import org.elasticsearch.rest.action.RestStatusToXContentListener;
import org.elasticsearch.xpack.vectors.action.KnnSearchRequestBuilder;

public class RestKnnSearchAction
extends BaseRestHandler {
    public List<RestHandler.Route> routes() {
        return List.of(new RestHandler.Route(RestRequest.Method.GET, "{index}/_knn_search"), new RestHandler.Route(RestRequest.Method.POST, "{index}/_knn_search"));
    }

    public String getName() {
        return "knn_search_action";
    }

    protected BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest restRequest, NodeClient client) throws IOException {
        RestCancellableNodeClient cancellableNodeClient = new RestCancellableNodeClient(client, restRequest.getHttpChannel());
        KnnSearchRequestBuilder request = KnnSearchRequestBuilder.parseRestRequest(restRequest);
        SearchRequestBuilder searchRequestBuilder = cancellableNodeClient.prepareSearch(new String[0]);
        request.build(searchRequestBuilder);
        return channel -> searchRequestBuilder.execute((ActionListener)new RestStatusToXContentListener(channel));
    }
}

