/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.plugins.cli;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.nio.file.CopyOption;
import java.nio.file.DirectoryStream;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.PosixFileAttributeView;
import java.nio.file.attribute.PosixFileAttributes;
import java.nio.file.attribute.PosixFilePermission;
import java.nio.file.attribute.PosixFilePermissions;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.apache.lucene.search.spell.LevenshteinDistance;
import org.apache.lucene.util.CollectionUtil;
import org.apache.lucene.util.Constants;
import org.bouncycastle.bcpg.ArmoredInputStream;
import org.bouncycastle.jcajce.provider.BouncyCastleFipsProvider;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPPublicKey;
import org.bouncycastle.openpgp.PGPPublicKeyRingCollection;
import org.bouncycastle.openpgp.PGPSignature;
import org.bouncycastle.openpgp.PGPSignatureList;
import org.bouncycastle.openpgp.PGPUtil;
import org.bouncycastle.openpgp.jcajce.JcaPGPObjectFactory;
import org.bouncycastle.openpgp.operator.KeyFingerPrintCalculator;
import org.bouncycastle.openpgp.operator.PGPContentVerifierBuilderProvider;
import org.bouncycastle.openpgp.operator.jcajce.JcaKeyFingerprintCalculator;
import org.bouncycastle.openpgp.operator.jcajce.JcaPGPContentVerifierBuilderProvider;
import org.elasticsearch.Build;
import org.elasticsearch.Version;
import org.elasticsearch.bootstrap.PluginPolicyInfo;
import org.elasticsearch.bootstrap.PolicyUtil;
import org.elasticsearch.cli.Terminal;
import org.elasticsearch.cli.UserException;
import org.elasticsearch.common.hash.MessageDigests;
import org.elasticsearch.common.io.Streams;
import org.elasticsearch.common.util.set.Sets;
import org.elasticsearch.core.SuppressForbidden;
import org.elasticsearch.core.Tuple;
import org.elasticsearch.core.internal.io.IOUtils;
import org.elasticsearch.env.Environment;
import org.elasticsearch.jdk.JarHell;
import org.elasticsearch.plugins.Platforms;
import org.elasticsearch.plugins.PluginInfo;
import org.elasticsearch.plugins.PluginsService;
import org.elasticsearch.plugins.cli.PluginDescriptor;
import org.elasticsearch.plugins.cli.PluginSecurity;
import org.elasticsearch.plugins.cli.ProgressInputStream;

class InstallPluginAction
implements Closeable {
    private static final String PROPERTY_STAGING_ID = "es.plugins.staging";
    static final int PLUGIN_EXISTS = 1;
    static final int PLUGIN_MALFORMED = 2;
    private static final Set<String> MODULES;
    static final Set<String> OFFICIAL_PLUGINS;
    static final Set<PosixFilePermission> BIN_DIR_PERMS;
    static final Set<PosixFilePermission> BIN_FILES_PERMS;
    static final Set<PosixFilePermission> CONFIG_DIR_PERMS;
    static final Set<PosixFilePermission> CONFIG_FILES_PERMS;
    static final Set<PosixFilePermission> PLUGIN_DIR_PERMS;
    static final Set<PosixFilePermission> PLUGIN_FILES_PERMS;
    private final Terminal terminal;
    private Environment env;
    private boolean batch;
    private static final String LIB_TOOLS_PLUGIN_CLI_CLASSPATH_JAR;
    private final List<Path> pathsToDeleteOnShutdown = new ArrayList<Path>();

    InstallPluginAction(Terminal terminal, Environment env, boolean batch) {
        this.terminal = terminal;
        this.env = env;
        this.batch = batch;
    }

    void execute(List<PluginDescriptor> plugins) throws Exception {
        if (plugins.isEmpty()) {
            throw new UserException(64, "at least one plugin id is required");
        }
        HashSet<String> uniquePluginIds = new HashSet<String>();
        for (PluginDescriptor plugin : plugins) {
            if (uniquePluginIds.add(plugin.getId())) continue;
            throw new UserException(64, "duplicate plugin id [" + plugin.getId() + "]");
        }
        LinkedHashMap<String, ArrayList<Path>> deleteOnFailures = new LinkedHashMap<String, ArrayList<Path>>();
        for (PluginDescriptor plugin : plugins) {
            String pluginId = plugin.getId();
            this.terminal.println((CharSequence)("-> Installing " + pluginId));
            try {
                if ("x-pack".equals(pluginId)) {
                    InstallPluginAction.handleInstallXPack(this.buildFlavor());
                }
                ArrayList<Path> deleteOnFailure = new ArrayList<Path>();
                deleteOnFailures.put(pluginId, deleteOnFailure);
                Path pluginZip = this.download(plugin, this.env.tmpFile());
                Path extractedZip = this.unzip(pluginZip, this.env.pluginsFile());
                deleteOnFailure.add(extractedZip);
                PluginInfo pluginInfo = this.installPlugin(extractedZip, deleteOnFailure);
                this.terminal.println((CharSequence)("-> Installed " + pluginInfo.getName()));
                deleteOnFailures.remove(pluginId);
                deleteOnFailures.put(pluginInfo.getName(), deleteOnFailure);
            }
            catch (Exception installProblem) {
                this.terminal.println((CharSequence)("-> Failed installing " + pluginId));
                for (Map.Entry deleteOnFailureEntry : deleteOnFailures.entrySet()) {
                    this.terminal.println((CharSequence)("-> Rolling back " + (String)deleteOnFailureEntry.getKey()));
                    boolean success = false;
                    try {
                        IOUtils.rm((Path[])((List)deleteOnFailureEntry.getValue()).toArray(new Path[0]));
                        success = true;
                    }
                    catch (IOException exceptionWhileRemovingFiles) {
                        Exception exception = new Exception("failed rolling back installation of [" + (String)deleteOnFailureEntry.getKey() + "]", exceptionWhileRemovingFiles);
                        installProblem.addSuppressed(exception);
                        this.terminal.println((CharSequence)("-> Failed rolling back " + (String)deleteOnFailureEntry.getKey()));
                    }
                    if (!success) continue;
                    this.terminal.println((CharSequence)("-> Rolled back " + (String)deleteOnFailureEntry.getKey()));
                }
                throw installProblem;
            }
        }
        this.terminal.println((CharSequence)"-> Please restart Elasticsearch to activate any plugins installed");
    }

    Build.Flavor buildFlavor() {
        return Build.CURRENT.flavor();
    }

    private static void handleInstallXPack(Build.Flavor flavor) throws UserException {
        switch (flavor) {
            case DEFAULT: {
                throw new UserException(78, "this distribution of Elasticsearch contains X-Pack by default");
            }
            case OSS: {
                throw new UserException(78, "X-Pack is not available with the oss distribution; to use X-Pack features use the default distribution");
            }
            case UNKNOWN: {
                throw new IllegalStateException("your distribution is broken");
            }
        }
    }

    private Path download(PluginDescriptor plugin, Path tmpDir) throws Exception {
        String pluginId = plugin.getId();
        if (OFFICIAL_PLUGINS.contains(pluginId)) {
            String url = this.getElasticUrl(this.getStagingHash(), Version.CURRENT, this.isSnapshot(), pluginId, Platforms.PLATFORM_NAME);
            this.terminal.println((CharSequence)("-> Downloading " + pluginId + " from elastic"));
            return this.downloadAndValidate(url, tmpDir, true);
        }
        String pluginUrl = plugin.getUrl();
        String[] coordinates = pluginUrl.split(":");
        if (coordinates.length == 3 && !pluginUrl.contains("/") && !pluginUrl.startsWith("file:")) {
            String mavenUrl = this.getMavenUrl(coordinates, Platforms.PLATFORM_NAME);
            this.terminal.println((CharSequence)("-> Downloading " + pluginId + " from maven central"));
            return this.downloadAndValidate(mavenUrl, tmpDir, false);
        }
        if (!pluginUrl.contains(":")) {
            List<String> pluginSuggestions = this.checkMisspelledPlugin(pluginId);
            String msg = "Unknown plugin " + pluginId;
            if (!pluginSuggestions.isEmpty()) {
                msg = msg + ", did you mean " + (pluginSuggestions.size() > 1 ? "any of " : "") + pluginSuggestions + "?";
            }
            throw new UserException(64, msg);
        }
        this.terminal.println((CharSequence)("-> Downloading " + URLDecoder.decode(pluginUrl, StandardCharsets.UTF_8)));
        return this.downloadZip(pluginUrl, tmpDir);
    }

    String getStagingHash() {
        return System.getProperty(PROPERTY_STAGING_ID);
    }

    boolean isSnapshot() {
        return Build.CURRENT.isSnapshot();
    }

    private String getElasticUrl(String stagingHash, Version version, boolean isSnapshot, String pluginId, String platform) throws IOException, UserException {
        if (isSnapshot && stagingHash == null) {
            throw new UserException(78, "attempted to install release build of official plugin on snapshot build of Elasticsearch");
        }
        String baseUrl = stagingHash != null ? (isSnapshot ? this.nonReleaseUrl("snapshots", version, stagingHash, pluginId) : this.nonReleaseUrl("staging", version, stagingHash, pluginId)) : String.format(Locale.ROOT, "https://artifacts.elastic.co/downloads/elasticsearch-plugins/%s", pluginId);
        String platformUrl = String.format(Locale.ROOT, "%s/%s-%s-%s.zip", baseUrl, pluginId, platform, Build.CURRENT.getQualifiedVersion());
        if (this.urlExists(platformUrl)) {
            return platformUrl;
        }
        return String.format(Locale.ROOT, "%s/%s-%s.zip", baseUrl, pluginId, Build.CURRENT.getQualifiedVersion());
    }

    private String nonReleaseUrl(String hostname, Version version, String stagingHash, String pluginId) {
        return String.format(Locale.ROOT, "https://%s.elastic.co/%s-%s/downloads/elasticsearch-plugins/%s", hostname, version, stagingHash, pluginId);
    }

    private String getMavenUrl(String[] coordinates, String platform) throws IOException {
        String groupId = coordinates[0].replace(".", "/");
        String artifactId = coordinates[1];
        String version = coordinates[2];
        String baseUrl = String.format(Locale.ROOT, "https://repo1.maven.org/maven2/%s/%s/%s", groupId, artifactId, version);
        String platformUrl = String.format(Locale.ROOT, "%s/%s-%s-%s.zip", baseUrl, artifactId, platform, version);
        if (this.urlExists(platformUrl)) {
            return platformUrl;
        }
        return String.format(Locale.ROOT, "%s/%s-%s.zip", baseUrl, artifactId, version);
    }

    @SuppressForbidden(reason="Make HEAD request using URLConnection.connect()")
    boolean urlExists(String urlString) throws IOException {
        this.terminal.println(Terminal.Verbosity.VERBOSE, (CharSequence)("Checking if url exists: " + urlString));
        URL url = new URL(urlString);
        assert ("https".equals(url.getProtocol())) : "Only http urls can be checked";
        HttpURLConnection urlConnection = (HttpURLConnection)url.openConnection();
        urlConnection.addRequestProperty("User-Agent", "elasticsearch-plugin-installer");
        urlConnection.setRequestMethod("HEAD");
        urlConnection.connect();
        return urlConnection.getResponseCode() == 200;
    }

    private List<String> checkMisspelledPlugin(String pluginId) {
        LevenshteinDistance ld = new LevenshteinDistance();
        ArrayList<Tuple> scoredKeys = new ArrayList<Tuple>();
        for (String officialPlugin : OFFICIAL_PLUGINS) {
            float distance = ld.getDistance(pluginId, officialPlugin);
            if (!(distance > 0.7f)) continue;
            scoredKeys.add(new Tuple((Object)Float.valueOf(distance), (Object)officialPlugin));
        }
        CollectionUtil.timSort(scoredKeys, (a, b) -> ((Float)b.v1()).compareTo((Float)a.v1()));
        return scoredKeys.stream().map(a -> (String)a.v2()).collect(Collectors.toList());
    }

    @SuppressForbidden(reason="We use getInputStream to download plugins")
    Path downloadZip(String urlString, Path tmpDir) throws IOException {
        this.terminal.println(Terminal.Verbosity.VERBOSE, (CharSequence)("Retrieving zip from " + urlString));
        URL url = new URL(urlString);
        Path zip = Files.createTempFile(tmpDir, null, ".zip", new FileAttribute[0]);
        URLConnection urlConnection = url.openConnection();
        urlConnection.addRequestProperty("User-Agent", "elasticsearch-plugin-installer");
        try (InputStream in = this.batch ? urlConnection.getInputStream() : new TerminalProgressInputStream(urlConnection.getInputStream(), urlConnection.getContentLength(), this.terminal);){
            Files.copy(in, zip, StandardCopyOption.REPLACE_EXISTING);
        }
        return zip;
    }

    void setEnvironment(Environment env) {
        this.env = env;
    }

    void setBatch(boolean batch) {
        this.batch = batch;
    }

    @SuppressForbidden(reason="URL#openStream")
    private InputStream urlOpenStream(URL url) throws IOException {
        return url.openStream();
    }

    private Path downloadAndValidate(String urlString, Path tmpDir, boolean officialPlugin) throws IOException, PGPException, UserException {
        String expectedChecksum;
        Path zip = this.downloadZip(urlString, tmpDir);
        this.pathsToDeleteOnShutdown.add(zip);
        String checksumUrlString = urlString + ".sha512";
        URL checksumUrl = this.openUrl(checksumUrlString);
        String digestAlgo = "SHA-512";
        if (checksumUrl == null && !officialPlugin) {
            this.terminal.println((CharSequence)"Warning: sha512 not found, falling back to sha1. This behavior is deprecated and will be removed in a future release. Please update the plugin to use a sha512 checksum.");
            checksumUrlString = urlString + ".sha1";
            checksumUrl = this.openUrl(checksumUrlString);
            digestAlgo = "SHA-1";
        }
        if (checksumUrl == null) {
            throw new UserException(74, "Plugin checksum missing: " + checksumUrlString);
        }
        try (InputStream in = this.urlOpenStream(checksumUrl);){
            BufferedReader checksumReader;
            if (digestAlgo.equals("SHA-1")) {
                checksumReader = new BufferedReader(new InputStreamReader(in, StandardCharsets.UTF_8));
                expectedChecksum = checksumReader.readLine();
                if (checksumReader.readLine() != null) {
                    throw new UserException(74, "Invalid checksum file at " + checksumUrl);
                }
            } else {
                String[] segments;
                String expectedFile;
                checksumReader = new BufferedReader(new InputStreamReader(in, StandardCharsets.UTF_8));
                String checksumLine = checksumReader.readLine();
                String[] fields = checksumLine.split(" {2}");
                if (officialPlugin && fields.length != 2 || !officialPlugin && fields.length > 2) {
                    throw new UserException(74, "Invalid checksum file at " + checksumUrl);
                }
                expectedChecksum = fields[0];
                if (fields.length == 2 && !fields[1].equals(expectedFile = (segments = URI.create(urlString).getPath().split("/"))[segments.length - 1])) {
                    String message = String.format(Locale.ROOT, "checksum file at [%s] is not for this plugin, expected [%s] but was [%s]", checksumUrl, expectedFile, fields[1]);
                    throw new UserException(74, message);
                }
                if (checksumReader.readLine() != null) {
                    throw new UserException(74, "Invalid checksum file at " + checksumUrl);
                }
            }
        }
        try (InputStream zis = Files.newInputStream(zip, new OpenOption[0]);){
            try {
                int read;
                MessageDigest digest = MessageDigest.getInstance(digestAlgo);
                byte[] bytes = new byte[8192];
                while ((read = zis.read(bytes)) != -1) {
                    assert (read > 0) : read;
                    digest.update(bytes, 0, read);
                }
                String actualChecksum = MessageDigests.toHexString((byte[])digest.digest());
                if (!expectedChecksum.equals(actualChecksum)) {
                    throw new UserException(74, digestAlgo + " mismatch, expected " + expectedChecksum + " but got " + actualChecksum);
                }
            }
            catch (NoSuchAlgorithmException e) {
                throw new AssertionError((Object)e);
            }
        }
        if (officialPlugin) {
            this.verifySignature(zip, urlString);
        }
        return zip;
    }

    void verifySignature(Path zip, String urlString) throws IOException, PGPException {
        String ascUrlString = urlString + ".asc";
        URL ascUrl = this.openUrl(ascUrlString);
        try (InputStream fin = this.pluginZipInputStream(zip);
             InputStream sin = this.urlOpenStream(ascUrl);
             ArmoredInputStream ain = new ArmoredInputStream(this.getPublicKey());){
            int read;
            JcaPGPObjectFactory factory = new JcaPGPObjectFactory(PGPUtil.getDecoderStream((InputStream)sin));
            PGPSignature signature = ((PGPSignatureList)factory.nextObject()).get(0);
            String keyId = Long.toHexString(signature.getKeyID()).toUpperCase(Locale.ROOT);
            if (!this.getPublicKeyId().equals(keyId)) {
                throw new IllegalStateException("key id [" + keyId + "] does not match expected key id [" + this.getPublicKeyId() + "]");
            }
            PGPPublicKeyRingCollection collection = new PGPPublicKeyRingCollection((InputStream)ain, (KeyFingerPrintCalculator)new JcaKeyFingerprintCalculator());
            PGPPublicKey key = collection.getPublicKey(signature.getKeyID());
            signature.init((PGPContentVerifierBuilderProvider)new JcaPGPContentVerifierBuilderProvider().setProvider((Provider)new BouncyCastleFipsProvider()), key);
            byte[] buffer = new byte[1024];
            while ((read = fin.read(buffer)) != -1) {
                signature.update(buffer, 0, read);
            }
            if (!signature.verify()) {
                throw new IllegalStateException("signature verification for [" + urlString + "] failed");
            }
        }
    }

    InputStream pluginZipInputStream(Path zip) throws IOException {
        return Files.newInputStream(zip, new OpenOption[0]);
    }

    String getPublicKeyId() {
        return "D27D666CD88E42B4";
    }

    InputStream getPublicKey() {
        return InstallPluginAction.class.getResourceAsStream("/public_key.asc");
    }

    URL openUrl(String urlString) throws IOException {
        URL checksumUrl = new URL(urlString);
        HttpURLConnection connection = (HttpURLConnection)checksumUrl.openConnection();
        if (connection.getResponseCode() == 404) {
            return null;
        }
        return checksumUrl;
    }

    private Path unzip(Path zip, Path pluginsDir) throws IOException, UserException {
        Path target = this.stagingDirectory(pluginsDir);
        this.pathsToDeleteOnShutdown.add(target);
        try (ZipInputStream zipInput = new ZipInputStream(Files.newInputStream(zip, new OpenOption[0]));){
            ZipEntry entry;
            byte[] buffer = new byte[8192];
            while ((entry = zipInput.getNextEntry()) != null) {
                if (entry.getName().startsWith("elasticsearch/")) {
                    throw new UserException(2, "This plugin was built with an older plugin structure. Contact the plugin author to remove the intermediate \"elasticsearch\" directory within the plugin zip.");
                }
                Path targetFile = target.resolve(entry.getName());
                if (!targetFile.normalize().startsWith(target)) {
                    throw new UserException(2, "Zip contains entry name '" + entry.getName() + "' resolving outside of plugin directory");
                }
                if (!Files.isSymbolicLink(targetFile.getParent())) {
                    Files.createDirectories(targetFile.getParent(), new FileAttribute[0]);
                }
                if (!entry.isDirectory()) {
                    try (OutputStream out = Files.newOutputStream(targetFile, new OpenOption[0]);){
                        int len;
                        while ((len = zipInput.read(buffer)) >= 0) {
                            out.write(buffer, 0, len);
                        }
                    }
                }
                zipInput.closeEntry();
            }
        }
        catch (UserException e) {
            IOUtils.rm((Path[])new Path[]{target});
            throw e;
        }
        Files.delete(zip);
        return target;
    }

    private Path stagingDirectory(Path pluginsDir) throws IOException {
        try {
            return Files.createTempDirectory(pluginsDir, ".installing-", PosixFilePermissions.asFileAttribute(PLUGIN_DIR_PERMS));
        }
        catch (UnsupportedOperationException e) {
            return this.stagingDirectoryWithoutPosixPermissions(pluginsDir);
        }
    }

    private Path stagingDirectoryWithoutPosixPermissions(Path pluginsDir) throws IOException {
        return Files.createTempDirectory(pluginsDir, ".installing-", new FileAttribute[0]);
    }

    private void verifyPluginName(Path pluginPath, String pluginName) throws UserException, IOException {
        if (MODULES.contains(pluginName)) {
            throw new UserException(64, "plugin '" + pluginName + "' cannot be installed as a plugin, it is a system module");
        }
        Path destination = pluginPath.resolve(pluginName);
        if (Files.exists(destination, new LinkOption[0])) {
            String message = String.format(Locale.ROOT, "plugin directory [%s] already exists; if you need to update the plugin, uninstall it first using command 'remove %s'", destination, pluginName);
            throw new UserException(1, message);
        }
    }

    private PluginInfo loadPluginInfo(Path pluginRoot) throws Exception {
        PluginInfo info = PluginInfo.readFromProperties((Path)pluginRoot);
        if (info.hasNativeController()) {
            throw new IllegalStateException("plugins can not have native controllers");
        }
        PluginsService.verifyCompatibility((PluginInfo)info);
        this.verifyPluginName(this.env.pluginsFile(), info.getName());
        PluginsService.checkForFailedPluginRemovals((Path)this.env.pluginsFile());
        this.terminal.println(Terminal.Verbosity.VERBOSE, (CharSequence)info.toString());
        this.jarHellCheck(info, pluginRoot, this.env.pluginsFile(), this.env.modulesFile());
        return info;
    }

    void jarHellCheck(PluginInfo candidateInfo, Path candidateDir, Path pluginsDir, Path modulesDir) throws Exception {
        Set classpath = JarHell.parseClassPath().stream().filter(url -> {
            try {
                return !url.toURI().getPath().matches(LIB_TOOLS_PLUGIN_CLI_CLASSPATH_JAR);
            }
            catch (URISyntaxException e) {
                throw new AssertionError((Object)e);
            }
        }).collect(Collectors.toSet());
        HashSet<PluginsService.Bundle> bundles = new HashSet<PluginsService.Bundle>(PluginsService.getPluginBundles((Path)pluginsDir));
        bundles.addAll(PluginsService.getModuleBundles((Path)modulesDir));
        bundles.add(new PluginsService.Bundle(candidateInfo, candidateDir));
        List sortedBundles = PluginsService.sortBundles(bundles);
        HashMap transitiveUrls = new HashMap();
        for (PluginsService.Bundle bundle : sortedBundles) {
            PluginsService.checkBundleJarHell(classpath, (PluginsService.Bundle)bundle, transitiveUrls);
        }
    }

    private PluginInfo installPlugin(Path tmpRoot, List<Path> deleteOnFailure) throws Exception {
        PluginInfo info = this.loadPluginInfo(tmpRoot);
        InstallPluginAction.checkCanInstallationProceed(this.terminal, Build.CURRENT.flavor(), info);
        PluginPolicyInfo pluginPolicy = PolicyUtil.getPluginPolicyInfo((Path)tmpRoot, (Path)this.env.tmpFile());
        if (pluginPolicy != null) {
            Set<String> permissions = PluginSecurity.getPermissionDescriptions(pluginPolicy, this.env.tmpFile());
            PluginSecurity.confirmPolicyExceptions(this.terminal, permissions, this.batch);
        }
        Path destination = this.env.pluginsFile().resolve(info.getName());
        deleteOnFailure.add(destination);
        this.installPluginSupportFiles(info, tmpRoot, this.env.binFile().resolve(info.getName()), this.env.configFile().resolve(info.getName()), deleteOnFailure);
        this.movePlugin(tmpRoot, destination);
        return info;
    }

    private void installPluginSupportFiles(PluginInfo info, Path tmpRoot, Path destBinDir, Path destConfigDir, List<Path> deleteOnFailure) throws Exception {
        Path tmpConfigDir;
        Path tmpBinDir = tmpRoot.resolve("bin");
        if (Files.exists(tmpBinDir, new LinkOption[0])) {
            deleteOnFailure.add(destBinDir);
            this.installBin(info, tmpBinDir, destBinDir);
        }
        if (Files.exists(tmpConfigDir = tmpRoot.resolve("config"), new LinkOption[0])) {
            this.installConfig(info, tmpConfigDir, destConfigDir);
        }
    }

    private void movePlugin(Path tmpRoot, Path destination) throws IOException {
        Files.move(tmpRoot, destination, StandardCopyOption.ATOMIC_MOVE);
        Files.walkFileTree(destination, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                String parentDirName = file.getParent().getFileName().toString();
                if ("bin".equals(parentDirName) || Constants.MAC_OS_X && "MacOS".equals(parentDirName)) {
                    InstallPluginAction.setFileAttributes(file, BIN_FILES_PERMS);
                } else {
                    InstallPluginAction.setFileAttributes(file, PLUGIN_FILES_PERMS);
                }
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                InstallPluginAction.setFileAttributes(dir, PLUGIN_DIR_PERMS);
                return FileVisitResult.CONTINUE;
            }
        });
    }

    private void installBin(PluginInfo info, Path tmpBinDir, Path destBinDir) throws Exception {
        if (!Files.isDirectory(tmpBinDir, new LinkOption[0])) {
            throw new UserException(2, "bin in plugin " + info.getName() + " is not a directory");
        }
        Files.createDirectories(destBinDir, new FileAttribute[0]);
        InstallPluginAction.setFileAttributes(destBinDir, BIN_DIR_PERMS);
        try (DirectoryStream<Path> stream = Files.newDirectoryStream(tmpBinDir);){
            for (Path srcFile : stream) {
                if (Files.isDirectory(srcFile, new LinkOption[0])) {
                    throw new UserException(2, "Directories not allowed in bin dir for plugin " + info.getName() + ", found " + srcFile.getFileName());
                }
                Path destFile = destBinDir.resolve(tmpBinDir.relativize(srcFile));
                Files.copy(srcFile, destFile, new CopyOption[0]);
                InstallPluginAction.setFileAttributes(destFile, BIN_FILES_PERMS);
            }
        }
        IOUtils.rm((Path[])new Path[]{tmpBinDir});
    }

    private void installConfig(PluginInfo info, Path tmpConfigDir, Path destConfigDir) throws Exception {
        PosixFileAttributes destConfigDirAttributes;
        if (!Files.isDirectory(tmpConfigDir, new LinkOption[0])) {
            throw new UserException(2, "config in plugin " + info.getName() + " is not a directory");
        }
        Files.createDirectories(destConfigDir, new FileAttribute[0]);
        InstallPluginAction.setFileAttributes(destConfigDir, CONFIG_DIR_PERMS);
        PosixFileAttributeView destConfigDirAttributesView = Files.getFileAttributeView(destConfigDir.getParent(), PosixFileAttributeView.class, new LinkOption[0]);
        PosixFileAttributes posixFileAttributes = destConfigDirAttributes = destConfigDirAttributesView != null ? destConfigDirAttributesView.readAttributes() : null;
        if (destConfigDirAttributes != null) {
            InstallPluginAction.setOwnerGroup(destConfigDir, destConfigDirAttributes);
        }
        try (DirectoryStream<Path> stream = Files.newDirectoryStream(tmpConfigDir);){
            for (Path srcFile : stream) {
                if (Files.isDirectory(srcFile, new LinkOption[0])) {
                    throw new UserException(2, "Directories not allowed in config dir for plugin " + info.getName());
                }
                Path destFile = destConfigDir.resolve(tmpConfigDir.relativize(srcFile));
                if (Files.exists(destFile, new LinkOption[0])) continue;
                Files.copy(srcFile, destFile, new CopyOption[0]);
                InstallPluginAction.setFileAttributes(destFile, CONFIG_FILES_PERMS);
                if (destConfigDirAttributes == null) continue;
                InstallPluginAction.setOwnerGroup(destFile, destConfigDirAttributes);
            }
        }
        IOUtils.rm((Path[])new Path[]{tmpConfigDir});
    }

    private static void setOwnerGroup(Path path, PosixFileAttributes attributes) throws IOException {
        Objects.requireNonNull(attributes);
        PosixFileAttributeView fileAttributeView = Files.getFileAttributeView(path, PosixFileAttributeView.class, new LinkOption[0]);
        assert (fileAttributeView != null);
        fileAttributeView.setOwner(attributes.owner());
        fileAttributeView.setGroup(attributes.group());
    }

    private static void setFileAttributes(Path path, Set<PosixFilePermission> permissions) throws IOException {
        PosixFileAttributeView fileAttributeView = Files.getFileAttributeView(path, PosixFileAttributeView.class, new LinkOption[0]);
        if (fileAttributeView != null) {
            Files.setPosixFilePermissions(path, permissions);
        }
    }

    @Override
    public void close() throws IOException {
        IOUtils.rm((Path[])this.pathsToDeleteOnShutdown.toArray(new Path[this.pathsToDeleteOnShutdown.size()]));
    }

    static void checkCanInstallationProceed(Terminal terminal, Build.Flavor flavor, PluginInfo info) throws Exception {
        if (!info.isLicensed()) {
            return;
        }
        if (flavor == Build.Flavor.DEFAULT) {
            return;
        }
        List.of("@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@", "@            ERROR: This is a licensed plugin             @", "@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@", "", "This plugin is covered by the Elastic license, but this", "installation of Elasticsearch is: [" + flavor + "].").forEach(arg_0 -> ((Terminal)terminal).errorPrintln(arg_0));
        throw new UserException(77, "Plugin license is incompatible with [" + flavor + "] installation");
    }

    static {
        InputStream stream;
        try {
            stream = InstallPluginAction.class.getResourceAsStream("/modules.txt");
            try {
                MODULES = Streams.readAllLines((InputStream)stream).stream().map(String::trim).collect(Collectors.toUnmodifiableSet());
            }
            finally {
                if (stream != null) {
                    stream.close();
                }
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        try {
            stream = InstallPluginAction.class.getResourceAsStream("/plugins.txt");
            try {
                OFFICIAL_PLUGINS = (Set)Streams.readAllLines((InputStream)stream).stream().map(String::trim).collect(Sets.toUnmodifiableSortedSet());
            }
            finally {
                if (stream != null) {
                    stream.close();
                }
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        BIN_DIR_PERMS = Collections.unmodifiableSet(PosixFilePermissions.fromString("rwxr-xr-x"));
        BIN_FILES_PERMS = BIN_DIR_PERMS;
        CONFIG_DIR_PERMS = Collections.unmodifiableSet(PosixFilePermissions.fromString("rwxr-x---"));
        CONFIG_FILES_PERMS = Collections.unmodifiableSet(PosixFilePermissions.fromString("rw-rw----"));
        PLUGIN_DIR_PERMS = BIN_DIR_PERMS;
        PLUGIN_FILES_PERMS = Collections.unmodifiableSet(PosixFilePermissions.fromString("rw-r--r--"));
        LIB_TOOLS_PLUGIN_CLI_CLASSPATH_JAR = String.format(Locale.ROOT, ".+%1$slib%1$stools%1$splugin-cli%1$s[^%1$s]+\\.jar", "(/|\\\\)");
    }

    private class TerminalProgressInputStream
    extends ProgressInputStream {
        private final Terminal terminal;
        private int width;
        private final boolean enabled;

        TerminalProgressInputStream(InputStream is, int expectedTotalSize, Terminal terminal) {
            super(is, expectedTotalSize);
            this.width = 50;
            this.terminal = terminal;
            this.enabled = expectedTotalSize > 0;
        }

        @Override
        public void onProgress(int percent) {
            if (this.enabled) {
                int currentPosition = percent * this.width / 100;
                StringBuilder sb = new StringBuilder("\r[");
                sb.append(String.join((CharSequence)"=", Collections.nCopies(currentPosition, "")));
                if (currentPosition > 0 && percent < 100) {
                    sb.append(">");
                }
                sb.append(String.join((CharSequence)" ", Collections.nCopies(this.width - currentPosition, "")));
                sb.append("] %s\u00a0\u00a0 ");
                if (percent == 100) {
                    sb.append("\n");
                }
                this.terminal.print(Terminal.Verbosity.NORMAL, String.format(Locale.ROOT, sb.toString(), percent + "%"));
            }
        }
    }
}

