/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ilm;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.LongSupplier;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.client.Client;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.index.Index;
import org.elasticsearch.license.XPackLicenseState;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.json.JsonXContent;
import org.elasticsearch.xpack.core.ilm.IndexLifecycleMetadata;
import org.elasticsearch.xpack.core.ilm.InitializePolicyContextStep;
import org.elasticsearch.xpack.core.ilm.InitializePolicyException;
import org.elasticsearch.xpack.core.ilm.LifecycleExecutionState;
import org.elasticsearch.xpack.core.ilm.LifecyclePolicy;
import org.elasticsearch.xpack.core.ilm.LifecyclePolicyMetadata;
import org.elasticsearch.xpack.core.ilm.LifecycleSettings;
import org.elasticsearch.xpack.core.ilm.Phase;
import org.elasticsearch.xpack.core.ilm.PhaseExecutionInfo;
import org.elasticsearch.xpack.core.ilm.RolloverAction;
import org.elasticsearch.xpack.core.ilm.Step;
import org.elasticsearch.xpack.core.ilm.TerminalPolicyStep;
import org.elasticsearch.xpack.ilm.PolicyStepsRegistry;

public final class IndexLifecycleTransition {
    private static final Logger logger = LogManager.getLogger(IndexLifecycleTransition.class);
    private static final ToXContent.Params STACKTRACE_PARAMS = new ToXContent.MapParams(Collections.singletonMap("rest.exception.stacktrace.skip", "false"));

    public static void validateTransition(IndexMetadata idxMeta, Step.StepKey currentStepKey, Step.StepKey newStepKey, PolicyStepsRegistry stepRegistry) {
        boolean isNewStepCached;
        String indexName = idxMeta.getIndex().getName();
        Settings indexSettings = idxMeta.getSettings();
        String indexPolicySetting = (String)LifecycleSettings.LIFECYCLE_NAME_SETTING.get(indexSettings);
        if (Strings.isNullOrEmpty((String)indexPolicySetting)) {
            throw new IllegalArgumentException("index [" + indexName + "] is not associated with an Index Lifecycle Policy");
        }
        LifecycleExecutionState lifecycleState = LifecycleExecutionState.fromIndexMetadata((IndexMetadata)idxMeta);
        Step.StepKey realKey = LifecycleExecutionState.getCurrentStepKey((LifecycleExecutionState)lifecycleState);
        if (currentStepKey != null && !currentStepKey.equals((Object)realKey)) {
            throw new IllegalArgumentException("index [" + indexName + "] is not on current step [" + currentStepKey + "], currently: [" + realKey + "]");
        }
        Set<Step.StepKey> cachedStepKeys = stepRegistry.parseStepKeysFromPhase(lifecycleState.getPhaseDefinition(), lifecycleState.getPhase());
        boolean bl = isNewStepCached = cachedStepKeys != null && cachedStepKeys.contains(newStepKey);
        if (!(isNewStepCached || stepRegistry.stepExists(indexPolicySetting, newStepKey) || newStepKey.equals((Object)TerminalPolicyStep.KEY))) {
            throw new IllegalArgumentException("step [" + newStepKey + "] for index [" + idxMeta.getIndex().getName() + "] with policy [" + indexPolicySetting + "] does not exist");
        }
    }

    static ClusterState moveClusterStateToStep(Index index, ClusterState state, Step.StepKey newStepKey, LongSupplier nowSupplier, PolicyStepsRegistry stepRegistry, boolean forcePhaseDefinitionRefresh) {
        IndexMetadata idxMeta = state.getMetadata().index(index);
        Step.StepKey currentStepKey = LifecycleExecutionState.getCurrentStepKey((LifecycleExecutionState)LifecycleExecutionState.fromIndexMetadata((IndexMetadata)idxMeta));
        IndexLifecycleTransition.validateTransition(idxMeta, currentStepKey, newStepKey, stepRegistry);
        Settings indexSettings = idxMeta.getSettings();
        String policy = (String)LifecycleSettings.LIFECYCLE_NAME_SETTING.get(indexSettings);
        logger.info("moving index [{}] from [{}] to [{}] in policy [{}]", (Object)index.getName(), (Object)currentStepKey, (Object)newStepKey, (Object)policy);
        IndexLifecycleMetadata ilmMeta = (IndexLifecycleMetadata)state.metadata().custom("index_lifecycle");
        LifecyclePolicyMetadata policyMetadata = (LifecyclePolicyMetadata)ilmMeta.getPolicyMetadatas().get(LifecycleSettings.LIFECYCLE_NAME_SETTING.get(idxMeta.getSettings()));
        LifecycleExecutionState lifecycleState = LifecycleExecutionState.fromIndexMetadata((IndexMetadata)idxMeta);
        LifecycleExecutionState newLifecycleState = IndexLifecycleTransition.updateExecutionStateToStep(policyMetadata, lifecycleState, newStepKey, nowSupplier, forcePhaseDefinitionRefresh);
        ClusterState.Builder newClusterStateBuilder = IndexLifecycleTransition.newClusterStateWithLifecycleState(index, state, newLifecycleState);
        return newClusterStateBuilder.build();
    }

    static ClusterState moveClusterStateToErrorStep(Index index, ClusterState clusterState, Exception cause, LongSupplier nowSupplier, BiFunction<IndexMetadata, Step.StepKey, Step> stepLookupFunction) throws IOException {
        IndexMetadata idxMeta = clusterState.getMetadata().index(index);
        IndexLifecycleMetadata ilmMeta = (IndexLifecycleMetadata)clusterState.metadata().custom("index_lifecycle");
        LifecyclePolicyMetadata policyMetadata = (LifecyclePolicyMetadata)ilmMeta.getPolicyMetadatas().get(LifecycleSettings.LIFECYCLE_NAME_SETTING.get(idxMeta.getSettings()));
        XContentBuilder causeXContentBuilder = JsonXContent.contentBuilder();
        causeXContentBuilder.startObject();
        ElasticsearchException.generateThrowableXContent((XContentBuilder)causeXContentBuilder, (ToXContent.Params)STACKTRACE_PARAMS, (Throwable)cause);
        causeXContentBuilder.endObject();
        LifecycleExecutionState currentState = LifecycleExecutionState.fromIndexMetadata((IndexMetadata)idxMeta);
        Step.StepKey currentStep = cause instanceof InitializePolicyException ? InitializePolicyContextStep.KEY : Objects.requireNonNull(LifecycleExecutionState.getCurrentStepKey((LifecycleExecutionState)currentState), "unable to move to an error step where there is no current step, state: " + currentState);
        LifecycleExecutionState nextStepState = IndexLifecycleTransition.updateExecutionStateToStep(policyMetadata, currentState, new Step.StepKey(currentStep.getPhase(), currentStep.getAction(), "ERROR"), nowSupplier, false);
        LifecycleExecutionState.Builder failedState = LifecycleExecutionState.builder((LifecycleExecutionState)nextStepState);
        failedState.setFailedStep(currentStep.getName());
        failedState.setStepInfo(BytesReference.bytes((XContentBuilder)causeXContentBuilder).utf8ToString());
        Step failedStep = stepLookupFunction.apply(idxMeta, currentStep);
        if (failedStep != null) {
            failedState.setIsAutoRetryableError(Boolean.valueOf(failedStep.isRetryable()));
            failedState.setFailedStepRetryCount(currentState.getFailedStepRetryCount());
        } else {
            logger.warn("failed step [{}] for index [{}] is not part of policy [{}] anymore, or it is invalid", (Object)currentStep.getName(), (Object)index, (Object)policyMetadata.getName());
        }
        ClusterState.Builder newClusterStateBuilder = IndexLifecycleTransition.newClusterStateWithLifecycleState(index, clusterState, failedState.build());
        return newClusterStateBuilder.build();
    }

    static ClusterState moveClusterStateToPreviouslyFailedStep(ClusterState currentState, String index, LongSupplier nowSupplier, PolicyStepsRegistry stepRegistry, boolean isAutomaticRetry) {
        LifecycleExecutionState.Builder retryStepState;
        IndexMetadata indexMetadata = currentState.metadata().index(index);
        if (indexMetadata == null) {
            throw new IllegalArgumentException("index [" + index + "] does not exist");
        }
        LifecycleExecutionState lifecycleState = LifecycleExecutionState.fromIndexMetadata((IndexMetadata)indexMetadata);
        Step.StepKey currentStepKey = LifecycleExecutionState.getCurrentStepKey((LifecycleExecutionState)lifecycleState);
        String failedStep = lifecycleState.getFailedStep();
        if (currentStepKey != null && "ERROR".equals(currentStepKey.getName()) && !Strings.isNullOrEmpty((String)failedStep)) {
            Step.StepKey nextStepKey = new Step.StepKey(currentStepKey.getPhase(), currentStepKey.getAction(), failedStep);
            IndexLifecycleTransition.validateTransition(indexMetadata, currentStepKey, nextStepKey, stepRegistry);
            IndexLifecycleMetadata ilmMeta = (IndexLifecycleMetadata)currentState.metadata().custom("index_lifecycle");
            LifecyclePolicyMetadata policyMetadata = (LifecyclePolicyMetadata)ilmMeta.getPolicyMetadatas().get(LifecycleSettings.LIFECYCLE_NAME_SETTING.get(indexMetadata.getSettings()));
            LifecycleExecutionState nextStepState = IndexLifecycleTransition.updateExecutionStateToStep(policyMetadata, lifecycleState, nextStepKey, nowSupplier, true);
            retryStepState = LifecycleExecutionState.builder((LifecycleExecutionState)nextStepState);
            retryStepState.setIsAutoRetryableError(lifecycleState.isAutoRetryableError());
            Integer currentRetryCount = lifecycleState.getFailedStepRetryCount();
            if (isAutomaticRetry) {
                int n;
                if (currentRetryCount == null) {
                    n = 1;
                } else {
                    currentRetryCount = currentRetryCount + 1;
                    n = currentRetryCount;
                }
                retryStepState.setFailedStepRetryCount(Integer.valueOf(n));
            } else {
                retryStepState.setFailedStepRetryCount(lifecycleState.getFailedStepRetryCount());
            }
        } else {
            throw new IllegalArgumentException("cannot retry an action for an index [" + index + "] that has not encountered an error when running a Lifecycle Policy");
        }
        ClusterState newState = IndexLifecycleTransition.newClusterStateWithLifecycleState(indexMetadata.getIndex(), currentState, retryStepState.build()).build();
        return newState;
    }

    private static LifecycleExecutionState updateExecutionStateToStep(LifecyclePolicyMetadata policyMetadata, LifecycleExecutionState existingState, Step.StepKey newStep, LongSupplier nowSupplier, boolean forcePhaseDefinitionRefresh) {
        Step.StepKey currentStep = LifecycleExecutionState.getCurrentStepKey((LifecycleExecutionState)existingState);
        long nowAsMillis = nowSupplier.getAsLong();
        LifecycleExecutionState.Builder updatedState = LifecycleExecutionState.builder((LifecycleExecutionState)existingState);
        updatedState.setPhase(newStep.getPhase());
        updatedState.setAction(newStep.getAction());
        updatedState.setStep(newStep.getName());
        updatedState.setStepTime(Long.valueOf(nowAsMillis));
        updatedState.setFailedStep(null);
        updatedState.setStepInfo(null);
        updatedState.setIsAutoRetryableError(null);
        updatedState.setFailedStepRetryCount(null);
        if (currentStep == null || !currentStep.getPhase().equals(newStep.getPhase()) || forcePhaseDefinitionRefresh) {
            Phase nextPhase = "new".equals(newStep.getPhase()) || TerminalPolicyStep.KEY.equals((Object)newStep) ? null : (Phase)policyMetadata.getPolicy().getPhases().get(newStep.getPhase());
            PhaseExecutionInfo phaseExecutionInfo = new PhaseExecutionInfo(policyMetadata.getName(), nextPhase, policyMetadata.getVersion(), policyMetadata.getModifiedDate());
            String newPhaseDefinition = Strings.toString((ToXContent)phaseExecutionInfo, (boolean)false, (boolean)false);
            updatedState.setPhaseDefinition(newPhaseDefinition);
            updatedState.setPhaseTime(Long.valueOf(nowAsMillis));
        } else if (currentStep.getPhase().equals("new")) {
            updatedState.setPhaseTime(Long.valueOf(nowAsMillis));
        }
        if (currentStep == null || !currentStep.getAction().equals(newStep.getAction())) {
            updatedState.setActionTime(Long.valueOf(nowAsMillis));
        }
        return updatedState.build();
    }

    public static LifecycleExecutionState moveStateToNextActionAndUpdateCachedPhase(IndexMetadata indexMetadata, LifecycleExecutionState existingState, LongSupplier nowSupplier, LifecyclePolicy oldPolicy, LifecyclePolicyMetadata newPolicyMetadata, Client client, XPackLicenseState licenseState) {
        String policyName = (String)LifecycleSettings.LIFECYCLE_NAME_SETTING.get(indexMetadata.getSettings());
        Step.StepKey currentStepKey = LifecycleExecutionState.getCurrentStepKey((LifecycleExecutionState)existingState);
        if (currentStepKey == null) {
            logger.warn("unable to identify what the current step is for index [{}] as part of policy [{}]. the cached phase definition will not be updated for this index", (Object)indexMetadata.getIndex().getName(), (Object)policyName);
            return existingState;
        }
        List policySteps = oldPolicy.toSteps(client, licenseState);
        Optional<Step> currentStep = policySteps.stream().filter(step -> step.getKey().equals((Object)currentStepKey)).findFirst();
        if (!currentStep.isPresent()) {
            logger.warn("unable to find current step [{}] for index [{}] as part of policy [{}]. the cached phase definition will not be updated for this index", (Object)currentStepKey, (Object)indexMetadata.getIndex().getName(), (Object)policyName);
            return existingState;
        }
        int indexOfCurrentStep = policySteps.indexOf(currentStep.get());
        assert (indexOfCurrentStep != -1) : "the current step must be part of the old policy";
        Optional<Step> nextStepInActionAfterCurrent = policySteps.stream().skip(indexOfCurrentStep).filter(step -> !step.getKey().getAction().equals(currentStepKey.getAction())).findFirst();
        assert (nextStepInActionAfterCurrent.isPresent()) : "there should always be a complete step at the end of every phase";
        Step.StepKey nextStep = nextStepInActionAfterCurrent.get().getKey();
        logger.debug("moving index [{}] in policy [{}] out of step [{}] to new step [{}]", (Object)indexMetadata.getIndex().getName(), (Object)policyName, (Object)currentStepKey, (Object)nextStep);
        long nowAsMillis = nowSupplier.getAsLong();
        LifecycleExecutionState.Builder updatedState = LifecycleExecutionState.builder((LifecycleExecutionState)existingState);
        updatedState.setPhase(nextStep.getPhase());
        updatedState.setAction(nextStep.getAction());
        updatedState.setActionTime(Long.valueOf(nowAsMillis));
        updatedState.setStep(nextStep.getName());
        updatedState.setStepTime(Long.valueOf(nowAsMillis));
        updatedState.setFailedStep(null);
        updatedState.setStepInfo(null);
        updatedState.setIsAutoRetryableError(null);
        updatedState.setFailedStepRetryCount(null);
        PhaseExecutionInfo phaseExecutionInfo = new PhaseExecutionInfo(newPolicyMetadata.getPolicy().getName(), (Phase)newPolicyMetadata.getPolicy().getPhases().get(currentStepKey.getPhase()), newPolicyMetadata.getVersion(), newPolicyMetadata.getModifiedDate());
        updatedState.setPhaseDefinition(Strings.toString((ToXContent)phaseExecutionInfo, (boolean)false, (boolean)false));
        return updatedState.build();
    }

    public static ClusterState.Builder newClusterStateWithLifecycleState(Index index, ClusterState clusterState, LifecycleExecutionState lifecycleState) {
        ClusterState.Builder newClusterStateBuilder = ClusterState.builder((ClusterState)clusterState);
        newClusterStateBuilder.metadata(Metadata.builder((Metadata)clusterState.getMetadata()).put(IndexMetadata.builder((IndexMetadata)clusterState.getMetadata().index(index)).putCustom("ilm", lifecycleState.asMap())).build(false));
        return newClusterStateBuilder;
    }

    static ClusterState addStepInfoToClusterState(Index index, ClusterState clusterState, ToXContentObject stepInfo) throws IOException {
        String stepInfoString;
        IndexMetadata indexMetadata = clusterState.getMetadata().index(index);
        if (indexMetadata == null) {
            return clusterState;
        }
        LifecycleExecutionState lifecycleState = LifecycleExecutionState.fromIndexMetadata((IndexMetadata)indexMetadata);
        try (XContentBuilder infoXContentBuilder = JsonXContent.contentBuilder();){
            stepInfo.toXContent(infoXContentBuilder, ToXContent.EMPTY_PARAMS);
            stepInfoString = BytesReference.bytes((XContentBuilder)infoXContentBuilder).utf8ToString();
        }
        if (stepInfoString.equals(lifecycleState.getStepInfo())) {
            return clusterState;
        }
        LifecycleExecutionState.Builder newState = LifecycleExecutionState.builder((LifecycleExecutionState)lifecycleState);
        newState.setStepInfo(stepInfoString);
        ClusterState.Builder newClusterStateBuilder = IndexLifecycleTransition.newClusterStateWithLifecycleState(index, clusterState, newState.build());
        return newClusterStateBuilder.build();
    }

    public static ClusterState removePolicyForIndexes(Index[] indices, ClusterState currentState, List<String> failedIndexes) {
        Metadata.Builder newMetadata = Metadata.builder((Metadata)currentState.getMetadata());
        boolean clusterStateChanged = false;
        for (Index index : indices) {
            IndexMetadata indexMetadata = currentState.getMetadata().index(index);
            if (indexMetadata == null) {
                failedIndexes.add(index.getName());
                continue;
            }
            IndexMetadata.Builder newIdxMetadata = IndexLifecycleTransition.removePolicyForIndex(indexMetadata);
            if (newIdxMetadata == null) continue;
            newMetadata.put(newIdxMetadata);
            clusterStateChanged = true;
        }
        if (clusterStateChanged) {
            ClusterState.Builder newClusterState = ClusterState.builder((ClusterState)currentState);
            newClusterState.metadata(newMetadata);
            return newClusterState.build();
        }
        return currentState;
    }

    private static IndexMetadata.Builder removePolicyForIndex(IndexMetadata indexMetadata) {
        Settings idxSettings = indexMetadata.getSettings();
        Settings.Builder newSettings = Settings.builder().put(idxSettings);
        boolean notChanged = true;
        notChanged &= Strings.isNullOrEmpty((String)newSettings.remove(LifecycleSettings.LIFECYCLE_NAME_SETTING.getKey()));
        notChanged &= Strings.isNullOrEmpty((String)newSettings.remove(LifecycleSettings.LIFECYCLE_INDEXING_COMPLETE_SETTING.getKey()));
        long newSettingsVersion = (notChanged &= Strings.isNullOrEmpty((String)newSettings.remove(RolloverAction.LIFECYCLE_ROLLOVER_ALIAS_SETTING.getKey()))) ? indexMetadata.getSettingsVersion() : 1L + indexMetadata.getSettingsVersion();
        IndexMetadata.Builder builder = IndexMetadata.builder((IndexMetadata)indexMetadata);
        builder.removeCustom("ilm");
        return builder.settings(newSettings).settingsVersion(newSettingsVersion);
    }
}

