/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.unboundidds.tools;

import com.unboundid.ldap.sdk.Control;
import com.unboundid.ldap.sdk.DN;
import com.unboundid.ldap.sdk.ExtendedResult;
import com.unboundid.ldap.sdk.LDAPConnection;
import com.unboundid.ldap.sdk.LDAPConnectionOptions;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.ldap.sdk.UnsolicitedNotificationHandler;
import com.unboundid.ldap.sdk.controls.ManageDsaITRequestControl;
import com.unboundid.ldap.sdk.controls.PermissiveModifyRequestControl;
import com.unboundid.ldap.sdk.controls.ProxiedAuthorizationV1RequestControl;
import com.unboundid.ldap.sdk.controls.ProxiedAuthorizationV2RequestControl;
import com.unboundid.ldap.sdk.unboundidds.controls.AssuredReplicationLocalLevel;
import com.unboundid.ldap.sdk.unboundidds.controls.AssuredReplicationRemoteLevel;
import com.unboundid.ldap.sdk.unboundidds.controls.AssuredReplicationRequestControl;
import com.unboundid.ldap.sdk.unboundidds.controls.HardDeleteRequestControl;
import com.unboundid.ldap.sdk.unboundidds.controls.IgnoreNoUserModificationRequestControl;
import com.unboundid.ldap.sdk.unboundidds.controls.NameWithEntryUUIDRequestControl;
import com.unboundid.ldap.sdk.unboundidds.controls.OperationPurposeRequestControl;
import com.unboundid.ldap.sdk.unboundidds.controls.PasswordUpdateBehaviorRequestControl;
import com.unboundid.ldap.sdk.unboundidds.controls.PasswordUpdateBehaviorRequestControlProperties;
import com.unboundid.ldap.sdk.unboundidds.controls.ReplicationRepairRequestControl;
import com.unboundid.ldap.sdk.unboundidds.controls.SoftDeleteRequestControl;
import com.unboundid.ldap.sdk.unboundidds.controls.SuppressOperationalAttributeUpdateRequestControl;
import com.unboundid.ldap.sdk.unboundidds.controls.SuppressReferentialIntegrityUpdatesRequestControl;
import com.unboundid.ldap.sdk.unboundidds.controls.SuppressType;
import com.unboundid.ldap.sdk.unboundidds.tools.ResultUtils;
import com.unboundid.ldap.sdk.unboundidds.tools.ToolMessages;
import com.unboundid.ldap.sdk.unboundidds.tools.ToolUtils;
import com.unboundid.ldif.LDIFChangeRecord;
import com.unboundid.ldif.LDIFReader;
import com.unboundid.ldif.LDIFWriter;
import com.unboundid.util.Debug;
import com.unboundid.util.FixedRateBarrier;
import com.unboundid.util.LDAPCommandLineTool;
import com.unboundid.util.NotNull;
import com.unboundid.util.Nullable;
import com.unboundid.util.ObjectPair;
import com.unboundid.util.PassphraseEncryptedOutputStream;
import com.unboundid.util.PassphraseEncryptedStreamHeader;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import com.unboundid.util.args.Argument;
import com.unboundid.util.args.ArgumentException;
import com.unboundid.util.args.ArgumentParser;
import com.unboundid.util.args.BooleanArgument;
import com.unboundid.util.args.ControlArgument;
import com.unboundid.util.args.DNArgument;
import com.unboundid.util.args.DurationArgument;
import com.unboundid.util.args.FileArgument;
import com.unboundid.util.args.IntegerArgument;
import com.unboundid.util.args.StringArgument;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.EnumSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.zip.GZIPOutputStream;

@ThreadSafety(level=ThreadSafetyLevel.NOT_THREADSAFE)
public final class ParallelUpdate
extends LDAPCommandLineTool
implements UnsolicitedNotificationHandler {
    private static final int WRAP_COLUMN = StaticUtils.TERMINAL_WIDTH_COLUMNS - 1;
    @NotNull
    private static final String PW_UPDATE_BEHAVIOR_NAME_IS_SELF_CHANGE = "is-self-change";
    @NotNull
    private static final String PW_UPDATE_BEHAVIOR_NAME_ALLOW_PRE_ENCODED_PW = "allow-pre-encoded-password";
    @NotNull
    private static final String PW_UPDATE_BEHAVIOR_NAME_SKIP_PW_VALIDATION = "skip-password-validation";
    @NotNull
    private static final String PW_UPDATE_BEHAVIOR_NAME_IGNORE_PW_HISTORY = "ignore-password-history";
    @NotNull
    private static final String PW_UPDATE_BEHAVIOR_NAME_IGNORE_MIN_PW_AGE = "ignore-minimum-password-age";
    @NotNull
    private static final String PW_UPDATE_BEHAVIOR_NAME_PW_STORAGE_SCHEME = "password-storage-scheme";
    @NotNull
    private static final String PW_UPDATE_BEHAVIOR_NAME_MUST_CHANGE_PW = "must-change-password";
    @NotNull
    private static final String ASSURED_REPLICATION_LOCAL_LEVEL_NONE = "none";
    @NotNull
    private static final String ASSURED_REPLICATION_LOCAL_LEVEL_RECEIVED_ANY_SERVER = "received-any-server";
    @NotNull
    private static final String ASSURED_REPLICATION_LOCAL_LEVEL_PROCESSED_ALL_SERVERS = "processed-all-servers";
    @NotNull
    private static final String ASSURED_REPLICATION_REMOTE_LEVEL_NONE = "none";
    @NotNull
    private static final String ASSURED_REPLICATION_REMOTE_LEVEL_RECEIVED_ANY_REMOTE_LOCATION = "received-any-remote-location";
    @NotNull
    private static final String ASSURED_REPLICATION_REMOTE_LEVEL_RECEIVED_ALL_REMOTE_LOCATIONS = "received-all-remote-locations";
    @NotNull
    private static final String ASSURED_REPLICATION_REMOTE_LEVEL_PROCESSED_ALL_REMOTE_SERVERS = "processed-all-remote-servers";
    @NotNull
    private static final String SUPPRESS_OP_ATTR_LAST_ACCESS_TIME = "last-access-time";
    @NotNull
    private static final String SUPPRESS_OP_ATTR_LAST_LOGIN_TIME = "last-login-time";
    @NotNull
    private static final String SUPPRESS_OP_ATTR_LAST_LOGIN_IP = "last-login-ip";
    @NotNull
    private static final String SUPPRESS_OP_ATTR_LASTMOD = "lastmod";
    @NotNull
    private final AtomicBoolean shouldAbort = new AtomicBoolean(false);
    @NotNull
    private final AtomicLong opsAttempted = new AtomicLong(0L);
    @NotNull
    private final AtomicLong opsRejected = new AtomicLong(0L);
    @NotNull
    private final AtomicLong opsSucceeded = new AtomicLong(0L);
    @NotNull
    private final AtomicLong totalOpDurationMillis = new AtomicLong(0L);
    private volatile long initialAttempted = 0L;
    private volatile long initialSucceeded = 0L;
    @NotNull
    private final AtomicLong retryQueueSize = new AtomicLong(0L);
    @NotNull
    private final Map<DN, List<ObjectPair<LDIFChangeRecord, LDAPException>>> retryQueue = new TreeMap<DN, List<ObjectPair<LDIFChangeRecord, LDAPException>>>();
    @NotNull
    private final AtomicReference<ResultCode> firstRejectResultCode = new AtomicReference();
    @NotNull
    private final AtomicReference<String> completionMessage = new AtomicReference();
    @Nullable
    private FixedRateBarrier rateLimiter;
    @Nullable
    private LDIFWriter rejectWriter = null;
    @Nullable
    private PrintWriter logWriter = null;
    private volatile long lastOpsAttempted = 0L;
    private volatile long lastTotalDurationMillis = 0L;
    private volatile long lastUpdateTimeMillis = 0L;
    private volatile long processingStartTimeMillis = System.currentTimeMillis();
    @NotNull
    private final ThreadLocal<SimpleDateFormat> timestampFormatters = new ThreadLocal();
    @Nullable
    private BooleanArgument allowUndeleteArg = null;
    @Nullable
    private BooleanArgument defaultAddArg = null;
    @Nullable
    private BooleanArgument followReferralsArg = null;
    @Nullable
    private BooleanArgument hardDeleteArg = null;
    @Nullable
    private BooleanArgument ignoreNoUserModificationArg = null;
    @Nullable
    private BooleanArgument isCompressedArg = null;
    @Nullable
    private BooleanArgument nameWithEntryUUIDArg = null;
    @Nullable
    private BooleanArgument neverRetryArg = null;
    @Nullable
    private BooleanArgument replicationRepairArg = null;
    @Nullable
    private BooleanArgument softDeleteArg = null;
    @Nullable
    private BooleanArgument suppressReferentialIntegrityUpdatesArg = null;
    @Nullable
    private BooleanArgument useAssuredReplicationArg = null;
    @Nullable
    private BooleanArgument useFirstRejectResultCodeAsExitCodeArg = null;
    @Nullable
    private BooleanArgument useManageDsaITArg = null;
    @Nullable
    private BooleanArgument usePermissiveModifyArg = null;
    @Nullable
    private ControlArgument addControlArg = null;
    @Nullable
    private ControlArgument bindControlArg = null;
    @Nullable
    private ControlArgument deleteControlArg = null;
    @Nullable
    private ControlArgument modifyControlArg = null;
    @Nullable
    private ControlArgument modifyDNControlArg = null;
    @Nullable
    private DNArgument proxyV1AsArg = null;
    @Nullable
    private DurationArgument assuredReplicationTimeoutArg = null;
    @Nullable
    private FileArgument encryptionPassphraseFileArg = null;
    @Nullable
    private FileArgument ldifFileArg = null;
    @Nullable
    private FileArgument logFileArg = null;
    @Nullable
    private FileArgument rejectFileArg = null;
    @Nullable
    private IntegerArgument numThreadsArg = null;
    @Nullable
    private IntegerArgument ratePerSecondArg = null;
    @Nullable
    private StringArgument assuredReplicationLocalLevelArg = null;
    @Nullable
    private StringArgument assuredReplicationRemoteLevelArg = null;
    @Nullable
    private StringArgument operationPurposeArg = null;
    @Nullable
    private StringArgument passwordUpdateBehaviorArg = null;
    @Nullable
    private StringArgument proxyAsArg = null;
    @Nullable
    private StringArgument suppressOperationalAttributeUpdatesArg = null;

    public static void main(String ... args) {
        ResultCode resultCode = ParallelUpdate.main(System.out, System.err, args);
        if (resultCode != ResultCode.SUCCESS) {
            System.exit(Math.min(resultCode.intValue(), 255));
        }
    }

    @NotNull
    public static ResultCode main(@Nullable OutputStream out, @Nullable OutputStream err, String ... args) {
        ParallelUpdate parallelupdate = new ParallelUpdate(out, err);
        return parallelupdate.runTool(args);
    }

    public ParallelUpdate(@Nullable OutputStream out, @Nullable OutputStream err) {
        super(out, err);
    }

    @Override
    @NotNull
    public String getToolName() {
        return "parallel-update";
    }

    @Override
    @NotNull
    public String getToolDescription() {
        return ToolMessages.INFO_PARALLEL_UPDATE_TOOL_DESCRIPTION_1.get();
    }

    @Override
    @NotNull
    public List<String> getAdditionalDescriptionParagraphs() {
        return Collections.unmodifiableList(Arrays.asList(ToolMessages.INFO_PARALLEL_UPDATE_TOOL_DESCRIPTION_2.get(), ToolMessages.INFO_PARALLEL_UPDATE_TOOL_DESCRIPTION_3.get()));
    }

    @Override
    @NotNull
    public String getToolVersion() {
        return "6.0.2";
    }

    @Override
    public void addNonLDAPArguments(@NotNull ArgumentParser parser) throws ArgumentException {
        this.ldifFileArg = new FileArgument(Character.valueOf('l'), "ldifFile", true, 1, null, ToolMessages.INFO_PARALLEL_UPDATE_ARG_DESC_LDIF_FILE.get(), true, true, true, false);
        this.ldifFileArg.addLongIdentifier("ldif-file", true);
        this.ldifFileArg.addLongIdentifier("inputFile", true);
        this.ldifFileArg.addLongIdentifier("input-file", true);
        this.ldifFileArg.setArgumentGroupName(ToolMessages.INFO_PARALLEL_UPDATE_ARG_GROUP_PROCESSING.get());
        parser.addArgument(this.ldifFileArg);
        this.isCompressedArg = new BooleanArgument(Character.valueOf('c'), "isCompressed", 1, ToolMessages.INFO_PARALLEL_UPDATE_ARG_DESC_IS_COMPRESSED.get());
        this.isCompressedArg.addLongIdentifier("is-compressed", true);
        this.isCompressedArg.addLongIdentifier("compressed", true);
        this.isCompressedArg.setArgumentGroupName(ToolMessages.INFO_PARALLEL_UPDATE_ARG_GROUP_PROCESSING.get());
        this.isCompressedArg.setHidden(true);
        parser.addArgument(this.isCompressedArg);
        this.encryptionPassphraseFileArg = new FileArgument(null, "encryptionPassphraseFile", false, 1, null, ToolMessages.INFO_PARALLEL_UPDATE_ARG_DESC_ENCRYPTION_PASSPHRASE_FILE.get(), true, true, true, false);
        this.encryptionPassphraseFileArg.addLongIdentifier("encryption-passphrase-file", true);
        this.encryptionPassphraseFileArg.addLongIdentifier("encryptionPasswordFile", true);
        this.encryptionPassphraseFileArg.addLongIdentifier("encryption-password-file", true);
        this.encryptionPassphraseFileArg.setArgumentGroupName(ToolMessages.INFO_PARALLEL_UPDATE_ARG_GROUP_PROCESSING.get());
        parser.addArgument(this.encryptionPassphraseFileArg);
        this.rejectFileArg = new FileArgument(Character.valueOf('R'), "rejectFile", true, 1, null, ToolMessages.INFO_PARALLEL_UPDATE_ARG_DESC_REJECT_FILE.get(), false, true, true, false);
        this.rejectFileArg.addLongIdentifier("reject-file", true);
        this.rejectFileArg.addLongIdentifier("rejectsFile", true);
        this.rejectFileArg.addLongIdentifier("rejects-file", true);
        this.rejectFileArg.setArgumentGroupName(ToolMessages.INFO_PARALLEL_UPDATE_ARG_GROUP_PROCESSING.get());
        parser.addArgument(this.rejectFileArg);
        this.useFirstRejectResultCodeAsExitCodeArg = new BooleanArgument(null, "useFirstRejectResultCodeAsExitCode", 1, ToolMessages.INFO_PARALLEL_UPDATE_USE_FIRST_REJECT_RC.get());
        this.useFirstRejectResultCodeAsExitCodeArg.addLongIdentifier("use-first-reject-result-code-as-exit-code", true);
        this.useFirstRejectResultCodeAsExitCodeArg.addLongIdentifier("useFirstRejectResultCode", true);
        this.useFirstRejectResultCodeAsExitCodeArg.addLongIdentifier("use-first-reject-result-code", true);
        this.useFirstRejectResultCodeAsExitCodeArg.addLongIdentifier("useFirstRejectResult", true);
        this.useFirstRejectResultCodeAsExitCodeArg.addLongIdentifier("use-first-reject-result", true);
        this.useFirstRejectResultCodeAsExitCodeArg.addLongIdentifier("useRejectResultCodeAsExitCode", true);
        this.useFirstRejectResultCodeAsExitCodeArg.addLongIdentifier("use-reject-result-code-as-exit-code", true);
        this.useFirstRejectResultCodeAsExitCodeArg.addLongIdentifier("useRejectResultCode", true);
        this.useFirstRejectResultCodeAsExitCodeArg.addLongIdentifier("use-reject-result-code", true);
        this.useFirstRejectResultCodeAsExitCodeArg.addLongIdentifier("useRejectResult", true);
        this.useFirstRejectResultCodeAsExitCodeArg.addLongIdentifier("use-reject-result", true);
        this.useFirstRejectResultCodeAsExitCodeArg.setArgumentGroupName(ToolMessages.INFO_PARALLEL_UPDATE_ARG_GROUP_PROCESSING.get());
        parser.addArgument(this.useFirstRejectResultCodeAsExitCodeArg);
        this.neverRetryArg = new BooleanArgument(Character.valueOf('r'), "neverRetry", 1, ToolMessages.INFO_PARALLEL_UPDATE_ARG_DESC_NEVER_RETRY.get());
        this.neverRetryArg.addLongIdentifier("never-retry", true);
        this.neverRetryArg.setArgumentGroupName(ToolMessages.INFO_PARALLEL_UPDATE_ARG_GROUP_PROCESSING.get());
        parser.addArgument(this.neverRetryArg);
        this.logFileArg = new FileArgument(Character.valueOf('L'), "logFile", false, 1, null, ToolMessages.INFO_PARALLEL_UPDATE_ARG_DESC_LOG_FILE.get(), false, true, true, false);
        this.logFileArg.addLongIdentifier("log-file", true);
        this.logFileArg.setArgumentGroupName(ToolMessages.INFO_PARALLEL_UPDATE_ARG_GROUP_PROCESSING.get());
        parser.addArgument(this.logFileArg);
        this.defaultAddArg = new BooleanArgument(Character.valueOf('a'), "defaultAdd", 1, ToolMessages.INFO_PARALLEL_UPDATE_ARG_DESC_DEFAULT_ADD.get());
        this.defaultAddArg.addLongIdentifier("default-add", true);
        this.defaultAddArg.setArgumentGroupName(ToolMessages.INFO_PARALLEL_UPDATE_ARG_GROUP_PROCESSING.get());
        parser.addArgument(this.defaultAddArg);
        this.followReferralsArg = new BooleanArgument(null, "followReferrals", 1, ToolMessages.INFO_PARALLEL_UPDATE_ARG_DESC_FOLLOW_REFERRALS.get());
        this.followReferralsArg.addLongIdentifier("follow-referrals", true);
        this.followReferralsArg.setArgumentGroupName(ToolMessages.INFO_PARALLEL_UPDATE_ARG_GROUP_PROCESSING.get());
        parser.addArgument(this.followReferralsArg);
        this.numThreadsArg = new IntegerArgument(Character.valueOf('t'), "numThreads", true, 1, null, ToolMessages.INFO_PARALLEL_UPDATE_ARG_DESC_NUM_THREADS.get(), 1, Integer.MAX_VALUE, 8);
        this.numThreadsArg.addLongIdentifier("num-threads", true);
        this.numThreadsArg.addLongIdentifier("threads", true);
        this.numThreadsArg.setArgumentGroupName(ToolMessages.INFO_PARALLEL_UPDATE_ARG_GROUP_PROCESSING.get());
        parser.addArgument(this.numThreadsArg);
        this.ratePerSecondArg = new IntegerArgument(Character.valueOf('s'), "ratePerSecond", false, 1, null, ToolMessages.INFO_PARALLEL_UPDATE_ARG_DESC_RATE_PER_SECOND.get(), 1, Integer.MAX_VALUE);
        this.ratePerSecondArg.addLongIdentifier("rate-per-second", true);
        this.ratePerSecondArg.addLongIdentifier("requestsPerSecond", true);
        this.ratePerSecondArg.addLongIdentifier("requests-per-second", true);
        this.ratePerSecondArg.addLongIdentifier("operationsPerSecond", true);
        this.ratePerSecondArg.addLongIdentifier("operations-per-second", true);
        this.ratePerSecondArg.addLongIdentifier("opsPerSecond", true);
        this.ratePerSecondArg.addLongIdentifier("ops-per-second", true);
        this.ratePerSecondArg.addLongIdentifier("rate", true);
        this.ratePerSecondArg.setArgumentGroupName(ToolMessages.INFO_PARALLEL_UPDATE_ARG_GROUP_PROCESSING.get());
        parser.addArgument(this.ratePerSecondArg);
        this.usePermissiveModifyArg = new BooleanArgument(Character.valueOf('M'), "usePermissiveModify", 1, ToolMessages.INFO_PARALLEL_UPDATE_ARG_DESC_USE_PERMISSIVE_MODIFY.get());
        this.usePermissiveModifyArg.addLongIdentifier("use-permissive-modify", true);
        this.usePermissiveModifyArg.addLongIdentifier("permissiveModify", true);
        this.usePermissiveModifyArg.addLongIdentifier("permissive-modify", true);
        this.usePermissiveModifyArg.addLongIdentifier("permissive", true);
        this.usePermissiveModifyArg.setArgumentGroupName(ToolMessages.INFO_PARALLEL_UPDATE_ARG_GROUP_CONTROLS.get());
        parser.addArgument(this.usePermissiveModifyArg);
        this.ignoreNoUserModificationArg = new BooleanArgument(null, "ignoreNoUserModification", 1, ToolMessages.INFO_PARALLEL_UPDATE_ARG_DESC_IGNORE_NO_USER_MOD.get());
        this.ignoreNoUserModificationArg.addLongIdentifier("ignore-no-user-modification", true);
        this.ignoreNoUserModificationArg.addLongIdentifier("ignoreNoUserMod", true);
        this.ignoreNoUserModificationArg.addLongIdentifier("ignore-no-user-mod", true);
        this.ignoreNoUserModificationArg.setArgumentGroupName(ToolMessages.INFO_PARALLEL_UPDATE_ARG_GROUP_CONTROLS.get());
        parser.addArgument(this.ignoreNoUserModificationArg);
        this.proxyAsArg = new StringArgument(Character.valueOf('Y'), "proxyAs", false, 1, ToolMessages.INFO_PARALLEL_UPDATE_ARG_PLACEHOLDER_PROXY_AS.get(), ToolMessages.INFO_PARALLEL_UPDATE_ARG_DESC_PROXY_AS.get());
        this.proxyAsArg.addLongIdentifier("proxy-as", true);
        this.proxyAsArg.addLongIdentifier("proxyV2As", true);
        this.proxyAsArg.addLongIdentifier("proxy-v2-as", true);
        this.proxyAsArg.setArgumentGroupName(ToolMessages.INFO_PARALLEL_UPDATE_ARG_GROUP_CONTROLS.get());
        parser.addArgument(this.proxyAsArg);
        this.proxyV1AsArg = new DNArgument(null, "proxyV1As", false, 1, null, ToolMessages.INFO_PARALLEL_UPDATE_ARG_DESC_PROXY_V1_AS.get());
        this.proxyV1AsArg.addLongIdentifier("proxy-v1-as", true);
        this.proxyV1AsArg.setArgumentGroupName(ToolMessages.INFO_PARALLEL_UPDATE_ARG_GROUP_CONTROLS.get());
        parser.addArgument(this.proxyV1AsArg);
        this.passwordUpdateBehaviorArg = new StringArgument(null, "passwordUpdateBehavior", false, 0, ToolMessages.INFO_PARALLEL_UPDATE_ARG_PLACEHOLDER_PW_UPDATE_BEHAVIOR.get(), ToolMessages.INFO_PARALLEL_UPDATE_ARG_DESC_PW_UPDATE_BEHAVIOR.get());
        this.passwordUpdateBehaviorArg.addLongIdentifier("password-update-behavior", true);
        this.passwordUpdateBehaviorArg.setArgumentGroupName(ToolMessages.INFO_PARALLEL_UPDATE_ARG_GROUP_CONTROLS.get());
        parser.addArgument(this.passwordUpdateBehaviorArg);
        this.operationPurposeArg = new StringArgument(null, "operationPurpose", false, 1, ToolMessages.INFO_PARALLEL_UPDATE_ARG_PLACEHOLDER_OPERATION_PURPOSE.get(), ToolMessages.INFO_PARALLEL_UPDATE_ARG_DESC_OPERATION_PURPOSE.get());
        this.operationPurposeArg.addLongIdentifier("operation-purpose", true);
        this.operationPurposeArg.addLongIdentifier("purpose", true);
        this.operationPurposeArg.setArgumentGroupName(ToolMessages.INFO_PARALLEL_UPDATE_ARG_GROUP_CONTROLS.get());
        parser.addArgument(this.operationPurposeArg);
        this.useManageDsaITArg = new BooleanArgument(null, "useManageDsaIT", 1, ToolMessages.INFO_PARALLEL_UPDATE_ARG_DESC_USE_MANAGE_DSA_IT.get());
        this.useManageDsaITArg.addLongIdentifier("use-manage-dsa-it", true);
        this.useManageDsaITArg.addLongIdentifier("manageDsaIT", true);
        this.useManageDsaITArg.addLongIdentifier("manage-dsa-it", true);
        this.useManageDsaITArg.setArgumentGroupName(ToolMessages.INFO_PARALLEL_UPDATE_ARG_GROUP_CONTROLS.get());
        parser.addArgument(this.useManageDsaITArg);
        this.nameWithEntryUUIDArg = new BooleanArgument(null, "nameWithEntryUUID", 1, ToolMessages.INFO_LDAPMODIFY_ARG_DESCRIPTION_NAME_WITH_ENTRY_UUID.get());
        this.nameWithEntryUUIDArg.addLongIdentifier("name-with-entryuuid", true);
        this.nameWithEntryUUIDArg.addLongIdentifier("name-with-entry-uuid", true);
        this.nameWithEntryUUIDArg.setArgumentGroupName(ToolMessages.INFO_PARALLEL_UPDATE_ARG_GROUP_CONTROLS.get());
        parser.addArgument(this.nameWithEntryUUIDArg);
        this.softDeleteArg = new BooleanArgument(null, "useSoftDelete", 1, ToolMessages.INFO_PARALLEL_UPDATE_ARG_DESC_SOFT_DELETE.get());
        this.softDeleteArg.addLongIdentifier("use-soft-delete", true);
        this.softDeleteArg.addLongIdentifier("softDelete", true);
        this.softDeleteArg.addLongIdentifier("soft-delete", true);
        this.softDeleteArg.setArgumentGroupName(ToolMessages.INFO_PARALLEL_UPDATE_ARG_GROUP_CONTROLS.get());
        parser.addArgument(this.softDeleteArg);
        this.hardDeleteArg = new BooleanArgument(null, "useHardDelete", 1, ToolMessages.INFO_PARALLEL_UPDATE_ARG_DESC_HARD_DELETE.get());
        this.hardDeleteArg.addLongIdentifier("use-hard-delete", true);
        this.hardDeleteArg.addLongIdentifier("hardDelete", true);
        this.hardDeleteArg.addLongIdentifier("hard-delete", true);
        this.hardDeleteArg.setArgumentGroupName(ToolMessages.INFO_PARALLEL_UPDATE_ARG_GROUP_CONTROLS.get());
        parser.addArgument(this.hardDeleteArg);
        this.allowUndeleteArg = new BooleanArgument(null, "allowUndelete", 1, ToolMessages.INFO_PARALLEL_UPDATE_ARG_DESC_ALLOW_UNDELETE.get());
        this.allowUndeleteArg.addLongIdentifier("allow-undelete", true);
        this.allowUndeleteArg.addLongIdentifier("undelete", true);
        this.allowUndeleteArg.setArgumentGroupName(ToolMessages.INFO_PARALLEL_UPDATE_ARG_GROUP_CONTROLS.get());
        parser.addArgument(this.allowUndeleteArg);
        this.useAssuredReplicationArg = new BooleanArgument(null, "useAssuredReplication", 1, ToolMessages.INFO_PWMOD_ARG_DESC_ASSURED_REPLICATION.get());
        this.useAssuredReplicationArg.addLongIdentifier("use-assured-replication", true);
        this.useAssuredReplicationArg.addLongIdentifier("assuredReplication", true);
        this.useAssuredReplicationArg.addLongIdentifier("assured-replication", true);
        this.useAssuredReplicationArg.setArgumentGroupName(ToolMessages.INFO_PARALLEL_UPDATE_ARG_GROUP_CONTROLS.get());
        parser.addArgument(this.useAssuredReplicationArg);
        this.assuredReplicationLocalLevelArg = new StringArgument(null, "assuredReplicationLocalLevel", false, 1, ToolMessages.INFO_LDAPDELETE_ARG_PLACEHOLDER_ASSURED_REPLICATION_LOCAL_LEVEL.get(), ToolMessages.INFO_LDAPDELETE_ARG_DESC_ASSURED_REPLICATION_LOCAL_LEVEL.get(), StaticUtils.setOf("none", ASSURED_REPLICATION_LOCAL_LEVEL_RECEIVED_ANY_SERVER, ASSURED_REPLICATION_LOCAL_LEVEL_PROCESSED_ALL_SERVERS), (String)null);
        this.assuredReplicationLocalLevelArg.addLongIdentifier("assured-replication-local-level", true);
        this.assuredReplicationLocalLevelArg.setArgumentGroupName(ToolMessages.INFO_PARALLEL_UPDATE_ARG_GROUP_CONTROLS.get());
        parser.addArgument(this.assuredReplicationLocalLevelArg);
        this.assuredReplicationRemoteLevelArg = new StringArgument(null, "assuredReplicationRemoteLevel", false, 1, ToolMessages.INFO_PARALLEL_UPDATE_ARG_PLACEHOLDER_ASSURED_REPLICATION_REMOTE_LEVEL.get(), ToolMessages.INFO_PARALLEL_UPDATE_ARG_DESC_ASSURED_REPLICATION_REMOTE_LEVEL.get(), StaticUtils.setOf("none", ASSURED_REPLICATION_REMOTE_LEVEL_RECEIVED_ANY_REMOTE_LOCATION, ASSURED_REPLICATION_REMOTE_LEVEL_RECEIVED_ALL_REMOTE_LOCATIONS, ASSURED_REPLICATION_REMOTE_LEVEL_PROCESSED_ALL_REMOTE_SERVERS), (String)null);
        this.assuredReplicationRemoteLevelArg.addLongIdentifier("assured-replication-remote-level", true);
        this.assuredReplicationRemoteLevelArg.setArgumentGroupName(ToolMessages.INFO_PARALLEL_UPDATE_ARG_GROUP_CONTROLS.get());
        parser.addArgument(this.assuredReplicationRemoteLevelArg);
        this.assuredReplicationTimeoutArg = new DurationArgument(null, "assuredReplicationTimeout", false, null, ToolMessages.INFO_PWMOD_ARG_DESC_ASSURED_REPLICATION_TIMEOUT.get());
        this.assuredReplicationTimeoutArg.addLongIdentifier("assured-replication-timeout", true);
        this.assuredReplicationTimeoutArg.setArgumentGroupName(ToolMessages.INFO_PARALLEL_UPDATE_ARG_GROUP_CONTROLS.get());
        parser.addArgument(this.assuredReplicationTimeoutArg);
        this.replicationRepairArg = new BooleanArgument(null, "replicationRepair", 1, ToolMessages.INFO_PARALLEL_UPDATE_ARG_DESC_USE_REPLICATION_REPAIR.get());
        this.replicationRepairArg.addLongIdentifier("replication-repair", true);
        this.replicationRepairArg.setArgumentGroupName(ToolMessages.INFO_PARALLEL_UPDATE_ARG_GROUP_CONTROLS.get());
        parser.addArgument(this.replicationRepairArg);
        this.suppressOperationalAttributeUpdatesArg = new StringArgument(null, "suppressOperationalAttributeUpdates", false, 0, ToolMessages.INFO_PARALLEL_UPDATE_ARG_PLACEHOLDER_SUPPRESS_OP_ATTR_UPDATES.get(), ToolMessages.INFO_PARALLEL_UPDATE_ARG_DESC_SUPPRESS_OP_ATTR_UPDATES.get(), StaticUtils.setOf(SUPPRESS_OP_ATTR_LAST_ACCESS_TIME, SUPPRESS_OP_ATTR_LAST_LOGIN_TIME, SUPPRESS_OP_ATTR_LAST_LOGIN_IP, SUPPRESS_OP_ATTR_LASTMOD), (String)null);
        this.suppressOperationalAttributeUpdatesArg.addLongIdentifier("suppress-operational-attribute-updates", true);
        this.suppressOperationalAttributeUpdatesArg.addLongIdentifier("suppressOperationalAttributeUpdate", true);
        this.suppressOperationalAttributeUpdatesArg.addLongIdentifier("suppress-operational-attribute-update", true);
        this.suppressOperationalAttributeUpdatesArg.setArgumentGroupName(ToolMessages.INFO_PARALLEL_UPDATE_ARG_GROUP_CONTROLS.get());
        parser.addArgument(this.suppressOperationalAttributeUpdatesArg);
        this.suppressReferentialIntegrityUpdatesArg = new BooleanArgument(null, "suppressReferentialIntegrityUpdates", 1, ToolMessages.INFO_PARALLEL_UPDATE_ARG_DESC_SUPPRESS_REFERENTIAL_INTEGRITY_UPDATES.get());
        this.suppressReferentialIntegrityUpdatesArg.addLongIdentifier("suppress-referential-integrity-updates", true);
        this.suppressReferentialIntegrityUpdatesArg.addLongIdentifier("suppressReferentialIntegrityUpdate", true);
        this.suppressReferentialIntegrityUpdatesArg.addLongIdentifier("suppress-referential-integrity-update", true);
        this.suppressReferentialIntegrityUpdatesArg.setArgumentGroupName(ToolMessages.INFO_PARALLEL_UPDATE_ARG_GROUP_CONTROLS.get());
        parser.addArgument(this.suppressReferentialIntegrityUpdatesArg);
        this.addControlArg = new ControlArgument(null, "addControl", false, 0, null, ToolMessages.INFO_PARALLEL_UPDATE_ARG_DESC_ADD_CONTROL.get());
        this.addControlArg.addLongIdentifier("add-control", true);
        this.addControlArg.setArgumentGroupName(ToolMessages.INFO_PARALLEL_UPDATE_ARG_GROUP_CONTROLS.get());
        parser.addArgument(this.addControlArg);
        this.bindControlArg = new ControlArgument(null, "bindControl", false, 0, null, ToolMessages.INFO_PARALLEL_UPDATE_ARG_DESC_BIND_CONTROL.get());
        this.bindControlArg.addLongIdentifier("bind-control", true);
        this.bindControlArg.setArgumentGroupName(ToolMessages.INFO_PARALLEL_UPDATE_ARG_GROUP_CONTROLS.get());
        parser.addArgument(this.bindControlArg);
        this.deleteControlArg = new ControlArgument(null, "deleteControl", false, 0, null, ToolMessages.INFO_PARALLEL_UPDATE_ARG_DESC_DELETE_CONTROL.get());
        this.deleteControlArg.addLongIdentifier("delete-control", true);
        this.deleteControlArg.setArgumentGroupName(ToolMessages.INFO_PARALLEL_UPDATE_ARG_GROUP_CONTROLS.get());
        parser.addArgument(this.deleteControlArg);
        this.modifyControlArg = new ControlArgument(null, "modifyControl", false, 0, null, ToolMessages.INFO_PARALLEL_UPDATE_ARG_DESC_MODIFY_CONTROL.get());
        this.modifyControlArg.addLongIdentifier("modify-control", true);
        this.modifyControlArg.setArgumentGroupName(ToolMessages.INFO_PARALLEL_UPDATE_ARG_GROUP_CONTROLS.get());
        parser.addArgument(this.modifyControlArg);
        this.modifyDNControlArg = new ControlArgument(null, "modifyDNControl", false, 0, null, ToolMessages.INFO_PARALLEL_UPDATE_ARG_DESC_MODIFY_DN_CONTROL.get());
        this.modifyDNControlArg.addLongIdentifier("modify-dn-control", true);
        this.modifyDNControlArg.setArgumentGroupName(ToolMessages.INFO_PARALLEL_UPDATE_ARG_GROUP_CONTROLS.get());
        parser.addArgument(this.modifyDNControlArg);
        parser.addExclusiveArgumentSet(this.followReferralsArg, this.useManageDsaITArg, new Argument[0]);
        parser.addExclusiveArgumentSet(this.proxyAsArg, this.proxyV1AsArg, new Argument[0]);
        parser.addExclusiveArgumentSet(this.softDeleteArg, this.hardDeleteArg, new Argument[0]);
        parser.addDependentArgumentSet(this.assuredReplicationLocalLevelArg, this.useAssuredReplicationArg, new Argument[0]);
        parser.addDependentArgumentSet(this.assuredReplicationRemoteLevelArg, this.useAssuredReplicationArg, new Argument[0]);
        parser.addDependentArgumentSet(this.assuredReplicationTimeoutArg, this.useAssuredReplicationArg, new Argument[0]);
        parser.addExclusiveArgumentSet(this.useAssuredReplicationArg, this.replicationRepairArg, new Argument[0]);
    }

    @Override
    public boolean supportsInteractiveMode() {
        return true;
    }

    @Override
    public boolean defaultsToInteractiveMode() {
        return true;
    }

    @Override
    public boolean supportsPropertiesFile() {
        return true;
    }

    @Override
    protected boolean supportsAuthentication() {
        return true;
    }

    @Override
    protected boolean defaultToPromptForBindPassword() {
        return true;
    }

    @Override
    protected boolean supportsSASLHelp() {
        return true;
    }

    @Override
    protected boolean includeAlternateLongIdentifiers() {
        return true;
    }

    @Override
    @NotNull
    protected List<Control> getBindControls() {
        ArrayList<Control> bindControls = new ArrayList<Control>();
        if (this.bindControlArg != null && this.bindControlArg.isPresent()) {
            bindControls.addAll(this.bindControlArg.getValues());
        }
        if (this.suppressOperationalAttributeUpdatesArg != null && this.suppressOperationalAttributeUpdatesArg.isPresent()) {
            EnumSet<SuppressType> suppressTypes = EnumSet.noneOf(SuppressType.class);
            for (String s : this.suppressOperationalAttributeUpdatesArg.getValues()) {
                if (s.equalsIgnoreCase(SUPPRESS_OP_ATTR_LAST_ACCESS_TIME)) {
                    suppressTypes.add(SuppressType.LAST_ACCESS_TIME);
                    continue;
                }
                if (s.equalsIgnoreCase(SUPPRESS_OP_ATTR_LAST_LOGIN_TIME)) {
                    suppressTypes.add(SuppressType.LAST_LOGIN_TIME);
                    continue;
                }
                if (!s.equalsIgnoreCase(SUPPRESS_OP_ATTR_LAST_LOGIN_IP)) continue;
                suppressTypes.add(SuppressType.LAST_LOGIN_IP);
            }
            bindControls.add(new SuppressOperationalAttributeUpdateRequestControl(true, suppressTypes));
        }
        return Collections.emptyList();
    }

    @Override
    protected boolean supportsMultipleServers() {
        return true;
    }

    @Override
    protected boolean supportsSSLDebugging() {
        return true;
    }

    @Override
    @NotNull
    public LDAPConnectionOptions getConnectionOptions() {
        LDAPConnectionOptions options = new LDAPConnectionOptions();
        options.setUseSynchronousMode(true);
        options.setFollowReferrals(this.followReferralsArg != null && this.followReferralsArg.isPresent());
        options.setUnsolicitedNotificationHandler(this);
        options.setResponseTimeoutMillis(0L);
        return options;
    }

    @Override
    protected boolean logToolInvocationByDefault() {
        return true;
    }

    @Override
    @Nullable
    public String getToolCompletionMessage() {
        return this.completionMessage.get();
    }

    /*
     * Exception decompiling
     */
    @Override
    @NotNull
    public ResultCode doToolProcessing() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [13[TRYBLOCK], 14[TRYBLOCK]], but top level block is 113[WHILELOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void getOperationControls(@NotNull List<Control> addControls, @NotNull List<Control> deleteControls, @NotNull List<Control> modifyControls, @NotNull List<Control> modifyDNControls) throws LDAPException {
        Control c;
        Control c2;
        if (this.addControlArg.isPresent()) {
            addControls.addAll(this.addControlArg.getValues());
        }
        if (this.deleteControlArg.isPresent()) {
            deleteControls.addAll(this.deleteControlArg.getValues());
        }
        if (this.modifyControlArg.isPresent()) {
            modifyControls.addAll(this.modifyControlArg.getValues());
        }
        if (this.modifyDNControlArg.isPresent()) {
            modifyDNControls.addAll(this.modifyDNControlArg.getValues());
        }
        if (this.proxyAsArg.isPresent()) {
            c2 = new ProxiedAuthorizationV2RequestControl(this.proxyAsArg.getValue());
            addControls.add(c2);
            deleteControls.add(c2);
            modifyControls.add(c2);
            modifyDNControls.add(c2);
        } else if (this.proxyV1AsArg.isPresent()) {
            c2 = new ProxiedAuthorizationV1RequestControl(this.proxyV1AsArg.getValue());
            addControls.add(c2);
            deleteControls.add(c2);
            modifyControls.add(c2);
            modifyDNControls.add(c2);
        }
        if (this.usePermissiveModifyArg.isPresent()) {
            modifyControls.add(new PermissiveModifyRequestControl(true));
        }
        if (this.ignoreNoUserModificationArg.isPresent()) {
            c2 = new IgnoreNoUserModificationRequestControl();
            addControls.add(c2);
            modifyControls.add(c2);
        }
        if (this.useManageDsaITArg.isPresent()) {
            c2 = new ManageDsaITRequestControl(true);
            addControls.add(c2);
            deleteControls.add(c2);
            modifyControls.add(c2);
            modifyDNControls.add(c2);
        }
        if (this.nameWithEntryUUIDArg.isPresent()) {
            addControls.add(new NameWithEntryUUIDRequestControl(true));
        }
        if (this.softDeleteArg.isPresent()) {
            deleteControls.add(new SoftDeleteRequestControl(true, true));
        } else if (this.hardDeleteArg.isPresent()) {
            deleteControls.add(new HardDeleteRequestControl(true));
        }
        if (this.operationPurposeArg.isPresent()) {
            c2 = new OperationPurposeRequestControl(false, "parallel-update", "6.0.2", ParallelUpdate.class.getName() + ".getOperationControls", this.operationPurposeArg.getValue());
            addControls.add(c2);
            deleteControls.add(c2);
            modifyControls.add(c2);
            modifyDNControls.add(c2);
        }
        if (this.replicationRepairArg.isPresent()) {
            c2 = new ReplicationRepairRequestControl();
            addControls.add(c2);
            deleteControls.add(c2);
            modifyControls.add(c2);
            modifyDNControls.add(c2);
        }
        if (this.suppressReferentialIntegrityUpdatesArg.isPresent()) {
            c2 = new SuppressReferentialIntegrityUpdatesRequestControl(true);
            deleteControls.add(c2);
            modifyDNControls.add(c2);
        }
        if (this.useAssuredReplicationArg.isPresent()) {
            AssuredReplicationRemoteLevel remoteLevel;
            AssuredReplicationLocalLevel localLevel;
            if (this.assuredReplicationLocalLevelArg.isPresent()) {
                String localLevelStr;
                switch (localLevelStr = StaticUtils.toLowerCase(this.assuredReplicationLocalLevelArg.getValue())) {
                    case "none": {
                        localLevel = AssuredReplicationLocalLevel.NONE;
                        break;
                    }
                    case "received-any-server": {
                        localLevel = AssuredReplicationLocalLevel.RECEIVED_ANY_SERVER;
                        break;
                    }
                    case "processed-all-servers": {
                        localLevel = AssuredReplicationLocalLevel.PROCESSED_ALL_SERVERS;
                        break;
                    }
                    default: {
                        localLevel = null;
                        break;
                    }
                }
            } else {
                localLevel = null;
            }
            if (this.assuredReplicationRemoteLevelArg.isPresent()) {
                String remoteLevelStr;
                switch (remoteLevelStr = StaticUtils.toLowerCase(this.assuredReplicationRemoteLevelArg.getValue())) {
                    case "none": {
                        remoteLevel = AssuredReplicationRemoteLevel.NONE;
                        break;
                    }
                    case "received-any-remote-location": {
                        remoteLevel = AssuredReplicationRemoteLevel.RECEIVED_ANY_REMOTE_LOCATION;
                        break;
                    }
                    case "received-all-remote-locations": {
                        remoteLevel = AssuredReplicationRemoteLevel.RECEIVED_ALL_REMOTE_LOCATIONS;
                        break;
                    }
                    case "processed-all-remote-servers": {
                        remoteLevel = AssuredReplicationRemoteLevel.PROCESSED_ALL_REMOTE_SERVERS;
                        break;
                    }
                    default: {
                        remoteLevel = null;
                        break;
                    }
                }
            } else {
                remoteLevel = null;
            }
            Long timeoutMillis = this.assuredReplicationTimeoutArg.isPresent() ? this.assuredReplicationTimeoutArg.getValue(TimeUnit.MILLISECONDS) : null;
            AssuredReplicationRequestControl c3 = new AssuredReplicationRequestControl(true, localLevel, null, remoteLevel, null, timeoutMillis, false);
            addControls.add(c3);
            deleteControls.add(c3);
            modifyControls.add(c3);
            modifyDNControls.add(c3);
        }
        if (this.passwordUpdateBehaviorArg.isPresent()) {
            PasswordUpdateBehaviorRequestControlProperties properties = new PasswordUpdateBehaviorRequestControlProperties();
            block40: for (String argValue : this.passwordUpdateBehaviorArg.getValues()) {
                String lowerName;
                int equalPos = argValue.indexOf(61);
                if (equalPos < 0) {
                    throw new LDAPException(ResultCode.PARAM_ERROR, ToolMessages.ERR_PARALLEL_UPDATE_MALFORMED_PW_UPDATE_VALUE.get(argValue, this.passwordUpdateBehaviorArg.getIdentifierString()));
                }
                String propertyName = argValue.substring(0, equalPos).trim();
                switch (lowerName = StaticUtils.toLowerCase(propertyName)) {
                    case "is-self-change": {
                        properties.setIsSelfChange(this.getBooleanPWUpdateBehaviorValue(argValue));
                        continue block40;
                    }
                    case "allow-pre-encoded-password": {
                        properties.setAllowPreEncodedPassword(this.getBooleanPWUpdateBehaviorValue(argValue));
                        continue block40;
                    }
                    case "skip-password-validation": {
                        properties.setSkipPasswordValidation(this.getBooleanPWUpdateBehaviorValue(argValue));
                        continue block40;
                    }
                    case "ignore-password-history": {
                        properties.setIgnorePasswordHistory(this.getBooleanPWUpdateBehaviorValue(argValue));
                        continue block40;
                    }
                    case "ignore-minimum-password-age": {
                        properties.setIgnoreMinimumPasswordAge(this.getBooleanPWUpdateBehaviorValue(argValue));
                        continue block40;
                    }
                    case "must-change-password": {
                        properties.setMustChangePassword(this.getBooleanPWUpdateBehaviorValue(argValue));
                        continue block40;
                    }
                    case "password-storage-scheme": {
                        String propertyValue = argValue.substring(equalPos + 1).trim();
                        properties.setPasswordStorageScheme(propertyValue);
                        continue block40;
                    }
                }
                throw new LDAPException(ResultCode.PARAM_ERROR, ToolMessages.ERR_PARALLEL_UPDATE_UNKNOWN_PW_UPDATE_PROP.get(argValue, this.passwordUpdateBehaviorArg.getIdentifierString(), PW_UPDATE_BEHAVIOR_NAME_IS_SELF_CHANGE, PW_UPDATE_BEHAVIOR_NAME_ALLOW_PRE_ENCODED_PW, PW_UPDATE_BEHAVIOR_NAME_SKIP_PW_VALIDATION, PW_UPDATE_BEHAVIOR_NAME_IGNORE_PW_HISTORY, PW_UPDATE_BEHAVIOR_NAME_IGNORE_MIN_PW_AGE, PW_UPDATE_BEHAVIOR_NAME_PW_STORAGE_SCHEME, PW_UPDATE_BEHAVIOR_NAME_MUST_CHANGE_PW));
            }
            c = new PasswordUpdateBehaviorRequestControl(properties, true);
            addControls.add(c);
            modifyControls.add(c);
        }
        if (this.suppressOperationalAttributeUpdatesArg.isPresent()) {
            EnumSet<SuppressType> suppressTypes = EnumSet.noneOf(SuppressType.class);
            for (String s : this.suppressOperationalAttributeUpdatesArg.getValues()) {
                if (s.equalsIgnoreCase(SUPPRESS_OP_ATTR_LAST_ACCESS_TIME)) {
                    suppressTypes.add(SuppressType.LAST_ACCESS_TIME);
                    continue;
                }
                if (s.equalsIgnoreCase(SUPPRESS_OP_ATTR_LAST_LOGIN_TIME)) {
                    suppressTypes.add(SuppressType.LAST_LOGIN_TIME);
                    continue;
                }
                if (!s.equalsIgnoreCase(SUPPRESS_OP_ATTR_LAST_LOGIN_IP)) continue;
                suppressTypes.add(SuppressType.LAST_LOGIN_IP);
            }
            c = new SuppressOperationalAttributeUpdateRequestControl(true, suppressTypes);
            addControls.add(c);
            deleteControls.add(c);
            modifyControls.add(c);
            modifyDNControls.add(c);
        }
    }

    private boolean getBooleanPWUpdateBehaviorValue(@NotNull String nameValuePair) throws LDAPException {
        String lowerValue;
        int equalPos = nameValuePair.indexOf(61);
        String propertyValue = nameValuePair.substring(equalPos + 1).trim();
        switch (lowerValue = StaticUtils.toLowerCase(propertyValue)) {
            case "true": 
            case "t": 
            case "yes": 
            case "on": 
            case "1": {
                return true;
            }
            case "false": 
            case "f": 
            case "no": 
            case "off": 
            case "0": {
                return false;
            }
        }
        String propertyName = nameValuePair.substring(0, equalPos).trim();
        throw new LDAPException(ResultCode.PARAM_ERROR, ToolMessages.ERR_PARALLEL_UPDATE_PW_UPDATE_VALUE_NOT_BOOLEAN.get(nameValuePair, this.passwordUpdateBehaviorArg.getIdentifierString(), propertyName));
    }

    @NotNull
    private ObjectPair<LDIFReader, String> createLDIFReader() throws LDAPException {
        File ldifFile = this.ldifFileArg.getValue();
        try {
            String encryptionPassphraseFromFile;
            if (this.encryptionPassphraseFileArg.isPresent()) {
                char[] pwChars = this.getPasswordFileReader().readPassword(this.encryptionPassphraseFileArg.getValue());
                encryptionPassphraseFromFile = new String(pwChars);
                Arrays.fill(pwChars, '\u0000');
            } else {
                encryptionPassphraseFromFile = null;
            }
            ObjectPair<InputStream, String> inputStreamPair = ToolUtils.getInputStreamForLDIFFiles(Collections.singletonList(ldifFile), encryptionPassphraseFromFile, this.getOut(), this.getErr());
            LDIFReader ldifReader = new LDIFReader(inputStreamPair.getFirst());
            String encryptionPassphrase = inputStreamPair.getSecond();
            return new ObjectPair<LDIFReader, String>(ldifReader, encryptionPassphrase);
        }
        catch (Exception e) {
            Debug.debugException(e);
            throw new LDAPException(ResultCode.LOCAL_ERROR, ToolMessages.ERR_PARALLEL_UPDATE_CANNOT_CREATE_LDIF_READER.get(ldifFile.getAbsolutePath(), StaticUtils.getExceptionMessage(e)), e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    private String getEncryptionSettingsDefinitionID() {
        try (FileInputStream inputStream = new FileInputStream(this.ldifFileArg.getValue());){
            PassphraseEncryptedStreamHeader encryptionHeader = PassphraseEncryptedStreamHeader.readFrom(inputStream, null);
            String string = encryptionHeader.getKeyIdentifier();
            return string;
        }
        catch (Exception e) {
            Debug.debugException(e);
            return null;
        }
    }

    @NotNull
    private LDIFWriter createRejectWriter(@Nullable String encryptionPassphrase, @Nullable String encryptionSettingsDefinitionID) throws LDAPException {
        File rejectFile = this.rejectFileArg.getValue();
        OutputStream outputStream = null;
        try {
            outputStream = new FileOutputStream(rejectFile);
            if (encryptionPassphrase != null) {
                outputStream = new PassphraseEncryptedOutputStream(encryptionPassphrase, outputStream, encryptionSettingsDefinitionID, true, true);
                outputStream = new GZIPOutputStream(outputStream);
            }
            LDIFWriter ldifWriter = new LDIFWriter(outputStream);
            ldifWriter.setWrapColumn(Integer.MAX_VALUE);
            return ldifWriter;
        }
        catch (Exception e) {
            Debug.debugException(e);
            if (outputStream != null) {
                try {
                    ((OutputStream)outputStream).close();
                }
                catch (Exception e2) {
                    Debug.debugException(e2);
                }
            }
            throw new LDAPException(ResultCode.LOCAL_ERROR, ToolMessages.ERR_PARALLEL_UPDATE_ERROR_CREATING_REJECT_WRITER.get(rejectFile.getAbsolutePath(), StaticUtils.getExceptionMessage(e)), e);
        }
    }

    private void logCompletionMessage(boolean isError, @NotNull String message) {
        this.completionMessage.compareAndSet(null, message);
        this.logMessage(message);
        if (isError) {
            this.wrapErr(0, WRAP_COLUMN, message);
        } else {
            this.wrapOut(0, WRAP_COLUMN, message);
        }
    }

    private void logMessage(Object ... messageElements) {
        if (this.logWriter != null) {
            SimpleDateFormat timestampFormatter = this.timestampFormatters.get();
            if (timestampFormatter == null) {
                timestampFormatter = new SimpleDateFormat("'['dd/MMM/yyyy:HH:mm:ss Z']'");
                this.timestampFormatters.set(timestampFormatter);
            }
            String timestamp = timestampFormatter.format(new Date());
            StringBuilder message = new StringBuilder();
            message.append('[');
            message.append(timestamp);
            message.append("] ");
            for (Object o : messageElements) {
                message.append(String.valueOf(o));
            }
            try {
                this.logWriter.println(message);
            }
            catch (Exception e) {
                Debug.debugException(e);
                String errorMessage = ToolMessages.ERR_PARALLEL_UPDATE_CANNOT_WRITE_LOG_MESSAGE.get(message.toString(), this.logFileArg.getValue().getAbsolutePath(), StaticUtils.getExceptionMessage(e));
                this.wrapErr(0, WRAP_COLUMN, errorMessage);
                this.completionMessage.compareAndSet(null, errorMessage);
                this.shouldAbort.set(true);
            }
        }
    }

    void opCompletedSuccessfully(@NotNull LDIFChangeRecord changeRecord, long processingDurationMillis) {
        this.opsAttempted.incrementAndGet();
        this.opsSucceeded.incrementAndGet();
        this.totalOpDurationMillis.addAndGet(processingDurationMillis);
        this.logMessage(changeRecord.getDN(), " ", changeRecord.getChangeType().getName(), " SUCCESS 0 ");
    }

    void opFailed(@NotNull LDIFChangeRecord changeRecord, @NotNull LDAPException ldapException, long processingDurationMillis) {
        this.opsAttempted.incrementAndGet();
        this.totalOpDurationMillis.addAndGet(processingDurationMillis);
        switch (ldapException.getResultCode().intValue()) {
            case 32: 
            case 51: 
            case 52: 
            case 66: 
            case 81: 
            case 91: {
                this.retry(changeRecord, ldapException);
                break;
            }
            default: {
                this.reject(changeRecord, ldapException);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void retry(@NotNull LDIFChangeRecord changeRecord, @NotNull LDAPException ldapException) {
        DN parsedDN;
        if (this.neverRetryArg.isPresent()) {
            this.reject(changeRecord, ldapException);
            return;
        }
        try {
            parsedDN = changeRecord.getParsedDN();
        }
        catch (LDAPException e) {
            Debug.debugException(e);
            this.reject(changeRecord, ldapException);
            return;
        }
        this.logMessage(changeRecord.getDN(), " ", changeRecord.getChangeType().getName(), " RETRY ", ldapException.getResultCode(), " ", ldapException.getMessage());
        Map<DN, List<ObjectPair<LDIFChangeRecord, LDAPException>>> map = this.retryQueue;
        synchronized (map) {
            List<ObjectPair<LDIFChangeRecord, LDAPException>> changeList = this.retryQueue.get(parsedDN);
            if (changeList == null) {
                changeList = new LinkedList<ObjectPair<LDIFChangeRecord, LDAPException>>();
                this.retryQueue.put(parsedDN, changeList);
            }
            changeList.add(new ObjectPair<LDIFChangeRecord, LDAPException>(changeRecord, ldapException));
            this.retryQueueSize.incrementAndGet();
        }
    }

    void reject(@Nullable LDIFChangeRecord changeRecord, @NotNull LDAPException ldapException) {
        this.opsRejected.incrementAndGet();
        ResultCode resultCode = ldapException.getResultCode();
        if (resultCode != ResultCode.SUCCESS) {
            this.firstRejectResultCode.compareAndSet(null, resultCode);
        }
        StringBuilder commentBuffer = new StringBuilder();
        for (String line : ResultUtils.formatResult(ldapException, false, 0, 0)) {
            if (commentBuffer.length() > 0) {
                commentBuffer.append(StaticUtils.EOL);
            }
            commentBuffer.append(line);
        }
        String comment = commentBuffer.toString();
        try {
            if (changeRecord != null) {
                this.logMessage(changeRecord.getDN(), " ", changeRecord.getChangeType().getName(), " REJECT ", resultCode, " ", ldapException.getMessage());
                this.rejectWriter.writeChangeRecord(changeRecord, comment);
            } else {
                this.rejectWriter.writeComment(comment, true, true);
            }
        }
        catch (Exception e) {
            Debug.debugException(e);
            String errorMessage = ToolMessages.ERR_PARALLEL_UPDATE_CANNOT_WRITE_REJECT.get(changeRecord.toString(), ToolMessages.ERR_PARALLEL_UPDATE_REJECT_COMMENT.get(String.valueOf(resultCode), ldapException.getMessage()), StaticUtils.getExceptionMessage(e));
            this.wrapErr(0, WRAP_COLUMN, errorMessage);
            this.completionMessage.compareAndSet(null, errorMessage);
            this.shouldAbort.set(true);
        }
    }

    void printIntervalData() {
        long recentRate;
        long currentAttempts = this.opsAttempted.get();
        long currentSuccesses = this.opsSucceeded.get();
        long currentReject = this.opsRejected.get();
        long currentRetry = this.retryQueueSize.get();
        long currentDurationMillis = this.totalOpDurationMillis.get();
        long currentTimeMillis = System.currentTimeMillis();
        long totalDurationMillis = currentTimeMillis - this.processingStartTimeMillis;
        long avgRate = totalDurationMillis == 0L ? 0L : 1000L * currentAttempts / totalDurationMillis;
        long avgDurationMillis = currentAttempts == 0L ? 0L : currentDurationMillis / currentAttempts;
        long recentDurationMillis = currentAttempts == this.lastOpsAttempted ? 0L : (currentDurationMillis - this.lastTotalDurationMillis) / (currentAttempts - this.lastOpsAttempted);
        if (this.lastOpsAttempted == 0L) {
            this.out(" Attempts Successes   Rejects   ToRetry  AvgOps/S  RctOps/S  AvgDurMS  RctDurMS");
            this.out("--------- --------- --------- --------- --------- --------- --------- ---------");
            recentRate = avgRate;
        } else {
            recentRate = currentTimeMillis == this.lastUpdateTimeMillis ? 0L : 1000L * (currentAttempts - this.lastOpsAttempted) / (currentTimeMillis - this.lastUpdateTimeMillis);
        }
        StringBuilder buffer = new StringBuilder(80);
        ParallelUpdate.appendJustified(currentAttempts, buffer, true);
        ParallelUpdate.appendJustified(currentSuccesses, buffer, true);
        ParallelUpdate.appendJustified(currentReject, buffer, true);
        ParallelUpdate.appendJustified(currentRetry, buffer, true);
        ParallelUpdate.appendJustified(avgRate, buffer, true);
        ParallelUpdate.appendJustified(recentRate, buffer, true);
        ParallelUpdate.appendJustified(avgDurationMillis, buffer, true);
        ParallelUpdate.appendJustified(recentDurationMillis, buffer, false);
        this.out(buffer.toString());
        this.lastOpsAttempted = currentAttempts;
        this.lastTotalDurationMillis = currentDurationMillis;
        this.lastUpdateTimeMillis = currentTimeMillis;
    }

    static void appendJustified(long value, @NotNull StringBuilder buffer, boolean addSpace) {
        String valueStr = String.valueOf(value);
        switch (valueStr.length()) {
            case 1: {
                buffer.append("        ");
                break;
            }
            case 2: {
                buffer.append("       ");
                break;
            }
            case 3: {
                buffer.append("      ");
                break;
            }
            case 4: {
                buffer.append("     ");
                break;
            }
            case 5: {
                buffer.append("    ");
                break;
            }
            case 6: {
                buffer.append("   ");
                break;
            }
            case 7: {
                buffer.append("  ");
                break;
            }
            case 8: {
                buffer.append(' ');
            }
        }
        buffer.append(value);
        if (addSpace) {
            buffer.append(' ');
        }
    }

    public long getTotalAttemptCount() {
        return this.opsAttempted.get();
    }

    public long getInitialAttemptCount() {
        return this.initialAttempted;
    }

    public long getRetryAttemptCount() {
        return this.opsAttempted.get() - this.initialAttempted;
    }

    public long getTotalSuccessCount() {
        return this.opsSucceeded.get();
    }

    public long getInitialSuccessCount() {
        return this.initialSucceeded;
    }

    public long getRetrySuccessCount() {
        return this.opsSucceeded.get() - this.initialSucceeded;
    }

    public long getRejectCount() {
        return this.opsRejected.get();
    }

    public long getTotalOpDurationMillis() {
        return this.totalOpDurationMillis.get();
    }

    @Override
    protected boolean registerShutdownHook() {
        return true;
    }

    @Override
    protected void doShutdownHookProcessing(@Nullable ResultCode resultCode) {
        this.shouldAbort.set(true);
        FixedRateBarrier b = this.rateLimiter;
        if (b != null) {
            b.shutdownRequested();
        }
    }

    @Override
    public void handleUnsolicitedNotification(@NotNull LDAPConnection connection, @NotNull ExtendedResult notification) {
        String message = notification.getDiagnosticMessage() == null ? ToolMessages.INFO_PARALLEL_UPDATE_UNSOLICITED_NOTIFICATION_NO_MESSAGE.get(this.getToolName(), String.valueOf(notification.getResultCode()), notification.getOID()) : ToolMessages.INFO_PARALLEL_UPDATE_UNSOLICITED_NOTIFICATION_NO_MESSAGE.get(this.getToolName(), String.valueOf(notification.getResultCode()), notification.getOID(), notification.getDiagnosticMessage());
        this.out(new Object[0]);
        this.wrapOut(0, WRAP_COLUMN, message);
        this.out(new Object[0]);
    }

    @Override
    @NotNull
    public LinkedHashMap<String[], String> getExampleUsages() {
        LinkedHashMap<String[], String> examples = new LinkedHashMap<String[], String>();
        examples.put(new String[]{"--hostname", "server.example.com", "--port", "636", "--useSSL", "--bindDN", "uid=admin,dc=example,dc=com", "--promptForBindPassword", "--ldifFile", "changes.ldif", "--rejectFile", "rejects.ldif", "--defaultAdd", "--numThreads", "10", "--ratePerSecond", "5000"}, ToolMessages.INFO_PARALLEL_UPDATE_EXAMPLE_DESC.get());
        return examples;
    }
}

