/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.indices.create;

import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.admin.indices.alias.Alias;
import org.elasticsearch.action.admin.indices.create.CreateIndexClusterStateUpdateRequest;
import org.elasticsearch.action.admin.indices.create.CreateIndexRequest;
import org.elasticsearch.action.admin.indices.create.CreateIndexResponse;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.ActiveShardCount;
import org.elasticsearch.action.support.master.TransportMasterNodeAction;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.metadata.MetadataCreateIndexService;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.indices.SystemIndexDescriptor;
import org.elasticsearch.indices.SystemIndices;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;

public class TransportCreateIndexAction
extends TransportMasterNodeAction<CreateIndexRequest, CreateIndexResponse> {
    private static final Logger logger = LogManager.getLogger(TransportCreateIndexAction.class);
    private final MetadataCreateIndexService createIndexService;
    private final SystemIndices systemIndices;

    @Inject
    public TransportCreateIndexAction(TransportService transportService, ClusterService clusterService, ThreadPool threadPool, MetadataCreateIndexService createIndexService, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver, SystemIndices systemIndices) {
        super("indices:admin/create", transportService, clusterService, threadPool, actionFilters, CreateIndexRequest::new, indexNameExpressionResolver, CreateIndexResponse::new, "same");
        this.createIndexService = createIndexService;
        this.systemIndices = systemIndices;
    }

    @Override
    protected ClusterBlockException checkBlock(CreateIndexRequest request, ClusterState state) {
        return state.blocks().indexBlockedException(ClusterBlockLevel.METADATA_WRITE, request.index());
    }

    @Override
    protected void masterOperation(Task task, CreateIndexRequest request, ClusterState state, ActionListener<CreateIndexResponse> listener) {
        CreateIndexClusterStateUpdateRequest updateRequest;
        SystemIndices.SystemIndexAccessLevel systemIndexAccessLevel;
        boolean isSystemIndex;
        String cause = request.cause();
        if (cause.isEmpty()) {
            cause = "api";
        }
        long resolvedAt = System.currentTimeMillis();
        String indexName = this.indexNameExpressionResolver.resolveDateMathExpression(request.index(), resolvedAt);
        SystemIndexDescriptor mainDescriptor = this.systemIndices.findMatchingDescriptor(indexName);
        boolean bl = isSystemIndex = mainDescriptor != null && mainDescriptor.isAutomaticallyManaged();
        if (mainDescriptor != null && mainDescriptor.isNetNew() && (systemIndexAccessLevel = this.systemIndices.getSystemIndexAccessLevel(this.threadPool.getThreadContext())) != SystemIndices.SystemIndexAccessLevel.ALL) {
            if (systemIndexAccessLevel == SystemIndices.SystemIndexAccessLevel.RESTRICTED) {
                if (!this.systemIndices.getProductSystemIndexNamePredicate(this.threadPool.getThreadContext()).test(indexName)) {
                    throw this.systemIndices.netNewSystemIndexAccessException(this.threadPool.getThreadContext(), List.of(indexName));
                }
            } else {
                assert (systemIndexAccessLevel == SystemIndices.SystemIndexAccessLevel.NONE) : "Expected no system index access but level is " + systemIndexAccessLevel;
                throw this.systemIndices.netNewSystemIndexAccessException(this.threadPool.getThreadContext(), List.of(indexName));
            }
        }
        if (isSystemIndex && Strings.isNullOrEmpty(request.origin())) {
            SystemIndexDescriptor descriptor = mainDescriptor.getDescriptorCompatibleWith(state.nodes().getSmallestNonClientNodeVersion());
            if (descriptor == null) {
                String message = mainDescriptor.getMinimumNodeVersionMessage("create index");
                logger.warn(message);
                listener.onFailure(new IllegalStateException(message));
                return;
            }
            updateRequest = this.buildSystemIndexUpdateRequest(request, cause, descriptor);
        } else {
            updateRequest = this.buildUpdateRequest(request, cause, indexName, resolvedAt);
        }
        this.createIndexService.createIndex(updateRequest, listener.map(response -> new CreateIndexResponse(response.isAcknowledged(), response.isShardsAcknowledged(), indexName)));
    }

    private CreateIndexClusterStateUpdateRequest buildUpdateRequest(CreateIndexRequest request, String cause, String indexName, long nameResolvedAt) {
        return ((CreateIndexClusterStateUpdateRequest)((CreateIndexClusterStateUpdateRequest)new CreateIndexClusterStateUpdateRequest(cause, indexName, request.index()).ackTimeout(request.timeout())).masterNodeTimeout(request.masterNodeTimeout())).settings(request.settings()).mappings(request.mappings()).aliases(request.aliases()).nameResolvedInstant(nameResolvedAt).waitForActiveShards(request.waitForActiveShards());
    }

    private CreateIndexClusterStateUpdateRequest buildSystemIndexUpdateRequest(CreateIndexRequest request, String cause, SystemIndexDescriptor descriptor) {
        Settings settings = Objects.requireNonNullElse(descriptor.getSettings(), Settings.EMPTY);
        Set<Object> aliases = descriptor.getAliasName() == null ? Set.of() : Set.of(new Alias(descriptor.getAliasName()));
        CreateIndexClusterStateUpdateRequest updateRequest = new CreateIndexClusterStateUpdateRequest(cause, descriptor.getPrimaryIndex(), request.index());
        return ((CreateIndexClusterStateUpdateRequest)((CreateIndexClusterStateUpdateRequest)updateRequest.ackTimeout(request.timeout())).masterNodeTimeout(request.masterNodeTimeout())).aliases(aliases).waitForActiveShards(ActiveShardCount.ALL).mappings(descriptor.getMappings()).settings(settings);
    }
}

