/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.indices.mapping.get;

import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.Version;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.xcontent.XContentHelper;
import org.elasticsearch.core.RestApiVersion;
import org.elasticsearch.xcontent.ConstructingObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentFragment;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentType;

public class GetFieldMappingsResponse
extends ActionResponse
implements ToXContentObject {
    private static final ParseField MAPPINGS = new ParseField("mappings", new String[0]);
    private final Map<String, Map<String, FieldMappingMetadata>> mappings;

    GetFieldMappingsResponse(Map<String, Map<String, FieldMappingMetadata>> mappings) {
        this.mappings = mappings;
    }

    GetFieldMappingsResponse(StreamInput in) throws IOException {
        super(in);
        this.mappings = Collections.unmodifiableMap(in.readMap(StreamInput::readString, mapIn -> {
            if (mapIn.getVersion().before(Version.V_8_0_0)) {
                int typesSize = mapIn.readVInt();
                assert (typesSize == 1 || typesSize == 0) : "Expected 0 or 1 types but got " + typesSize;
                if (typesSize == 0) {
                    return Collections.emptyMap();
                }
                mapIn.readString();
            }
            return Collections.unmodifiableMap(mapIn.readMap(StreamInput::readString, inpt -> new FieldMappingMetadata(inpt.readString(), inpt.readBytesReference())));
        }));
    }

    public Map<String, Map<String, FieldMappingMetadata>> mappings() {
        return this.mappings;
    }

    public FieldMappingMetadata fieldMappings(String index, String field) {
        Map<String, FieldMappingMetadata> indexMapping = this.mappings.get(index);
        if (indexMapping == null) {
            return null;
        }
        return indexMapping.get(field);
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        for (Map.Entry<String, Map<String, FieldMappingMetadata>> indexEntry : this.mappings.entrySet()) {
            builder.startObject(indexEntry.getKey());
            builder.startObject(MAPPINGS.getPreferredName());
            if (indexEntry.getValue() != null) {
                if (builder.getRestApiVersion() == RestApiVersion.V_7 && params.paramAsBoolean("include_type_name", false)) {
                    if (indexEntry.getValue().size() > 0) {
                        builder.startObject("_doc");
                        this.addFieldMappingsToBuilder(builder, params, indexEntry.getValue());
                        builder.endObject();
                    }
                } else {
                    this.addFieldMappingsToBuilder(builder, params, indexEntry.getValue());
                }
            }
            builder.endObject();
            builder.endObject();
        }
        builder.endObject();
        return builder;
    }

    private void addFieldMappingsToBuilder(XContentBuilder builder, ToXContent.Params params, Map<String, FieldMappingMetadata> mappings) throws IOException {
        for (Map.Entry<String, FieldMappingMetadata> fieldEntry : mappings.entrySet()) {
            builder.startObject(fieldEntry.getKey());
            fieldEntry.getValue().toXContent(builder, params);
            builder.endObject();
        }
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeMap(this.mappings, StreamOutput::writeString, (outpt, map) -> {
            if (outpt.getVersion().before(Version.V_8_0_0)) {
                outpt.writeVInt(1);
                outpt.writeString("_doc");
            }
            outpt.writeMap(map, StreamOutput::writeString, (o, v) -> {
                o.writeString(v.fullName());
                o.writeBytesReference(v.source);
            });
        });
    }

    public String toString() {
        return "GetFieldMappingsResponse{mappings=" + this.mappings + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GetFieldMappingsResponse)) {
            return false;
        }
        GetFieldMappingsResponse that = (GetFieldMappingsResponse)o;
        return Objects.equals(this.mappings, that.mappings);
    }

    public int hashCode() {
        return Objects.hash(this.mappings);
    }

    public static class FieldMappingMetadata
    implements ToXContentFragment {
        private static final ParseField FULL_NAME = new ParseField("full_name", new String[0]);
        private static final ParseField MAPPING = new ParseField("mapping", new String[0]);
        private static final ConstructingObjectParser<FieldMappingMetadata, String> PARSER = new ConstructingObjectParser("field_mapping_meta_data", true, a -> new FieldMappingMetadata((String)a[0], (BytesReference)a[1]));
        private final String fullName;
        private final BytesReference source;

        public FieldMappingMetadata(String fullName, BytesReference source) {
            this.fullName = fullName;
            this.source = source;
        }

        public String fullName() {
            return this.fullName;
        }

        public Map<String, Object> sourceAsMap() {
            return XContentHelper.convertToMap(this.source, true, XContentType.JSON).v2();
        }

        BytesReference getSource() {
            return this.source;
        }

        @Override
        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.field(FULL_NAME.getPreferredName(), this.fullName);
            if (params.paramAsBoolean("pretty", false)) {
                builder.field("mapping", this.sourceAsMap());
            } else {
                try (StreamInput stream = this.source.streamInput();){
                    builder.rawField(MAPPING.getPreferredName(), stream, XContentType.JSON);
                }
            }
            return builder;
        }

        public String toString() {
            return "FieldMappingMetadata{fullName='" + this.fullName + "', source=" + this.source + "}";
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof FieldMappingMetadata)) {
                return false;
            }
            FieldMappingMetadata that = (FieldMappingMetadata)o;
            return Objects.equals(this.fullName, that.fullName) && Objects.equals(this.source, that.source);
        }

        public int hashCode() {
            return Objects.hash(this.fullName, this.source);
        }
    }
}

