/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.geo;

import java.util.List;
import java.util.Locale;
import java.util.function.Function;
import org.elasticsearch.common.geo.GeoFormatterFactory;
import org.elasticsearch.common.geo.GeoPoint;
import org.elasticsearch.common.geo.SimpleFeatureFactory;
import org.elasticsearch.search.aggregations.bucket.geogrid.GeoTileUtils;

public class SimpleVectorTileFormatter
implements GeoFormatterFactory.FormatterFactory<GeoPoint> {
    public static final String MVT = "mvt";

    @Override
    public String getName() {
        return MVT;
    }

    @Override
    public Function<String, Function<List<GeoPoint>, List<Object>>> getFormatterBuilder() {
        return params -> {
            int[] parsed = SimpleVectorTileFormatter.parse(params);
            SimpleFeatureFactory featureFactory = new SimpleFeatureFactory(parsed[0], parsed[1], parsed[2], parsed[3]);
            return points -> List.of(featureFactory.points((List<GeoPoint>)points));
        };
    }

    public static int[] parse(String param) {
        String[] parts = param.split("@", 3);
        if (parts.length > 2) {
            throw new IllegalArgumentException("Invalid mvt formatter parameter [" + param + "]. Must have the form \"zoom/x/y\" or \"zoom/x/y@extent\".");
        }
        int extent = parts.length == 2 ? Integer.parseInt(parts[1]) : 4096;
        String[] tileBits = parts[0].split("/", 4);
        if (tileBits.length != 3) {
            throw new IllegalArgumentException("Invalid tile string [" + parts[0] + "]. Must be three integers in a form \"zoom/x/y\".");
        }
        int z = GeoTileUtils.checkPrecisionRange(Integer.parseInt(tileBits[0]));
        int tiles = 1 << z;
        int x = Integer.parseInt(tileBits[1]);
        int y = Integer.parseInt(tileBits[2]);
        if (x < 0 || y < 0 || x >= tiles || y >= tiles) {
            throw new IllegalArgumentException(String.format(Locale.ROOT, "Zoom/X/Y combination is not valid: %d/%d/%d", z, x, y));
        }
        return new int[]{z, x, y, extent};
    }
}

