/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.fielddata.plain;

import java.util.Collection;
import java.util.Collections;
import java.util.function.Function;
import org.apache.lucene.index.DocValues;
import org.apache.lucene.index.SortedSetDocValues;
import org.apache.lucene.util.Accountable;
import org.elasticsearch.index.fielddata.FieldData;
import org.elasticsearch.index.fielddata.LeafOrdinalsFieldData;
import org.elasticsearch.index.fielddata.ScriptDocValues;
import org.elasticsearch.index.fielddata.SortedBinaryDocValues;
import org.elasticsearch.script.field.DelegateDocValuesField;
import org.elasticsearch.script.field.DocValuesField;

public abstract class AbstractLeafOrdinalsFieldData
implements LeafOrdinalsFieldData {
    public static final Function<SortedSetDocValues, ScriptDocValues<?>> DEFAULT_SCRIPT_FUNCTION = ((Function<SortedSetDocValues, SortedBinaryDocValues>)FieldData::toString).andThen(ScriptDocValues.Strings::new);
    private final Function<SortedSetDocValues, ScriptDocValues<?>> scriptFunction;

    protected AbstractLeafOrdinalsFieldData(Function<SortedSetDocValues, ScriptDocValues<?>> scriptFunction) {
        this.scriptFunction = scriptFunction;
    }

    @Override
    public final DocValuesField getScriptField(String name) {
        return new DelegateDocValuesField(this.scriptFunction.apply(this.getOrdinalsValues()), name);
    }

    @Override
    public final SortedBinaryDocValues getBytesValues() {
        return FieldData.toString(this.getOrdinalsValues());
    }

    public static LeafOrdinalsFieldData empty() {
        return new AbstractLeafOrdinalsFieldData((Function)DEFAULT_SCRIPT_FUNCTION){

            @Override
            public long ramBytesUsed() {
                return 0L;
            }

            @Override
            public Collection<Accountable> getChildResources() {
                return Collections.emptyList();
            }

            @Override
            public void close() {
            }

            @Override
            public SortedSetDocValues getOrdinalsValues() {
                return DocValues.emptySortedSet();
            }
        };
    }
}

