/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.FieldType;
import org.apache.lucene.document.SortedSetDocValuesField;
import org.apache.lucene.index.FilteredTermsEnum;
import org.apache.lucene.index.IndexOptions;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexableFieldType;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.MultiTerms;
import org.apache.lucene.index.Terms;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.search.MultiTermQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.automaton.Automata;
import org.apache.lucene.util.automaton.Automaton;
import org.apache.lucene.util.automaton.CompiledAutomaton;
import org.apache.lucene.util.automaton.MinimizationOperations;
import org.apache.lucene.util.automaton.Operations;
import org.elasticsearch.common.lucene.Lucene;
import org.elasticsearch.common.lucene.search.AutomatonQueries;
import org.elasticsearch.index.analysis.IndexAnalyzers;
import org.elasticsearch.index.analysis.NamedAnalyzer;
import org.elasticsearch.index.fielddata.IndexFieldData;
import org.elasticsearch.index.fielddata.plain.SortedSetOrdinalsIndexFieldData;
import org.elasticsearch.index.mapper.DocumentParserContext;
import org.elasticsearch.index.mapper.FieldMapper;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.index.mapper.MapperBuilderContext;
import org.elasticsearch.index.mapper.MapperParsingException;
import org.elasticsearch.index.mapper.SourceValueFetcher;
import org.elasticsearch.index.mapper.StringFieldType;
import org.elasticsearch.index.mapper.TextParams;
import org.elasticsearch.index.mapper.TextSearchInfo;
import org.elasticsearch.index.mapper.TimeSeriesParams;
import org.elasticsearch.index.mapper.ValueFetcher;
import org.elasticsearch.index.query.SearchExecutionContext;
import org.elasticsearch.index.similarity.SimilarityProvider;
import org.elasticsearch.script.Script;
import org.elasticsearch.script.ScriptCompiler;
import org.elasticsearch.script.StringFieldScript;
import org.elasticsearch.search.aggregations.support.CoreValuesSourceType;
import org.elasticsearch.search.lookup.FieldValues;
import org.elasticsearch.search.lookup.SearchLookup;
import org.elasticsearch.xcontent.XContentParser;

public final class KeywordFieldMapper
extends FieldMapper {
    public static final String CONTENT_TYPE = "keyword";
    public static final FieldMapper.TypeParser PARSER = new FieldMapper.TypeParser((n, c) -> new Builder((String)n, c.getIndexAnalyzers(), c.scriptCompiler()));
    private static final int DIMENSION_MAX_BYTES = 1024;
    private final boolean indexed;
    private final boolean hasDocValues;
    private final String nullValue;
    private final boolean eagerGlobalOrdinals;
    private final int ignoreAbove;
    private final String indexOptions;
    private final FieldType fieldType;
    private final SimilarityProvider similarity;
    private final String normalizerName;
    private final boolean splitQueriesOnWhitespace;
    private final Script script;
    private final FieldValues<String> scriptValues;
    private final ScriptCompiler scriptCompiler;
    private final boolean dimension;
    private final IndexAnalyzers indexAnalyzers;

    private static KeywordFieldMapper toType(FieldMapper in) {
        return (KeywordFieldMapper)in;
    }

    private KeywordFieldMapper(String simpleName, FieldType fieldType, KeywordFieldType mappedFieldType, FieldMapper.MultiFields multiFields, FieldMapper.CopyTo copyTo, Builder builder) {
        super(simpleName, (MappedFieldType)mappedFieldType, mappedFieldType.normalizer, multiFields, copyTo, builder.script.get() != null, builder.onScriptError.getValue());
        assert (fieldType.indexOptions().compareTo(IndexOptions.DOCS_AND_FREQS) <= 0);
        this.indexed = builder.indexed.getValue();
        this.hasDocValues = builder.hasDocValues.getValue();
        this.nullValue = builder.nullValue.getValue();
        this.eagerGlobalOrdinals = builder.eagerGlobalOrdinals.getValue();
        this.ignoreAbove = builder.ignoreAbove.getValue();
        this.indexOptions = builder.indexOptions.getValue();
        this.fieldType = fieldType;
        this.similarity = builder.similarity.getValue();
        this.normalizerName = builder.normalizer.getValue();
        this.splitQueriesOnWhitespace = builder.splitQueriesOnWhitespace.getValue();
        this.script = builder.script.get();
        this.scriptValues = builder.scriptValues();
        this.indexAnalyzers = builder.indexAnalyzers;
        this.scriptCompiler = builder.scriptCompiler;
        this.dimension = builder.dimension.getValue();
    }

    @Override
    public KeywordFieldType fieldType() {
        return (KeywordFieldType)super.fieldType();
    }

    @Override
    protected void parseCreateField(DocumentParserContext context) throws IOException {
        XContentParser parser = context.parser();
        String value = parser.currentToken() == XContentParser.Token.VALUE_NULL ? this.nullValue : parser.textOrNull();
        this.indexValue(context, value);
    }

    @Override
    protected void indexScriptValues(SearchLookup searchLookup, LeafReaderContext readerContext, int doc, DocumentParserContext documentParserContext) {
        this.scriptValues.valuesForDoc(searchLookup, readerContext, doc, value -> this.indexValue(documentParserContext, (String)value));
    }

    private void indexValue(DocumentParserContext context, String value) {
        if (value == null) {
            return;
        }
        if (value.length() > this.ignoreAbove) {
            context.addIgnoredField(this.name());
            return;
        }
        value = KeywordFieldMapper.normalizeValue(this.fieldType().normalizer(), this.name(), value);
        BytesRef binaryValue = new BytesRef(value);
        if (this.dimension && binaryValue.length > 1024) {
            throw new IllegalArgumentException("Dimension field [" + this.fieldType().name() + "] cannot be more than [1024] bytes long.");
        }
        if (this.fieldType.indexOptions() != IndexOptions.NONE || this.fieldType.stored()) {
            KeywordField field = new KeywordField(this.fieldType().name(), binaryValue, this.fieldType);
            if (this.dimension) {
                if (context.doc().getByKey(this.fieldType().name()) != null) {
                    throw new IllegalArgumentException("Dimension field [" + this.fieldType().name() + "] cannot be a multi-valued field.");
                }
                context.doc().addWithKey(this.fieldType().name(), field);
            } else {
                context.doc().add(field);
            }
            if (!this.fieldType().hasDocValues() && this.fieldType.omitNorms()) {
                context.addToFieldNames(this.fieldType().name());
            }
        }
        if (this.fieldType().hasDocValues()) {
            context.doc().add(new SortedSetDocValuesField(this.fieldType().name(), binaryValue));
        }
    }

    private static String normalizeValue(NamedAnalyzer normalizer, String field, String value) {
        String string;
        block11: {
            if (normalizer == Lucene.KEYWORD_ANALYZER) {
                return value;
            }
            TokenStream ts = normalizer.tokenStream(field, value);
            try {
                CharTermAttribute termAtt = ts.addAttribute(CharTermAttribute.class);
                ts.reset();
                if (!ts.incrementToken()) {
                    throw new IllegalStateException("The normalization token stream is expected to produce exactly 1 token, but got 0 for analyzer " + normalizer + " and input \"" + value + "\"");
                }
                String newValue = termAtt.toString();
                if (ts.incrementToken()) {
                    throw new IllegalStateException("The normalization token stream is expected to produce exactly 1 token, but got 2+ for analyzer " + normalizer + " and input \"" + value + "\"");
                }
                ts.end();
                string = newValue;
                if (ts == null) break block11;
            }
            catch (Throwable throwable) {
                try {
                    if (ts != null) {
                        try {
                            ts.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            }
            ts.close();
        }
        return string;
    }

    @Override
    protected String contentType() {
        return CONTENT_TYPE;
    }

    @Override
    public FieldMapper.Builder getMergeBuilder() {
        return new Builder(this.simpleName(), this.indexAnalyzers, this.scriptCompiler).dimension(this.dimension).init(this);
    }

    public static final class KeywordFieldType
    extends StringFieldType {
        private final int ignoreAbove;
        private final String nullValue;
        private final NamedAnalyzer normalizer;
        private final boolean eagerGlobalOrdinals;
        private final FieldValues<String> scriptValues;
        private final boolean isDimension;

        public KeywordFieldType(String name, FieldType fieldType, NamedAnalyzer normalizer, NamedAnalyzer searchAnalyzer, NamedAnalyzer quoteAnalyzer, Builder builder) {
            super(name, fieldType.indexOptions() != IndexOptions.NONE, fieldType.stored(), builder.hasDocValues.getValue(), new TextSearchInfo(fieldType, builder.similarity.getValue(), searchAnalyzer, quoteAnalyzer), builder.meta.getValue());
            this.eagerGlobalOrdinals = builder.eagerGlobalOrdinals.getValue();
            this.normalizer = normalizer;
            this.ignoreAbove = builder.ignoreAbove.getValue();
            this.nullValue = builder.nullValue.getValue();
            this.scriptValues = builder.scriptValues();
            this.isDimension = builder.dimension.getValue();
        }

        public KeywordFieldType(String name, boolean isSearchable, boolean hasDocValues, Map<String, String> meta) {
            super(name, isSearchable, false, hasDocValues, TextSearchInfo.SIMPLE_MATCH_ONLY, meta);
            this.normalizer = Lucene.KEYWORD_ANALYZER;
            this.ignoreAbove = Integer.MAX_VALUE;
            this.nullValue = null;
            this.eagerGlobalOrdinals = false;
            this.scriptValues = null;
            this.isDimension = false;
        }

        public KeywordFieldType(String name) {
            this(name, true, true, Collections.emptyMap());
        }

        public KeywordFieldType(String name, FieldType fieldType) {
            super(name, fieldType.indexOptions() != IndexOptions.NONE, false, false, new TextSearchInfo(fieldType, null, Lucene.KEYWORD_ANALYZER, Lucene.KEYWORD_ANALYZER), Collections.emptyMap());
            this.normalizer = Lucene.KEYWORD_ANALYZER;
            this.ignoreAbove = Integer.MAX_VALUE;
            this.nullValue = null;
            this.eagerGlobalOrdinals = false;
            this.scriptValues = null;
            this.isDimension = false;
        }

        public KeywordFieldType(String name, NamedAnalyzer analyzer) {
            super(name, true, false, true, new TextSearchInfo(Defaults.FIELD_TYPE, null, analyzer, analyzer), Collections.emptyMap());
            this.normalizer = Lucene.KEYWORD_ANALYZER;
            this.ignoreAbove = Integer.MAX_VALUE;
            this.nullValue = null;
            this.eagerGlobalOrdinals = false;
            this.scriptValues = null;
            this.isDimension = false;
        }

        @Override
        public TermsEnum getTerms(boolean caseInsensitive, String string, SearchExecutionContext queryShardContext, String searchAfter) throws IOException {
            BytesRef searchBytes;
            IndexReader reader = queryShardContext.searcher().getTopReaderContext().reader();
            Terms terms = MultiTerms.getTerms(reader, this.name());
            if (terms == null) {
                return null;
            }
            Automaton a = caseInsensitive ? AutomatonQueries.caseInsensitivePrefix(string) : Automata.makeString(string);
            a = Operations.concatenate(a, Automata.makeAnyString());
            a = MinimizationOperations.minimize(a, Integer.MAX_VALUE);
            CompiledAutomaton automaton = new CompiledAutomaton(a);
            BytesRef bytesRef = searchBytes = searchAfter == null ? null : new BytesRef(searchAfter);
            if (automaton.type == CompiledAutomaton.AUTOMATON_TYPE.ALL) {
                TermsEnum result = terms.iterator();
                if (searchAfter != null) {
                    result = new SearchAfterTermsEnum(result, searchBytes);
                }
                return result;
            }
            return terms.intersect(automaton, searchBytes);
        }

        @Override
        public String typeName() {
            return KeywordFieldMapper.CONTENT_TYPE;
        }

        @Override
        public boolean eagerGlobalOrdinals() {
            return this.eagerGlobalOrdinals;
        }

        NamedAnalyzer normalizer() {
            return this.normalizer;
        }

        @Override
        public IndexFieldData.Builder fielddataBuilder(String fullyQualifiedIndexName, Supplier<SearchLookup> searchLookup) {
            this.failIfNoDocValues();
            return new SortedSetOrdinalsIndexFieldData.Builder(this.name(), CoreValuesSourceType.KEYWORD);
        }

        @Override
        public ValueFetcher valueFetcher(SearchExecutionContext context, String format) {
            if (format != null) {
                throw new IllegalArgumentException("Field [" + this.name() + "] of type [" + this.typeName() + "] doesn't support formats.");
            }
            if (this.scriptValues != null) {
                return FieldValues.valueFetcher(this.scriptValues, context);
            }
            return new SourceValueFetcher(this.name(), context, this.nullValue){

                @Override
                protected String parseSourceValue(Object value) {
                    String keywordValue = value.toString();
                    if (keywordValue.length() > ignoreAbove) {
                        return null;
                    }
                    return KeywordFieldMapper.normalizeValue(this.normalizer(), this.name(), keywordValue);
                }
            };
        }

        @Override
        public Object valueForDisplay(Object value) {
            if (value == null) {
                return null;
            }
            BytesRef binaryValue = (BytesRef)value;
            return binaryValue.utf8ToString();
        }

        @Override
        protected BytesRef indexedValueForSearch(Object value) {
            if (this.getTextSearchInfo().getSearchAnalyzer() == Lucene.KEYWORD_ANALYZER) {
                return super.indexedValueForSearch(value);
            }
            if (value == null) {
                return null;
            }
            if (value instanceof BytesRef) {
                value = ((BytesRef)value).utf8ToString();
            }
            return this.getTextSearchInfo().getSearchAnalyzer().normalize(this.name(), value.toString());
        }

        @Override
        public Query wildcardQuery(String value, MultiTermQuery.RewriteMethod method, boolean caseInsensitive, SearchExecutionContext context) {
            return super.wildcardQuery(value, method, caseInsensitive, true, context);
        }

        @Override
        public MappedFieldType.CollapseType collapseType() {
            return MappedFieldType.CollapseType.KEYWORD;
        }

        public int ignoreAbove() {
            return this.ignoreAbove;
        }

        @Override
        public boolean isDimension() {
            return this.isDimension;
        }

        @Override
        public void validateMatchedRoutingPath() {
            if (!this.isDimension) {
                throw new IllegalArgumentException("All fields that match routing_path must be keywords with [time_series_dimension: true] and without the [script] parameter. [" + this.name() + "] was not [time_series_dimension: true].");
            }
            if (this.scriptValues != null) {
                throw new IllegalArgumentException("All fields that match routing_path must be keywords with [time_series_dimension: true] and without the [script] parameter. [" + this.name() + "] has a [script] parameter.");
            }
        }

        final class SearchAfterTermsEnum
        extends FilteredTermsEnum {
            private final BytesRef afterRef;

            SearchAfterTermsEnum(TermsEnum tenum, BytesRef termText) {
                super(tenum);
                this.afterRef = termText;
                this.setInitialSeekTerm(termText);
            }

            @Override
            protected FilteredTermsEnum.AcceptStatus accept(BytesRef term) {
                return term.equals(this.afterRef) ? FilteredTermsEnum.AcceptStatus.NO : FilteredTermsEnum.AcceptStatus.YES;
            }
        }
    }

    public static class Builder
    extends FieldMapper.Builder {
        private final FieldMapper.Parameter<Boolean> indexed = FieldMapper.Parameter.indexParam(m -> KeywordFieldMapper.toType((FieldMapper)m).indexed, true);
        private final FieldMapper.Parameter<Boolean> hasDocValues = FieldMapper.Parameter.docValuesParam(m -> KeywordFieldMapper.toType((FieldMapper)m).hasDocValues, true);
        private final FieldMapper.Parameter<Boolean> stored = FieldMapper.Parameter.storeParam(m -> KeywordFieldMapper.toType((FieldMapper)m).fieldType.stored(), false);
        private final FieldMapper.Parameter<String> nullValue = FieldMapper.Parameter.stringParam("null_value", false, m -> KeywordFieldMapper.toType((FieldMapper)m).nullValue, null).acceptsNull();
        private final FieldMapper.Parameter<Boolean> eagerGlobalOrdinals = FieldMapper.Parameter.boolParam("eager_global_ordinals", true, m -> KeywordFieldMapper.toType((FieldMapper)m).eagerGlobalOrdinals, false);
        private final FieldMapper.Parameter<Integer> ignoreAbove = FieldMapper.Parameter.intParam("ignore_above", true, m -> KeywordFieldMapper.toType((FieldMapper)m).ignoreAbove, Integer.MAX_VALUE);
        private final FieldMapper.Parameter<String> indexOptions = FieldMapper.Parameter.restrictedStringParam("index_options", false, m -> KeywordFieldMapper.toType((FieldMapper)m).indexOptions, "docs", "freqs");
        private final FieldMapper.Parameter<Boolean> hasNorms = TextParams.norms(false, m -> !KeywordFieldMapper.toType((FieldMapper)m).fieldType.omitNorms());
        private final FieldMapper.Parameter<SimilarityProvider> similarity = TextParams.similarity(m -> KeywordFieldMapper.toType((FieldMapper)m).similarity);
        private final FieldMapper.Parameter<String> normalizer = FieldMapper.Parameter.stringParam("normalizer", false, m -> KeywordFieldMapper.toType((FieldMapper)m).normalizerName, null).acceptsNull();
        private final FieldMapper.Parameter<Boolean> splitQueriesOnWhitespace = FieldMapper.Parameter.boolParam("split_queries_on_whitespace", true, m -> KeywordFieldMapper.toType((FieldMapper)m).splitQueriesOnWhitespace, false);
        private final FieldMapper.Parameter<Map<String, String>> meta = FieldMapper.Parameter.metaParam();
        private final FieldMapper.Parameter<Script> script = FieldMapper.Parameter.scriptParam(m -> KeywordFieldMapper.toType((FieldMapper)m).script);
        private final FieldMapper.Parameter<String> onScriptError = FieldMapper.Parameter.onScriptErrorParam(m -> KeywordFieldMapper.toType((FieldMapper)m).onScriptError, this.script);
        private final FieldMapper.Parameter<Boolean> dimension;
        private final IndexAnalyzers indexAnalyzers;
        private final ScriptCompiler scriptCompiler;

        public Builder(String name, IndexAnalyzers indexAnalyzers, ScriptCompiler scriptCompiler) {
            super(name);
            this.indexAnalyzers = indexAnalyzers;
            this.scriptCompiler = Objects.requireNonNull(scriptCompiler);
            this.script.precludesParameters(this.nullValue);
            this.addScriptValidation(this.script, this.indexed, this.hasDocValues);
            this.dimension = TimeSeriesParams.dimensionParam(m -> KeywordFieldMapper.toType((FieldMapper)m).dimension).addValidator(v -> {
                if (!(!v.booleanValue() || this.indexed.getValue().booleanValue() && this.hasDocValues.getValue().booleanValue())) {
                    throw new IllegalArgumentException("Field [time_series_dimension] requires that [" + this.indexed.name + "] and [" + this.hasDocValues.name + "] are true");
                }
            }).precludesParameters(this.normalizer, this.ignoreAbove);
        }

        public Builder(String name) {
            this(name, null, ScriptCompiler.NONE);
        }

        public Builder ignoreAbove(int ignoreAbove) {
            this.ignoreAbove.setValue(ignoreAbove);
            return this;
        }

        Builder normalizer(String normalizerName) {
            this.normalizer.setValue(normalizerName);
            return this;
        }

        Builder nullValue(String nullValue) {
            this.nullValue.setValue(nullValue);
            return this;
        }

        public Builder docValues(boolean hasDocValues) {
            this.hasDocValues.setValue(hasDocValues);
            return this;
        }

        public Builder dimension(boolean dimension) {
            this.dimension.setValue(dimension);
            return this;
        }

        private FieldValues<String> scriptValues() {
            if (this.script.get() == null) {
                return null;
            }
            StringFieldScript.Factory scriptFactory = this.scriptCompiler.compile(this.script.get(), StringFieldScript.CONTEXT);
            return scriptFactory == null ? null : (lookup, ctx, doc, consumer) -> scriptFactory.newFactory(this.name, this.script.get().getParams(), lookup).newInstance(ctx).runForDoc(doc, consumer);
        }

        @Override
        protected List<FieldMapper.Parameter<?>> getParameters() {
            return List.of(this.indexed, this.hasDocValues, this.stored, this.nullValue, this.eagerGlobalOrdinals, this.ignoreAbove, this.indexOptions, this.hasNorms, this.similarity, this.normalizer, this.splitQueriesOnWhitespace, this.script, this.onScriptError, this.meta, this.dimension);
        }

        private KeywordFieldType buildFieldType(MapperBuilderContext context, FieldType fieldType) {
            NamedAnalyzer normalizer = Lucene.KEYWORD_ANALYZER;
            NamedAnalyzer searchAnalyzer = Lucene.KEYWORD_ANALYZER;
            NamedAnalyzer quoteAnalyzer = Lucene.KEYWORD_ANALYZER;
            String normalizerName = this.normalizer.getValue();
            if (normalizerName != null) {
                assert (this.indexAnalyzers != null);
                normalizer = this.indexAnalyzers.getNormalizer(normalizerName);
                if (normalizer == null) {
                    throw new MapperParsingException("normalizer [" + normalizerName + "] not found for field [" + this.name + "]");
                }
                searchAnalyzer = quoteAnalyzer = normalizer;
                if (this.splitQueriesOnWhitespace.getValue().booleanValue()) {
                    searchAnalyzer = this.indexAnalyzers.getWhitespaceNormalizer(normalizerName);
                }
            } else if (this.splitQueriesOnWhitespace.getValue().booleanValue()) {
                searchAnalyzer = Lucene.WHITESPACE_ANALYZER;
            }
            return new KeywordFieldType(context.buildFullName(this.name), fieldType, normalizer, searchAnalyzer, quoteAnalyzer, this);
        }

        @Override
        public KeywordFieldMapper build(MapperBuilderContext context) {
            FieldType fieldtype = new FieldType(Defaults.FIELD_TYPE);
            fieldtype.setOmitNorms(this.hasNorms.getValue() == false);
            fieldtype.setIndexOptions(TextParams.toIndexOptions(this.indexed.getValue(), this.indexOptions.getValue()));
            fieldtype.setStored(this.stored.getValue());
            return new KeywordFieldMapper(this.name, fieldtype, this.buildFieldType(context, fieldtype), this.multiFieldsBuilder.build(this, context), this.copyTo.build(), this);
        }
    }

    public static class KeywordField
    extends Field {
        public KeywordField(String field, BytesRef term, FieldType ft) {
            super(field, term, (IndexableFieldType)ft);
        }
    }

    public static class Defaults {
        public static final FieldType FIELD_TYPE = new FieldType();

        static {
            FIELD_TYPE.setTokenized(false);
            FIELD_TYPE.setOmitNorms(true);
            FIELD_TYPE.setIndexOptions(IndexOptions.DOCS);
            FIELD_TYPE.freeze();
        }
    }
}

