/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.query;

import java.io.IOException;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.SortedNumericDocValues;
import org.apache.lucene.index.Term;
import org.apache.lucene.sandbox.search.CoveringQuery;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.DoubleValues;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.LongValues;
import org.apache.lucene.search.LongValuesSource;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.elasticsearch.common.ParsingException;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.lucene.BytesRefs;
import org.elasticsearch.common.lucene.search.Queries;
import org.elasticsearch.index.fielddata.IndexNumericFieldData;
import org.elasticsearch.index.fielddata.LeafNumericFieldData;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.index.query.AbstractQueryBuilder;
import org.elasticsearch.index.query.QueryShardException;
import org.elasticsearch.index.query.SearchExecutionContext;
import org.elasticsearch.index.query.TermsQueryBuilder;
import org.elasticsearch.script.Script;
import org.elasticsearch.script.TermsSetQueryScript;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;

public final class TermsSetQueryBuilder
extends AbstractQueryBuilder<TermsSetQueryBuilder> {
    public static final String NAME = "terms_set";
    static final ParseField TERMS_FIELD = new ParseField("terms", new String[0]);
    static final ParseField MINIMUM_SHOULD_MATCH_FIELD = new ParseField("minimum_should_match_field", new String[0]);
    static final ParseField MINIMUM_SHOULD_MATCH_SCRIPT = new ParseField("minimum_should_match_script", new String[0]);
    private final String fieldName;
    private final List<?> values;
    private String minimumShouldMatchField;
    private Script minimumShouldMatchScript;

    public TermsSetQueryBuilder(String fieldName, List<?> values) {
        this(fieldName, values, true);
    }

    private TermsSetQueryBuilder(String fieldName, List<?> values, boolean convert) {
        this.fieldName = Objects.requireNonNull(fieldName);
        Objects.requireNonNull(values);
        this.values = convert ? values.stream().map(AbstractQueryBuilder::maybeConvertToBytesRef).collect(Collectors.toList()) : values;
    }

    public TermsSetQueryBuilder(StreamInput in) throws IOException {
        super(in);
        this.fieldName = in.readString();
        this.values = (List)in.readGenericValue();
        this.minimumShouldMatchField = in.readOptionalString();
        this.minimumShouldMatchScript = in.readOptionalWriteable(Script::new);
    }

    @Override
    protected void doWriteTo(StreamOutput out) throws IOException {
        out.writeString(this.fieldName);
        out.writeGenericValue(this.values);
        out.writeOptionalString(this.minimumShouldMatchField);
        out.writeOptionalWriteable(this.minimumShouldMatchScript);
    }

    String getFieldName() {
        return this.fieldName;
    }

    public List<?> getValues() {
        return this.values;
    }

    public String getMinimumShouldMatchField() {
        return this.minimumShouldMatchField;
    }

    public TermsSetQueryBuilder setMinimumShouldMatchField(String minimumShouldMatchField) {
        if (this.minimumShouldMatchScript != null) {
            throw new IllegalArgumentException("A script has already been specified. Cannot specify both a field and script");
        }
        this.minimumShouldMatchField = minimumShouldMatchField;
        return this;
    }

    public Script getMinimumShouldMatchScript() {
        return this.minimumShouldMatchScript;
    }

    public TermsSetQueryBuilder setMinimumShouldMatchScript(Script minimumShouldMatchScript) {
        if (this.minimumShouldMatchField != null) {
            throw new IllegalArgumentException("A field has already been specified. Cannot specify both a field and script");
        }
        this.minimumShouldMatchScript = minimumShouldMatchScript;
        return this;
    }

    @Override
    protected boolean doEquals(TermsSetQueryBuilder other) {
        return Objects.equals(this.fieldName, other.fieldName) && Objects.equals(this.values, other.values) && Objects.equals(this.minimumShouldMatchField, other.minimumShouldMatchField) && Objects.equals(this.minimumShouldMatchScript, other.minimumShouldMatchScript);
    }

    @Override
    protected int doHashCode() {
        return Objects.hash(this.fieldName, this.values, this.minimumShouldMatchField, this.minimumShouldMatchScript);
    }

    @Override
    public String getWriteableName() {
        return NAME;
    }

    @Override
    protected void doXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject(NAME);
        builder.startObject(this.fieldName);
        builder.field(TERMS_FIELD.getPreferredName(), TermsSetQueryBuilder.convertBack(this.values));
        if (this.minimumShouldMatchField != null) {
            builder.field(MINIMUM_SHOULD_MATCH_FIELD.getPreferredName(), this.minimumShouldMatchField);
        }
        if (this.minimumShouldMatchScript != null) {
            builder.field(MINIMUM_SHOULD_MATCH_SCRIPT.getPreferredName(), this.minimumShouldMatchScript);
        }
        this.printBoostAndQueryName(builder);
        builder.endObject();
        builder.endObject();
    }

    public static TermsSetQueryBuilder fromXContent(XContentParser parser) throws IOException {
        String currentFieldName;
        XContentParser.Token token = parser.nextToken();
        if (token != XContentParser.Token.FIELD_NAME) {
            throw new ParsingException(parser.getTokenLocation(), "[terms_set] unknown token [" + token + "]", new Object[0]);
        }
        String fieldName = currentFieldName = parser.currentName();
        token = parser.nextToken();
        if (token != XContentParser.Token.START_OBJECT) {
            throw new ParsingException(parser.getTokenLocation(), "[terms_set] unknown token [" + token + "]", new Object[0]);
        }
        List<Object> values = new ArrayList();
        String minimumShouldMatchField = null;
        Script minimumShouldMatchScript = null;
        String queryName = null;
        float boost = 1.0f;
        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            if (token == XContentParser.Token.FIELD_NAME) {
                currentFieldName = parser.currentName();
                continue;
            }
            if (token == XContentParser.Token.START_ARRAY) {
                if (TERMS_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                    values = TermsQueryBuilder.parseValues(parser);
                    continue;
                }
                throw new ParsingException(parser.getTokenLocation(), "[terms_set] query does not support [" + currentFieldName + "]", new Object[0]);
            }
            if (token == XContentParser.Token.START_OBJECT) {
                if (MINIMUM_SHOULD_MATCH_SCRIPT.match(currentFieldName, parser.getDeprecationHandler())) {
                    minimumShouldMatchScript = Script.parse(parser);
                    continue;
                }
                throw new ParsingException(parser.getTokenLocation(), "[terms_set] query does not support [" + currentFieldName + "]", new Object[0]);
            }
            if (token.isValue()) {
                if (MINIMUM_SHOULD_MATCH_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                    minimumShouldMatchField = parser.text();
                    continue;
                }
                if (AbstractQueryBuilder.BOOST_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                    boost = parser.floatValue();
                    continue;
                }
                if (AbstractQueryBuilder.NAME_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                    queryName = parser.text();
                    continue;
                }
                throw new ParsingException(parser.getTokenLocation(), "[terms_set] query does not support [" + currentFieldName + "]", new Object[0]);
            }
            throw new ParsingException(parser.getTokenLocation(), "[terms_set] unknown token [" + token + "] after [" + currentFieldName + "]", new Object[0]);
        }
        token = parser.nextToken();
        if (token != XContentParser.Token.END_OBJECT) {
            throw new ParsingException(parser.getTokenLocation(), "[terms_set] unknown token [" + token + "]", new Object[0]);
        }
        TermsSetQueryBuilder queryBuilder = (TermsSetQueryBuilder)((TermsSetQueryBuilder)new TermsSetQueryBuilder(fieldName, values, false).queryName(queryName)).boost(boost);
        if (minimumShouldMatchField != null) {
            queryBuilder.setMinimumShouldMatchField(minimumShouldMatchField);
        }
        if (minimumShouldMatchScript != null) {
            queryBuilder.setMinimumShouldMatchScript(minimumShouldMatchScript);
        }
        return queryBuilder;
    }

    @Override
    protected Query doToQuery(SearchExecutionContext context) {
        if (this.values.isEmpty()) {
            return Queries.newMatchNoDocsQuery("No terms supplied for \"" + this.getName() + "\" query.");
        }
        if (this.values.size() > BooleanQuery.getMaxClauseCount()) {
            throw new BooleanQuery.TooManyClauses();
        }
        List<Query> queries = this.createTermQueries(context);
        LongValuesSource longValuesSource = this.createValuesSource(context);
        return new CoveringQuery(queries, longValuesSource);
    }

    List<Query> createTermQueries(SearchExecutionContext context) {
        MappedFieldType fieldType = context.getFieldType(this.fieldName);
        ArrayList<Query> queries = new ArrayList<Query>(this.values.size());
        for (Object value : this.values) {
            if (fieldType != null) {
                queries.add(fieldType.termQuery(value, context));
                continue;
            }
            queries.add(new TermQuery(new Term(this.fieldName, BytesRefs.toBytesRef(value))));
        }
        return queries;
    }

    private LongValuesSource createValuesSource(SearchExecutionContext context) {
        LongValuesSource longValuesSource;
        if (this.minimumShouldMatchField != null) {
            MappedFieldType msmFieldType = context.getFieldType(this.minimumShouldMatchField);
            if (msmFieldType == null) {
                throw new QueryShardException(context, "failed to find minimum_should_match field [" + this.minimumShouldMatchField + "]", new Object[0]);
            }
            IndexNumericFieldData fieldData = (IndexNumericFieldData)context.getForField(msmFieldType);
            longValuesSource = new FieldValuesSource(fieldData);
        } else if (this.minimumShouldMatchScript != null) {
            TermsSetQueryScript.Factory factory = context.compile(this.minimumShouldMatchScript, TermsSetQueryScript.CONTEXT);
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.putAll(this.minimumShouldMatchScript.getParams());
            params.put("num_terms", this.values.size());
            longValuesSource = new ScriptLongValueSource(this.minimumShouldMatchScript, factory.newFactory(params, context.lookup()));
        } else {
            throw new IllegalStateException("No minimum should match has been specified");
        }
        return longValuesSource;
    }

    private static List<Object> convertBack(final List<?> list) {
        return new AbstractList<Object>(){

            @Override
            public int size() {
                return list.size();
            }

            @Override
            public Object get(int index) {
                return AbstractQueryBuilder.maybeConvertToString(list.get(index));
            }
        };
    }

    static class FieldValuesSource
    extends LongValuesSource {
        private final String fieldName;
        private final IndexNumericFieldData fieldData;

        FieldValuesSource(IndexNumericFieldData fieldData) {
            this.fieldData = fieldData;
            this.fieldName = fieldData.getFieldName();
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            FieldValuesSource that = (FieldValuesSource)o;
            return Objects.equals(this.fieldName, that.fieldName);
        }

        @Override
        public String toString() {
            return "long(" + this.fieldName + ")";
        }

        @Override
        public int hashCode() {
            return Objects.hash(this.fieldName);
        }

        @Override
        public LongValues getValues(LeafReaderContext ctx, DoubleValues scores) throws IOException {
            final SortedNumericDocValues values = ((LeafNumericFieldData)this.fieldData.load(ctx)).getLongValues();
            return new LongValues(){
                long current = -1L;

                @Override
                public long longValue() throws IOException {
                    return this.current;
                }

                @Override
                public boolean advanceExact(int doc) throws IOException {
                    boolean hasValue = values.advanceExact(doc);
                    if (hasValue) {
                        assert (values.docValueCount() == 1);
                        this.current = values.nextValue();
                        return true;
                    }
                    return false;
                }
            };
        }

        @Override
        public boolean needsScores() {
            return false;
        }

        @Override
        public boolean isCacheable(LeafReaderContext ctx) {
            return true;
        }

        @Override
        public LongValuesSource rewrite(IndexSearcher searcher) throws IOException {
            return this;
        }
    }

    static final class ScriptLongValueSource
    extends LongValuesSource {
        private final Script script;
        private final TermsSetQueryScript.LeafFactory leafFactory;

        ScriptLongValueSource(Script script, TermsSetQueryScript.LeafFactory leafFactory) {
            this.script = script;
            this.leafFactory = leafFactory;
        }

        @Override
        public LongValues getValues(LeafReaderContext ctx, DoubleValues scores) throws IOException {
            final TermsSetQueryScript script = this.leafFactory.newInstance(ctx);
            return new LongValues(){

                @Override
                public long longValue() throws IOException {
                    return script.runAsLong();
                }

                @Override
                public boolean advanceExact(int doc) throws IOException {
                    script.setDocument(doc);
                    return script.execute() != null;
                }
            };
        }

        @Override
        public boolean needsScores() {
            return false;
        }

        @Override
        public int hashCode() {
            int h = this.getClass().hashCode();
            h = 31 * h + this.script.hashCode();
            return h;
        }

        @Override
        public boolean equals(Object obj) {
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            ScriptLongValueSource that = (ScriptLongValueSource)obj;
            return Objects.equals(this.script, that.script);
        }

        @Override
        public String toString() {
            return "script(" + this.script.toString() + ")";
        }

        @Override
        public boolean isCacheable(LeafReaderContext ctx) {
            return false;
        }

        @Override
        public LongValuesSource rewrite(IndexSearcher searcher) throws IOException {
            return this;
        }
    }
}

