/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.shard;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Objects;
import java.util.stream.IntStream;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.index.shard.ShardLongFieldRange;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentFragment;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;

public class IndexLongFieldRange
implements Writeable,
ToXContentFragment {
    public static final IndexLongFieldRange NO_SHARDS = new IndexLongFieldRange(new int[0], Long.MAX_VALUE, Long.MIN_VALUE);
    public static final IndexLongFieldRange EMPTY = new IndexLongFieldRange(null, Long.MAX_VALUE, Long.MIN_VALUE);
    public static final IndexLongFieldRange UNKNOWN = new IndexLongFieldRange(null, Long.MIN_VALUE, Long.MAX_VALUE);
    @Nullable
    private final int[] shards;
    private final long min;
    private final long max;
    private static final byte WIRE_TYPE_OTHER = 0;
    private static final byte WIRE_TYPE_NO_SHARDS = 1;
    private static final byte WIRE_TYPE_UNKNOWN = 2;
    private static final byte WIRE_TYPE_EMPTY = 3;

    private IndexLongFieldRange(int[] shards, long min, long max) {
        assert (min == Long.MAX_VALUE && max == Long.MIN_VALUE || min <= max) : min + " vs " + max;
        assert (shards == null || shards.length > 0 || min == Long.MAX_VALUE && max == Long.MIN_VALUE) : Arrays.toString(shards);
        assert (shards == null || Arrays.equals(shards, Arrays.stream(shards).sorted().distinct().toArray())) : Arrays.toString(shards);
        this.shards = shards;
        this.min = min;
        this.max = max;
    }

    public boolean isComplete() {
        return this.shards == null;
    }

    public boolean containsAllShardRanges() {
        return this.isComplete() && this != UNKNOWN;
    }

    int[] getShards() {
        return this.shards;
    }

    long getMinUnsafe() {
        return this.min;
    }

    long getMaxUnsafe() {
        return this.max;
    }

    public long getMin() {
        assert (this.shards == null) : "min is meaningless if we don't have data from all shards yet";
        assert (this != EMPTY) : "min is meaningless if range is empty";
        assert (this != UNKNOWN) : "min is meaningless if range is unknown";
        return this.min;
    }

    public long getMax() {
        assert (this.shards == null) : "max is meaningless if we don't have data from all shards yet";
        assert (this != EMPTY) : "max is meaningless if range is empty";
        assert (this != UNKNOWN) : "max is meaningless if range is unknown";
        return this.max;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        if (this == NO_SHARDS) {
            out.writeByte((byte)1);
        } else if (this == UNKNOWN) {
            out.writeByte((byte)2);
        } else if (this == EMPTY) {
            out.writeByte((byte)3);
        } else {
            out.writeByte((byte)0);
            if (this.shards == null) {
                out.writeBoolean(false);
            } else {
                out.writeBoolean(true);
                out.writeVIntArray(this.shards);
            }
            out.writeZLong(this.min);
            out.writeZLong(this.max);
        }
    }

    public static IndexLongFieldRange readFrom(StreamInput in) throws IOException {
        byte type = in.readByte();
        switch (type) {
            case 1: {
                return NO_SHARDS;
            }
            case 2: {
                return UNKNOWN;
            }
            case 3: {
                return EMPTY;
            }
            case 0: {
                return new IndexLongFieldRange(in.readBoolean() ? in.readVIntArray() : null, in.readZLong(), in.readZLong());
            }
        }
        throw new IllegalStateException("type [" + type + "] not known");
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        if (this == UNKNOWN) {
            builder.field("unknown", true);
        } else if (this == EMPTY) {
            builder.field("empty", true);
        } else if (this == NO_SHARDS) {
            builder.startArray("shards");
            builder.endArray();
        } else {
            builder.field("min", this.min);
            builder.field("max", this.max);
            if (this.shards != null) {
                builder.startArray("shards");
                for (int shard : this.shards) {
                    builder.value(shard);
                }
                builder.endArray();
            }
        }
        return builder;
    }

    public static IndexLongFieldRange fromXContent(XContentParser parser) throws IOException {
        XContentParser.Token token;
        String currentFieldName = null;
        Boolean isUnknown = null;
        Boolean isEmpty = null;
        Long min = null;
        Long max = null;
        ArrayList<Integer> shardsList = null;
        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            if (token == XContentParser.Token.FIELD_NAME) {
                currentFieldName = parser.currentName();
                continue;
            }
            if (token.isValue()) {
                if ("unknown".equals(currentFieldName)) {
                    if (Boolean.FALSE.equals(isUnknown)) {
                        throw new IllegalArgumentException("unexpected field 'unknown'");
                    }
                    isUnknown = Boolean.TRUE;
                    isEmpty = Boolean.FALSE;
                    continue;
                }
                if ("empty".equals(currentFieldName)) {
                    if (Boolean.FALSE.equals(isEmpty)) {
                        throw new IllegalArgumentException("unexpected field 'empty'");
                    }
                    isUnknown = Boolean.FALSE;
                    isEmpty = Boolean.TRUE;
                    continue;
                }
                if ("min".equals(currentFieldName)) {
                    if (Boolean.TRUE.equals(isUnknown) || Boolean.TRUE.equals(isEmpty)) {
                        throw new IllegalArgumentException("unexpected field 'min'");
                    }
                    isUnknown = Boolean.FALSE;
                    isEmpty = Boolean.FALSE;
                    min = parser.longValue();
                    continue;
                }
                if (!"max".equals(currentFieldName)) continue;
                if (Boolean.TRUE.equals(isUnknown) || Boolean.TRUE.equals(isEmpty)) {
                    throw new IllegalArgumentException("unexpected field 'max'");
                }
                isUnknown = Boolean.FALSE;
                isEmpty = Boolean.FALSE;
                max = parser.longValue();
                continue;
            }
            if (token == XContentParser.Token.START_ARRAY) {
                if ("shards".equals(currentFieldName)) {
                    if (Boolean.TRUE.equals(isUnknown) || Boolean.TRUE.equals(isEmpty) || shardsList != null) {
                        throw new IllegalArgumentException("unexpected array 'shards'");
                    }
                    isUnknown = Boolean.FALSE;
                    isEmpty = Boolean.FALSE;
                    shardsList = new ArrayList<Integer>();
                    while ((token = parser.nextToken()) != XContentParser.Token.END_ARRAY) {
                        if (!token.isValue()) continue;
                        shardsList.add(parser.intValue());
                    }
                    continue;
                }
                throw new IllegalArgumentException("Unexpected array: " + currentFieldName);
            }
            throw new IllegalArgumentException("Unexpected token: " + token);
        }
        if (Boolean.TRUE.equals(isUnknown)) {
            assert (min == null && max == null && shardsList == null && Boolean.FALSE.equals(isEmpty));
            return UNKNOWN;
        }
        if (Boolean.TRUE.equals(isEmpty)) {
            assert (min == null && max == null && shardsList == null && Boolean.FALSE.equals(isUnknown));
            return EMPTY;
        }
        if (shardsList != null && shardsList.isEmpty()) {
            assert (min == null && max == null && Boolean.FALSE.equals(isEmpty) && Boolean.FALSE.equals(isUnknown));
            return NO_SHARDS;
        }
        if (min != null) {
            int[] shards;
            assert (Boolean.FALSE.equals(isUnknown) && Boolean.FALSE.equals(isEmpty));
            if (max == null) {
                throw new IllegalArgumentException("field 'max' unexpectedly missing");
            }
            if (shardsList != null) {
                shards = shardsList.stream().mapToInt(i -> i).toArray();
                assert (shards.length > 0);
            } else {
                shards = null;
            }
            return new IndexLongFieldRange(shards, min, max);
        }
        throw new IllegalArgumentException("field range contents unexpectedly missing");
    }

    public IndexLongFieldRange extendWithShardRange(int shardId, int shardCount, ShardLongFieldRange shardFieldRange) {
        int[] newShards;
        if (shardFieldRange == ShardLongFieldRange.UNKNOWN) {
            assert (this.shards != null ? Arrays.stream(this.shards).noneMatch(i -> i == shardId) : this == UNKNOWN);
            return UNKNOWN;
        }
        if (this.shards == null || Arrays.stream(this.shards).anyMatch(i -> i == shardId)) {
            assert (shardFieldRange == ShardLongFieldRange.EMPTY || this.min <= shardFieldRange.getMin() && shardFieldRange.getMax() <= this.max);
            return this;
        }
        if (this.shards.length == shardCount - 1) {
            assert (Arrays.equals(this.shards, IntStream.range(0, shardCount).filter(i -> i != shardId).toArray())) : Arrays.toString(this.shards) + " + " + shardId;
            if (shardFieldRange == ShardLongFieldRange.EMPTY && this.min == IndexLongFieldRange.EMPTY.min && this.max == IndexLongFieldRange.EMPTY.max) {
                return EMPTY;
            }
            newShards = null;
        } else {
            newShards = IntStream.concat(Arrays.stream(this.shards), IntStream.of(shardId)).sorted().toArray();
        }
        if (shardFieldRange == ShardLongFieldRange.EMPTY) {
            return new IndexLongFieldRange(newShards, this.min, this.max);
        }
        return new IndexLongFieldRange(newShards, Math.min(shardFieldRange.getMin(), this.min), Math.max(shardFieldRange.getMax(), this.max));
    }

    public String toString() {
        if (this == NO_SHARDS) {
            return "NO_SHARDS";
        }
        if (this == UNKNOWN) {
            return "UNKNOWN";
        }
        if (this == EMPTY) {
            return "EMPTY";
        }
        if (this.shards == null) {
            return "[" + this.min + "-" + this.max + "]";
        }
        return "[" + this.min + "-" + this.max + ", shards=" + Arrays.toString(this.shards) + "]";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (this == EMPTY || this == UNKNOWN || this == NO_SHARDS || o == EMPTY || o == UNKNOWN || o == NO_SHARDS) {
            return false;
        }
        IndexLongFieldRange that = (IndexLongFieldRange)o;
        return this.min == that.min && this.max == that.max && Arrays.equals(this.shards, that.shards);
    }

    public int hashCode() {
        int result = Objects.hash(this.min, this.max);
        result = 31 * result + Arrays.hashCode(this.shards);
        return result;
    }

    public IndexLongFieldRange removeShard(int shardId, int numberOfShards) {
        assert (0 <= shardId && shardId < numberOfShards) : shardId + " vs " + numberOfShards;
        if (this.shards != null && Arrays.stream(this.shards).noneMatch(i -> i == shardId)) {
            return this;
        }
        if (this.shards == null && numberOfShards == 1) {
            return NO_SHARDS;
        }
        if (this == UNKNOWN) {
            return this;
        }
        if (this.shards != null && this.shards.length == 1 && this.shards[0] == shardId) {
            return NO_SHARDS;
        }
        IntStream currentShards = this.shards == null ? IntStream.range(0, numberOfShards) : Arrays.stream(this.shards);
        return new IndexLongFieldRange(currentShards.filter(i -> i != shardId).toArray(), this.min, this.max);
    }
}

