/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.rest;

import java.util.Objects;
import org.elasticsearch.client.node.NodeClient;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.logging.DeprecationCategory;
import org.elasticsearch.common.logging.DeprecationLogger;
import org.elasticsearch.rest.RestChannel;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.rest.RestRequest;

public class DeprecationRestHandler
implements RestHandler {
    public static final String DEPRECATED_ROUTE_KEY = "deprecated_route";
    private final RestHandler handler;
    private final String deprecationMessage;
    private final DeprecationLogger deprecationLogger;
    private final boolean compatibleVersionWarning;
    private final String deprecationKey;

    public DeprecationRestHandler(RestHandler handler, RestRequest.Method method, String path, String deprecationMessage, DeprecationLogger deprecationLogger, boolean compatibleVersionWarning) {
        this.handler = Objects.requireNonNull(handler);
        this.deprecationMessage = DeprecationRestHandler.requireValidHeader(deprecationMessage);
        this.deprecationLogger = Objects.requireNonNull(deprecationLogger);
        this.compatibleVersionWarning = compatibleVersionWarning;
        this.deprecationKey = "deprecated_route_" + method + "_" + path;
    }

    @Override
    public void handleRequest(RestRequest request, RestChannel channel, NodeClient client) throws Exception {
        if (!this.compatibleVersionWarning) {
            this.deprecationLogger.critical(DeprecationCategory.API, this.deprecationKey, this.deprecationMessage, new Object[0]);
        } else {
            this.deprecationLogger.compatibleCritical(this.deprecationKey, this.deprecationMessage, new Object[0]);
        }
        this.handler.handleRequest(request, channel, client);
    }

    @Override
    public boolean supportsContentStream() {
        return this.handler.supportsContentStream();
    }

    public static boolean validHeaderValue(String value) {
        if (!Strings.hasText(value)) {
            return false;
        }
        for (int i = 0; i < value.length(); ++i) {
            char c = value.charAt(i);
            if (c >= ' ' && c <= '~') continue;
            return false;
        }
        return true;
    }

    public static String requireValidHeader(String value) {
        if (!DeprecationRestHandler.validHeaderValue(value)) {
            throw new IllegalArgumentException("header value must contain only US ASCII text");
        }
        return value;
    }
}

