/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.rest.action.admin.indices;

import java.io.IOException;
import java.util.List;
import java.util.Locale;
import org.elasticsearch.client.node.NodeClient;
import org.elasticsearch.core.RestApiVersion;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.BytesRestResponse;
import org.elasticsearch.rest.RestChannel;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.rest.RestRequest;

public class RestUpgradeActionDeprecated
extends BaseRestHandler {
    public static final String UPGRADE_API_DEPRECATION_MESSAGE = "The _upgrade API is no longer useful and will be removed. Instead, see _reindex API.";

    @Override
    public List<RestHandler.Route> routes() {
        return List.of(RestHandler.Route.builder(RestRequest.Method.POST, "/_upgrade").deprecated(UPGRADE_API_DEPRECATION_MESSAGE, RestApiVersion.V_7).build(), RestHandler.Route.builder(RestRequest.Method.POST, "/{index}/_upgrade").deprecated(UPGRADE_API_DEPRECATION_MESSAGE, RestApiVersion.V_7).build(), RestHandler.Route.builder(RestRequest.Method.GET, "/_upgrade").deprecated(UPGRADE_API_DEPRECATION_MESSAGE, RestApiVersion.V_7).build(), RestHandler.Route.builder(RestRequest.Method.GET, "/{index}/_upgrade").deprecated(UPGRADE_API_DEPRECATION_MESSAGE, RestApiVersion.V_7).build());
    }

    @Override
    public String getName() {
        return "upgrade_action";
    }

    @Override
    public BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) throws IOException {
        request.param("index");
        UpgradeActionDeprecatedException exception = new UpgradeActionDeprecatedException(request);
        return channel -> channel.sendResponse(new BytesRestResponse((RestChannel)channel, exception));
    }

    public static class UpgradeActionDeprecatedException
    extends IllegalArgumentException {
        private final String path;
        private final RestRequest.Method method;

        public UpgradeActionDeprecatedException(RestRequest restRequest) {
            this.path = restRequest.path();
            this.method = restRequest.method();
        }

        @Override
        public final String getMessage() {
            return String.format(Locale.ROOT, "Upgrade action %s %s was removed, use _reindex API instead", new Object[]{this.method, this.path});
        }
    }
}

