/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.rest.action.datastreams;

import java.io.IOException;
import java.util.List;
import org.elasticsearch.action.datastreams.ModifyDataStreamsAction;
import org.elasticsearch.client.node.NodeClient;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.RestChannel;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.action.RestToXContentListener;
import org.elasticsearch.xcontent.XContentParser;

public class RestModifyDataStreamsAction
extends BaseRestHandler {
    @Override
    public String getName() {
        return "modify_data_stream_action";
    }

    @Override
    public List<RestHandler.Route> routes() {
        return List.of(new RestHandler.Route(RestRequest.Method.POST, "/_data_stream/_modify"));
    }

    @Override
    protected BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) throws IOException {
        ModifyDataStreamsAction.Request modifyDsRequest;
        try (XContentParser parser = request.contentParser();){
            modifyDsRequest = ModifyDataStreamsAction.Request.PARSER.parse(parser, null);
        }
        if (modifyDsRequest.getActions() == null || modifyDsRequest.getActions().isEmpty()) {
            throw new IllegalArgumentException("no data stream actions specified, at least one must be specified");
        }
        modifyDsRequest.masterNodeTimeout(request.paramAsTime("master_timeout", modifyDsRequest.masterNodeTimeout()));
        modifyDsRequest.timeout(request.paramAsTime("timeout", modifyDsRequest.timeout()));
        return channel -> client.execute(ModifyDataStreamsAction.INSTANCE, modifyDsRequest, new RestToXContentListener((RestChannel)channel));
    }
}

