/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.bucket.filter;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.IntPredicate;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.search.LeafCollector;
import org.apache.lucene.search.Scorable;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.core.CheckedFunction;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.search.aggregations.Aggregator;
import org.elasticsearch.search.aggregations.AggregatorFactories;
import org.elasticsearch.search.aggregations.CardinalityUpperBound;
import org.elasticsearch.search.aggregations.InternalAggregation;
import org.elasticsearch.search.aggregations.InternalAggregations;
import org.elasticsearch.search.aggregations.LeafBucketCollector;
import org.elasticsearch.search.aggregations.LeafBucketCollectorBase;
import org.elasticsearch.search.aggregations.bucket.BucketsAggregator;
import org.elasticsearch.search.aggregations.bucket.DocCountProvider;
import org.elasticsearch.search.aggregations.bucket.filter.FilterByFilterAggregator;
import org.elasticsearch.search.aggregations.bucket.filter.InternalFilters;
import org.elasticsearch.search.aggregations.bucket.filter.QueryToFilterAdapter;
import org.elasticsearch.search.aggregations.support.AggregationContext;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentFragment;
import org.elasticsearch.xcontent.XContentBuilder;

public abstract class FiltersAggregator
extends BucketsAggregator {
    public static final ParseField FILTERS_FIELD = new ParseField("filters", new String[0]);
    public static final ParseField OTHER_BUCKET_FIELD = new ParseField("other_bucket", new String[0]);
    public static final ParseField OTHER_BUCKET_KEY_FIELD = new ParseField("other_bucket_key", new String[0]);
    private final List<QueryToFilterAdapter<?>> filters;
    private final boolean keyed;
    protected final String otherBucketKey;

    public static FiltersAggregator build(String name, final AggregatorFactories factories, List<QueryToFilterAdapter<?>> filters, boolean keyed, String otherBucketKey, AggregationContext context, Aggregator parent, CardinalityUpperBound cardinality, Map<String, Object> metadata) throws IOException {
        FilterByFilterAggregator.AdapterBuilder<FilterByFilterAggregator> filterByFilterBuilder = new FilterByFilterAggregator.AdapterBuilder<FilterByFilterAggregator>(name, keyed, otherBucketKey, context, parent, cardinality, metadata){

            @Override
            protected FilterByFilterAggregator adapt(CheckedFunction<AggregatorFactories, FilterByFilterAggregator, IOException> delegate) throws IOException {
                return delegate.apply(factories);
            }
        };
        for (QueryToFilterAdapter<?> f : filters) {
            filterByFilterBuilder.add(f);
        }
        FilterByFilterAggregator filterByFilter = (FilterByFilterAggregator)filterByFilterBuilder.build();
        if (filterByFilter != null) {
            return filterByFilter;
        }
        return new Compatible(name, factories, filters, keyed, otherBucketKey, context, parent, cardinality, metadata);
    }

    FiltersAggregator(String name, AggregatorFactories factories, List<QueryToFilterAdapter<?>> filters, boolean keyed, String otherBucketKey, AggregationContext context, Aggregator parent, CardinalityUpperBound cardinality, Map<String, Object> metadata) throws IOException {
        super(name, factories, context, parent, cardinality.multiply(filters.size() + (otherBucketKey == null ? 0 : 1)), metadata);
        this.filters = List.copyOf(filters);
        this.keyed = keyed;
        this.otherBucketKey = otherBucketKey;
    }

    List<QueryToFilterAdapter<?>> filters() {
        return this.filters;
    }

    @Override
    public InternalAggregation[] buildAggregations(long[] owningBucketOrds) throws IOException {
        return this.buildAggregationsForFixedBucketCount(owningBucketOrds, this.filters.size() + (this.otherBucketKey == null ? 0 : 1), (offsetInOwningOrd, docCount, subAggregationResults) -> {
            if (offsetInOwningOrd < this.filters.size()) {
                return new InternalFilters.InternalBucket(this.filters.get(offsetInOwningOrd).key().toString(), docCount, subAggregationResults, this.keyed);
            }
            return new InternalFilters.InternalBucket(this.otherBucketKey, docCount, subAggregationResults, this.keyed);
        }, buckets -> new InternalFilters(this.name, (List<InternalFilters.InternalBucket>)buckets, this.keyed, this.metadata()));
    }

    @Override
    public InternalAggregation buildEmptyAggregation() {
        InternalAggregations subAggs = this.buildEmptySubAggregations();
        ArrayList<InternalFilters.InternalBucket> buckets = new ArrayList<InternalFilters.InternalBucket>(this.filters.size() + (this.otherBucketKey == null ? 0 : 1));
        for (QueryToFilterAdapter<?> filter : this.filters) {
            InternalFilters.InternalBucket bucket = new InternalFilters.InternalBucket(filter.key().toString(), 0L, subAggs, this.keyed);
            buckets.add(bucket);
        }
        if (this.otherBucketKey != null) {
            InternalFilters.InternalBucket bucket = new InternalFilters.InternalBucket(this.otherBucketKey, 0L, subAggs, this.keyed);
            buckets.add(bucket);
        }
        return new InternalFilters(this.name, buckets, this.keyed, this.metadata());
    }

    @Override
    public void collectDebugInfo(BiConsumer<String, Object> add) {
        super.collectDebugInfo(add);
        ArrayList filtersDebug = new ArrayList(this.filters.size());
        for (QueryToFilterAdapter<?> filter : this.filters) {
            HashMap debug = new HashMap();
            filter.collectDebugInfo(debug::put);
            filtersDebug.add(debug);
        }
        add.accept("filters", filtersDebug);
    }

    static class Compatible
    extends FiltersAggregator {
        private final int totalNumKeys;

        Compatible(String name, AggregatorFactories factories, List<QueryToFilterAdapter<?>> filters, boolean keyed, String otherBucketKey, AggregationContext context, Aggregator parent, CardinalityUpperBound cardinality, Map<String, Object> metadata) throws IOException {
            super(name, factories, filters, keyed, otherBucketKey, context, parent, cardinality, metadata);
            this.totalNumKeys = otherBucketKey == null ? filters.size() : filters.size() + 1;
        }

        @Override
        protected LeafBucketCollector getLeafCollector(LeafReaderContext ctx, final LeafBucketCollector sub) throws IOException {
            final IntPredicate[] docFilters = new IntPredicate[this.filters().size()];
            for (int filterOrd = 0; filterOrd < this.filters().size(); ++filterOrd) {
                docFilters[filterOrd] = this.filters().get(filterOrd).matchingDocIds(ctx);
            }
            return new LeafBucketCollectorBase(sub, null){

                @Override
                public void collect(int doc, long bucket) throws IOException {
                    boolean matched = false;
                    for (int i = 0; i < docFilters.length; ++i) {
                        if (!docFilters[i].test(doc)) continue;
                        this.collectBucket(sub, doc, this.bucketOrd(bucket, i));
                        matched = true;
                    }
                    if (otherBucketKey != null && !matched) {
                        this.collectBucket(sub, doc, this.bucketOrd(bucket, docFilters.length));
                    }
                }
            };
        }

        final long bucketOrd(long owningBucketOrdinal, int filterOrd) {
            return owningBucketOrdinal * (long)this.totalNumKeys + (long)filterOrd;
        }
    }

    static class Counter
    implements LeafCollector {
        final DocCountProvider docCount;
        private long count;

        Counter(DocCountProvider docCount) {
            this.docCount = docCount;
        }

        public long readAndReset(LeafReaderContext ctx) throws IOException {
            long result = this.count;
            this.count = 0L;
            this.docCount.setLeafReaderContext(ctx);
            return result;
        }

        @Override
        public void collect(int doc) throws IOException {
            this.count += (long)this.docCount.getDocCount(doc);
        }

        @Override
        public void setScorer(Scorable scorer) throws IOException {
        }
    }

    public static class KeyedFilter
    implements Writeable,
    ToXContentFragment {
        private final String key;
        private final QueryBuilder filter;

        public KeyedFilter(String key, QueryBuilder filter) {
            if (key == null) {
                throw new IllegalArgumentException("[key] must not be null");
            }
            if (filter == null) {
                throw new IllegalArgumentException("[filter] must not be null");
            }
            this.key = key;
            this.filter = filter;
        }

        public KeyedFilter(StreamInput in) throws IOException {
            this.key = in.readString();
            this.filter = in.readNamedWriteable(QueryBuilder.class);
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeString(this.key);
            out.writeNamedWriteable(this.filter);
        }

        public String key() {
            return this.key;
        }

        public QueryBuilder filter() {
            return this.filter;
        }

        @Override
        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.field(this.key, this.filter);
            return builder;
        }

        public int hashCode() {
            return Objects.hash(this.key, this.filter);
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            KeyedFilter other = (KeyedFilter)obj;
            return Objects.equals(this.key, other.key) && Objects.equals(this.filter, other.filter);
        }
    }
}

