/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.fetch.subphase.highlight;

import java.io.IOException;
import java.text.BreakIterator;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.search.highlight.Encoder;
import org.apache.lucene.search.uhighlight.CustomSeparatorBreakIterator;
import org.apache.lucene.search.uhighlight.PassageFormatter;
import org.apache.lucene.search.uhighlight.UnifiedHighlighter;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.CollectionUtil;
import org.elasticsearch.common.CheckedSupplier;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.lucene.Lucene;
import org.elasticsearch.common.text.Text;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.index.mapper.TextSearchInfo;
import org.elasticsearch.index.query.SearchExecutionContext;
import org.elasticsearch.lucene.search.uhighlight.BoundedBreakIteratorScanner;
import org.elasticsearch.lucene.search.uhighlight.CustomPassageFormatter;
import org.elasticsearch.lucene.search.uhighlight.CustomUnifiedHighlighter;
import org.elasticsearch.lucene.search.uhighlight.Snippet;
import org.elasticsearch.search.fetch.FetchSubPhase;
import org.elasticsearch.search.fetch.subphase.highlight.FieldHighlightContext;
import org.elasticsearch.search.fetch.subphase.highlight.HighlightBuilder;
import org.elasticsearch.search.fetch.subphase.highlight.HighlightField;
import org.elasticsearch.search.fetch.subphase.highlight.HighlightUtils;
import org.elasticsearch.search.fetch.subphase.highlight.Highlighter;
import org.elasticsearch.search.fetch.subphase.highlight.LimitTokenOffsetAnalyzer;
import org.elasticsearch.search.fetch.subphase.highlight.SearchHighlightContext;
import org.elasticsearch.search.internal.ContextIndexSearcher;

public class UnifiedHighlighter
implements Highlighter {
    @Override
    public boolean canHighlight(MappedFieldType fieldType) {
        return true;
    }

    @Override
    public HighlightField highlight(FieldHighlightContext fieldContext) throws IOException {
        Map cache = (Map)fieldContext.cache.computeIfAbsent(UnifiedHighlighter.class.getName(), k -> new HashMap());
        if (!cache.containsKey(fieldContext.fieldName)) {
            cache.put(fieldContext.fieldName, this.buildHighlighter(fieldContext));
        }
        CustomUnifiedHighlighter highlighter = (CustomUnifiedHighlighter)((Object)cache.get(fieldContext.fieldName));
        MappedFieldType fieldType = fieldContext.fieldType;
        SearchHighlightContext.Field field = fieldContext.field;
        FetchSubPhase.HitContext hitContext = fieldContext.hitContext;
        CheckedSupplier<String, IOException> loadFieldValues = () -> {
            List<Object> fieldValues = this.loadFieldValues(highlighter, fieldContext.context.getSearchExecutionContext(), fieldType, hitContext, fieldContext.forceSource);
            if (fieldValues.size() == 0) {
                return null;
            }
            return UnifiedHighlighter.mergeFieldValues(fieldValues, '\u0000');
        };
        Snippet[] fieldSnippets = highlighter.highlightField(hitContext.reader(), hitContext.docId(), loadFieldValues);
        if (fieldSnippets == null || fieldSnippets.length == 0) {
            return null;
        }
        ArrayList<Snippet> snippets = new ArrayList<Snippet>(fieldSnippets.length);
        for (Snippet fieldSnippet : fieldSnippets) {
            if (!Strings.hasText(fieldSnippet.getText())) continue;
            snippets.add(fieldSnippet);
        }
        if (snippets.isEmpty()) {
            return null;
        }
        if (field.fieldOptions().scoreOrdered().booleanValue()) {
            CollectionUtil.introSort(snippets, (o1, o2) -> Double.compare(o2.getScore(), o1.getScore()));
        }
        String[] fragments = new String[snippets.size()];
        for (int i = 0; i < fragments.length; ++i) {
            fragments[i] = ((Snippet)snippets.get(i)).getText();
        }
        return new HighlightField(fieldContext.fieldName, Text.convertFromStringArray(fragments));
    }

    CustomUnifiedHighlighter buildHighlighter(FieldHighlightContext fieldContext) throws IOException {
        int higlighterNumberOfFragments;
        Object breakIterator;
        Encoder encoder = fieldContext.field.fieldOptions().encoder().equals("html") ? HighlightUtils.Encoders.HTML : HighlightUtils.Encoders.DEFAULT;
        int maxAnalyzedOffset = fieldContext.context.getSearchExecutionContext().getIndexSettings().getHighlightMaxAnalyzedOffset();
        int numberOfFragments = fieldContext.field.fieldOptions().numberOfFragments();
        Integer queryMaxAnalyzedOffset = fieldContext.field.fieldOptions().maxAnalyzedOffset();
        Analyzer analyzer = this.wrapAnalyzer(fieldContext.context.getSearchExecutionContext().getIndexAnalyzer(f -> Lucene.KEYWORD_ANALYZER), queryMaxAnalyzedOffset);
        PassageFormatter passageFormatter = this.getPassageFormatter(fieldContext.hitContext, fieldContext.field, encoder);
        ContextIndexSearcher searcher = fieldContext.context.searcher();
        UnifiedHighlighter.OffsetSource offsetSource = this.getOffsetSource(fieldContext.fieldType);
        if (numberOfFragments == 0 || !fieldContext.fieldType.getTextSearchInfo().isTokenized()) {
            breakIterator = new CustomSeparatorBreakIterator('\u0000');
            higlighterNumberOfFragments = numberOfFragments == 0 ? 0x7FFFFFFE : numberOfFragments;
        } else {
            breakIterator = this.getBreakIterator(fieldContext.field);
            higlighterNumberOfFragments = numberOfFragments;
        }
        return new CustomUnifiedHighlighter(searcher, analyzer, offsetSource, passageFormatter, fieldContext.field.fieldOptions().boundaryScannerLocale(), (BreakIterator)breakIterator, fieldContext.context.getIndexName(), fieldContext.fieldName, fieldContext.query, fieldContext.field.fieldOptions().noMatchSize(), higlighterNumberOfFragments, this.fieldMatcher(fieldContext), maxAnalyzedOffset, fieldContext.field.fieldOptions().maxAnalyzedOffset());
    }

    protected PassageFormatter getPassageFormatter(FetchSubPhase.HitContext hitContext, SearchHighlightContext.Field field, Encoder encoder) {
        return new CustomPassageFormatter(field.fieldOptions().preTags()[0], field.fieldOptions().postTags()[0], encoder);
    }

    protected Analyzer wrapAnalyzer(Analyzer analyzer, Integer maxAnalyzedOffset) {
        if (maxAnalyzedOffset != null) {
            analyzer = new LimitTokenOffsetAnalyzer(analyzer, maxAnalyzedOffset);
        }
        return analyzer;
    }

    protected List<Object> loadFieldValues(CustomUnifiedHighlighter highlighter, SearchExecutionContext searchContext, MappedFieldType fieldType, FetchSubPhase.HitContext hitContext, boolean forceSource) throws IOException {
        List<Object> fieldValues = HighlightUtils.loadFieldValues(fieldType, searchContext, hitContext, forceSource);
        fieldValues = fieldValues.stream().map(s -> UnifiedHighlighter.convertFieldValue(fieldType, s)).collect(Collectors.toList());
        return fieldValues;
    }

    protected BreakIterator getBreakIterator(SearchHighlightContext.Field field) {
        SearchHighlightContext.FieldOptions fieldOptions = field.fieldOptions();
        Locale locale = fieldOptions.boundaryScannerLocale() != null ? fieldOptions.boundaryScannerLocale() : Locale.ROOT;
        HighlightBuilder.BoundaryScannerType type = fieldOptions.boundaryScannerType() != null ? fieldOptions.boundaryScannerType() : HighlightBuilder.BoundaryScannerType.SENTENCE;
        int maxLen = fieldOptions.fragmentCharSize();
        switch (type) {
            case SENTENCE: {
                if (maxLen > 0) {
                    return BoundedBreakIteratorScanner.getSentence(locale, maxLen);
                }
                return BreakIterator.getSentenceInstance(locale);
            }
            case WORD: {
                return BreakIterator.getWordInstance(locale);
            }
        }
        throw new IllegalArgumentException("Invalid boundary scanner type: " + type.toString());
    }

    protected static String convertFieldValue(MappedFieldType type, Object value) {
        if (value instanceof BytesRef) {
            return type.valueForDisplay(value).toString();
        }
        return value.toString();
    }

    protected static String mergeFieldValues(List<Object> fieldValues, char valuesSeparator) {
        String rawValue = Strings.collectionToDelimitedString(fieldValues, String.valueOf(valuesSeparator));
        return rawValue.substring(0, Math.min(rawValue.length(), 0x7FFFFFFE));
    }

    protected UnifiedHighlighter.OffsetSource getOffsetSource(MappedFieldType fieldType) {
        TextSearchInfo tsi = fieldType.getTextSearchInfo();
        if (tsi.hasOffsets()) {
            return tsi.termVectors() != TextSearchInfo.TermVector.NONE ? UnifiedHighlighter.OffsetSource.POSTINGS_WITH_TERM_VECTORS : UnifiedHighlighter.OffsetSource.POSTINGS;
        }
        if (tsi.termVectors() == TextSearchInfo.TermVector.OFFSETS) {
            return UnifiedHighlighter.OffsetSource.TERM_VECTORS;
        }
        return UnifiedHighlighter.OffsetSource.ANALYSIS;
    }

    private Predicate<String> fieldMatcher(FieldHighlightContext fieldContext) {
        if (fieldContext.field.fieldOptions().requireFieldMatch().booleanValue()) {
            String fieldName = fieldContext.fieldName;
            return fieldName::equals;
        }
        return name -> !"_id".equals(name);
    }
}

