/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.common.notifications;

import java.io.IOException;
import java.util.Date;
import java.util.Objects;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Supplier;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.ElasticsearchParseException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.admin.indices.template.put.PutComposableIndexTemplateAction;
import org.elasticsearch.action.bulk.BulkRequest;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.index.IndexResponse;
import org.elasticsearch.client.OriginSettingClient;
import org.elasticsearch.cluster.metadata.ComposableIndexTemplate;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.xcontent.DeprecationHandler;
import org.elasticsearch.xcontent.NamedXContentRegistry;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentFactory;
import org.elasticsearch.xcontent.json.JsonXContent;
import org.elasticsearch.xpack.core.common.notifications.AbstractAuditMessage;
import org.elasticsearch.xpack.core.common.notifications.AbstractAuditMessageFactory;
import org.elasticsearch.xpack.core.common.notifications.Level;
import org.elasticsearch.xpack.core.ml.utils.MlIndexAndAlias;
import org.elasticsearch.xpack.core.template.IndexTemplateConfig;

public abstract class AbstractAuditor<T extends AbstractAuditMessage> {
    public static final String All_RESOURCES_ID = "";
    private static final Logger logger = LogManager.getLogger(AbstractAuditor.class);
    static final int MAX_BUFFER_SIZE = 1000;
    static final TimeValue MASTER_TIMEOUT = TimeValue.timeValueMinutes(1L);
    private final OriginSettingClient client;
    private final String nodeName;
    private final String auditIndex;
    private final String templateName;
    private final Supplier<PutComposableIndexTemplateAction.Request> templateSupplier;
    private final AbstractAuditMessageFactory<T> messageFactory;
    private final AtomicBoolean hasLatestTemplate;
    private Queue<ToXContent> backlog;
    private final ClusterService clusterService;
    private final AtomicBoolean putTemplateInProgress;

    protected AbstractAuditor(OriginSettingClient client, String auditIndex, IndexTemplateConfig templateConfig, String nodeName, AbstractAuditMessageFactory<T> messageFactory, ClusterService clusterService) {
        this(client, auditIndex, templateConfig.getTemplateName(), () -> {
            try {
                return (PutComposableIndexTemplateAction.Request)new PutComposableIndexTemplateAction.Request(templateConfig.getTemplateName()).indexTemplate(ComposableIndexTemplate.parse(JsonXContent.jsonXContent.createParser(NamedXContentRegistry.EMPTY, DeprecationHandler.THROW_UNSUPPORTED_OPERATION, templateConfig.loadBytes()))).masterNodeTimeout(MASTER_TIMEOUT);
            }
            catch (IOException e) {
                throw new ElasticsearchParseException("unable to parse composable template " + templateConfig.getTemplateName(), (Throwable)e, new Object[0]);
            }
        }, nodeName, messageFactory, clusterService);
    }

    protected AbstractAuditor(OriginSettingClient client, String auditIndex, String templateName, Supplier<PutComposableIndexTemplateAction.Request> templateSupplier, String nodeName, AbstractAuditMessageFactory<T> messageFactory, ClusterService clusterService) {
        this.client = Objects.requireNonNull(client);
        this.auditIndex = Objects.requireNonNull(auditIndex);
        this.templateName = Objects.requireNonNull(templateName);
        this.templateSupplier = Objects.requireNonNull(templateSupplier);
        this.messageFactory = Objects.requireNonNull(messageFactory);
        this.clusterService = Objects.requireNonNull(clusterService);
        this.nodeName = Objects.requireNonNull(nodeName);
        this.backlog = new ConcurrentLinkedQueue<ToXContent>();
        this.hasLatestTemplate = new AtomicBoolean();
        this.putTemplateInProgress = new AtomicBoolean();
    }

    public void info(String resourceId, String message) {
        this.indexDoc((ToXContent)this.messageFactory.newMessage(resourceId, message, Level.INFO, new Date(), this.nodeName));
    }

    public void warning(String resourceId, String message) {
        this.indexDoc((ToXContent)this.messageFactory.newMessage(resourceId, message, Level.WARNING, new Date(), this.nodeName));
    }

    public void error(String resourceId, String message) {
        this.indexDoc((ToXContent)this.messageFactory.newMessage(resourceId, message, Level.ERROR, new Date(), this.nodeName));
    }

    private void onIndexResponse(IndexResponse response) {
        logger.trace("Successfully wrote audit message");
    }

    private void onIndexFailure(Exception exception) {
        logger.debug("Failed to write audit message", (Throwable)exception);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void indexDoc(ToXContent toXContent) {
        if (this.hasLatestTemplate.get()) {
            this.writeDoc(toXContent);
            return;
        }
        if (MlIndexAndAlias.hasIndexTemplate(this.clusterService.state(), this.templateName)) {
            AbstractAuditor abstractAuditor = this;
            synchronized (abstractAuditor) {
                this.hasLatestTemplate.set(true);
            }
            this.writeDoc(toXContent);
            return;
        }
        ActionListener<Boolean> putTemplateListener = ActionListener.wrap(r -> {
            AbstractAuditor abstractAuditor = this;
            synchronized (abstractAuditor) {
                this.hasLatestTemplate.set(true);
            }
            logger.info("Auditor template [{}] successfully installed", (Object)this.templateName);
            this.writeBacklog();
            this.putTemplateInProgress.set(false);
        }, e -> {
            logger.warn("Error putting latest template [{}]", (Object)this.templateName);
            this.putTemplateInProgress.set(false);
        });
        AbstractAuditor abstractAuditor = this;
        synchronized (abstractAuditor) {
            if (!this.hasLatestTemplate.get()) {
                assert (this.backlog != null);
                if (this.backlog != null) {
                    if (this.backlog.size() >= 1000) {
                        this.backlog.remove();
                    }
                    this.backlog.add(toXContent);
                } else {
                    logger.error("Latest audit template missing but the back log has been written");
                }
                if (this.putTemplateInProgress.compareAndSet(false, true)) {
                    MlIndexAndAlias.installIndexTemplateIfRequired(this.clusterService.state(), this.client, this.templateSupplier.get(), putTemplateListener);
                }
                return;
            }
        }
        this.indexDoc(toXContent);
    }

    private void writeDoc(ToXContent toXContent) {
        this.client.index(this.indexRequest(toXContent), ActionListener.wrap(this::onIndexResponse, this::onIndexFailure));
    }

    private IndexRequest indexRequest(ToXContent toXContent) {
        IndexRequest indexRequest = new IndexRequest(this.auditIndex);
        indexRequest.source(this.toXContentBuilder(toXContent));
        indexRequest.timeout(TimeValue.timeValueSeconds(5L));
        return indexRequest;
    }

    private XContentBuilder toXContentBuilder(ToXContent toXContent) {
        XContentBuilder jsonBuilder = XContentFactory.jsonBuilder();
        try {
            XContentBuilder xContentBuilder = toXContent.toXContent(jsonBuilder, ToXContent.EMPTY_PARAMS);
            if (jsonBuilder != null) {
                jsonBuilder.close();
            }
            return xContentBuilder;
        }
        catch (Throwable throwable) {
            try {
                if (jsonBuilder != null) {
                    try {
                        jsonBuilder.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    protected void clearBacklog() {
        this.backlog = null;
    }

    protected void writeBacklog() {
        assert (this.backlog != null);
        if (this.backlog == null) {
            logger.error("Message back log has already been written");
            return;
        }
        BulkRequest bulkRequest = new BulkRequest();
        ToXContent doc = this.backlog.poll();
        while (doc != null) {
            bulkRequest.add(this.indexRequest(doc));
            doc = this.backlog.poll();
        }
        this.client.bulk(bulkRequest, ActionListener.wrap(bulkItemResponses -> {
            if (bulkItemResponses.hasFailures()) {
                logger.warn("Failures bulk indexing the message back log: {}", (Object)bulkItemResponses.buildFailureMessage());
            } else {
                logger.trace("Successfully wrote audit message backlog after upgrading template");
            }
            this.backlog = null;
        }, this::onIndexFailure));
    }

    int backLogSize() {
        return this.backlog.size();
    }
}

