/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.index.query;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.apache.lucene.search.Query;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.regex.Regex;
import org.elasticsearch.index.query.AbstractQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.SearchExecutionContext;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;

public class PinnedQueryBuilder
extends AbstractQueryBuilder<PinnedQueryBuilder> {
    public static final String NAME = "pinned";
    protected final QueryBuilder organicQuery;
    protected final List<String> ids;
    private final List<Item> docs;
    protected static final ParseField IDS_FIELD = new ParseField("ids", new String[0]);
    private static final ParseField DOCS_FIELD = new ParseField("docs", new String[0]);
    protected static final ParseField ORGANIC_QUERY_FIELD = new ParseField("organic", new String[0]);

    @Override
    public String getWriteableName() {
        return NAME;
    }

    public PinnedQueryBuilder(QueryBuilder organicQuery, String ... ids) {
        this(organicQuery, Arrays.asList(ids), null);
    }

    public PinnedQueryBuilder(QueryBuilder organicQuery, Item ... docs) {
        this(organicQuery, null, Arrays.asList(docs));
    }

    private PinnedQueryBuilder(QueryBuilder organicQuery, List<String> ids, List<Item> docs) {
        if (organicQuery == null) {
            throw new IllegalArgumentException("[pinned] organicQuery cannot be null");
        }
        this.organicQuery = organicQuery;
        if (ids == null && docs == null) {
            throw new IllegalArgumentException("[pinned] ids and docs cannot both be null");
        }
        if (ids != null && docs != null) {
            throw new IllegalArgumentException("[pinned] ids and docs cannot both be used");
        }
        this.ids = ids;
        this.docs = docs;
    }

    @Override
    protected void doWriteTo(StreamOutput out) throws IOException {
        out.writeOptionalStringCollection(this.ids);
        if (this.docs == null) {
            out.writeBoolean(false);
        } else {
            out.writeBoolean(true);
            out.writeList(this.docs);
        }
        out.writeNamedWriteable(this.organicQuery);
    }

    public QueryBuilder organicQuery() {
        return this.organicQuery;
    }

    public List<String> ids() {
        if (this.ids == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(this.ids);
    }

    public List<Item> docs() {
        if (this.docs == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(this.docs);
    }

    @Override
    protected void doXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject(NAME);
        if (this.organicQuery != null) {
            builder.field(ORGANIC_QUERY_FIELD.getPreferredName());
            this.organicQuery.toXContent(builder, params);
        }
        if (this.ids != null) {
            builder.startArray(IDS_FIELD.getPreferredName());
            for (String value : this.ids) {
                builder.value(value);
            }
            builder.endArray();
        }
        if (this.docs != null) {
            builder.startArray(DOCS_FIELD.getPreferredName());
            for (Item item : this.docs) {
                builder.value((Object)item);
            }
            builder.endArray();
        }
        this.printBoostAndQueryName(builder);
        builder.endObject();
    }

    @Override
    protected Query doToQuery(SearchExecutionContext context) throws IOException {
        throw new UnsupportedOperationException("Client side-only class for use in HLRC");
    }

    @Override
    protected int doHashCode() {
        return Objects.hash(this.ids, this.docs, this.organicQuery);
    }

    @Override
    protected boolean doEquals(PinnedQueryBuilder other) {
        return Objects.equals(this.ids, other.ids) && Objects.equals(this.docs, other.docs) && Objects.equals(this.organicQuery, other.organicQuery) && this.boost == other.boost;
    }

    public static final class Item
    implements ToXContentObject,
    Writeable {
        private static final ParseField INDEX_FIELD = new ParseField("_index", new String[0]);
        private static final ParseField ID_FIELD = new ParseField("_id", new String[0]);
        private final String index;
        private final String id;

        public Item(String index, String id) {
            if (index == null) {
                throw new IllegalArgumentException("Item requires index to be non-null");
            }
            if (Regex.isSimpleMatchPattern(index)) {
                throw new IllegalArgumentException("Item index cannot contain wildcard expressions");
            }
            if (id == null) {
                throw new IllegalArgumentException("Item requires id to be non-null");
            }
            this.index = index;
            this.id = id;
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeString(this.index);
            out.writeString(this.id);
        }

        @Override
        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            builder.field(INDEX_FIELD.getPreferredName(), this.index);
            builder.field(ID_FIELD.getPreferredName(), this.id);
            return builder.endObject();
        }
    }
}

