/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ml.action;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.xcontent.ObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xcontent.XContentType;
import org.elasticsearch.xpack.core.ml.datafeed.DatafeedConfig;
import org.elasticsearch.xpack.core.ml.job.config.Job;
import org.elasticsearch.xpack.core.ml.utils.ExceptionsHelper;

public class PreviewDatafeedAction
extends ActionType<Response> {
    public static final PreviewDatafeedAction INSTANCE = new PreviewDatafeedAction();
    public static final String NAME = "cluster:admin/xpack/ml/datafeeds/preview";

    private PreviewDatafeedAction() {
        super(NAME, Response::new);
    }

    public static class Response
    extends ActionResponse
    implements ToXContentObject {
        private final BytesReference preview;

        public Response(StreamInput in) throws IOException {
            super(in);
            this.preview = in.readBytesReference();
        }

        public Response(BytesReference preview) {
            this.preview = preview;
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeBytesReference(this.preview);
        }

        @Override
        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            try (StreamInput stream = this.preview.streamInput();){
                builder.rawValue(stream, XContentType.JSON);
            }
            return builder;
        }

        public int hashCode() {
            return Objects.hash(this.preview);
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Response other = (Response)obj;
            return Objects.equals(this.preview, other.preview);
        }

        public final String toString() {
            return Strings.toString(this);
        }
    }

    public static class Request
    extends ActionRequest
    implements ToXContentObject {
        private static final String BLANK_ID = "";
        public static final ParseField DATAFEED_CONFIG = new ParseField("datafeed_config", new String[0]);
        public static final ParseField JOB_CONFIG = new ParseField("job_config", new String[0]);
        private static final ObjectParser<Builder, Void> PARSER = new ObjectParser("preview_datafeed_action", Builder::new);
        private final String datafeedId;
        private final DatafeedConfig datafeedConfig;
        private final Job.Builder jobConfig;

        public static Request fromXContent(XContentParser parser, @Nullable String datafeedId) {
            Builder builder = PARSER.apply(parser, null);
            if (datafeedId != null) {
                builder.setDatafeedId(datafeedId);
            }
            return builder.build();
        }

        public Request(StreamInput in) throws IOException {
            super(in);
            this.datafeedId = in.readString();
            this.datafeedConfig = in.readOptionalWriteable(DatafeedConfig::new);
            this.jobConfig = in.readOptionalWriteable(Job.Builder::new);
        }

        public Request(String datafeedId) {
            this.datafeedId = ExceptionsHelper.requireNonNull(datafeedId, DatafeedConfig.ID);
            this.datafeedConfig = null;
            this.jobConfig = null;
        }

        public Request(DatafeedConfig datafeedConfig, Job.Builder jobConfig) {
            this.datafeedId = BLANK_ID;
            this.datafeedConfig = ExceptionsHelper.requireNonNull(datafeedConfig, DATAFEED_CONFIG.getPreferredName());
            this.jobConfig = jobConfig;
        }

        public String getDatafeedId() {
            return this.datafeedId;
        }

        public DatafeedConfig getDatafeedConfig() {
            return this.datafeedConfig;
        }

        public Job.Builder getJobConfig() {
            return this.jobConfig;
        }

        @Override
        public ActionRequestValidationException validate() {
            return null;
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            out.writeString(this.datafeedId);
            out.writeOptionalWriteable(this.datafeedConfig);
            out.writeOptionalWriteable(this.jobConfig);
        }

        @Override
        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            if (!this.datafeedId.equals(BLANK_ID)) {
                builder.field(DatafeedConfig.ID.getPreferredName(), this.datafeedId);
            }
            if (this.datafeedConfig != null) {
                builder.field(DATAFEED_CONFIG.getPreferredName(), this.datafeedConfig);
            }
            if (this.jobConfig != null) {
                builder.field(JOB_CONFIG.getPreferredName(), this.jobConfig);
            }
            builder.endObject();
            return builder;
        }

        public int hashCode() {
            return Objects.hash(this.datafeedId, this.datafeedConfig, this.jobConfig);
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Request other = (Request)obj;
            return Objects.equals(this.datafeedId, other.datafeedId) && Objects.equals(this.datafeedConfig, other.datafeedConfig) && Objects.equals(this.jobConfig, other.jobConfig);
        }

        static {
            PARSER.declareObject(Builder::setDatafeedBuilder, DatafeedConfig.STRICT_PARSER, DATAFEED_CONFIG);
            PARSER.declareObject(Builder::setJobBuilder, Job.STRICT_PARSER, JOB_CONFIG);
        }

        public static class Builder {
            private String datafeedId;
            private DatafeedConfig.Builder datafeedBuilder;
            private Job.Builder jobBuilder;

            public Builder setDatafeedId(String datafeedId) {
                this.datafeedId = datafeedId;
                return this;
            }

            public Builder setDatafeedBuilder(DatafeedConfig.Builder datafeedBuilder) {
                this.datafeedBuilder = datafeedBuilder;
                return this;
            }

            public Builder setJobBuilder(Job.Builder jobBuilder) {
                this.jobBuilder = jobBuilder;
                return this;
            }

            public Request build() {
                if (this.datafeedBuilder != null) {
                    this.datafeedBuilder.setId("preview_id");
                    if (this.datafeedBuilder.getJobId() == null && this.jobBuilder == null) {
                        throw new IllegalArgumentException("[datafeed_config.job_id] must be set or a [job_config] must be provided");
                    }
                    if (this.datafeedBuilder.getJobId() == null) {
                        this.datafeedBuilder.setJobId("preview_job_id");
                    }
                }
                if (this.jobBuilder != null) {
                    this.jobBuilder.setId("preview_job_id");
                    if (this.datafeedBuilder == null && this.jobBuilder.getDatafeedConfig() == null) {
                        throw new IllegalArgumentException("[datafeed_config] must be present when a [job_config.datafeed_config] is not present");
                    }
                    if (this.datafeedBuilder != null && this.jobBuilder.getDatafeedConfig() != null) {
                        throw new IllegalArgumentException("[datafeed_config] must not be present when a [job_config.datafeed_config] is present");
                    }
                    if (this.jobBuilder.getDatafeedConfig() != null) {
                        this.datafeedBuilder = this.jobBuilder.getDatafeedConfig().setJobId(this.jobBuilder.getId()).setId(this.jobBuilder.getId());
                    }
                }
                if (this.datafeedId != null && (this.datafeedBuilder != null || this.jobBuilder != null)) {
                    throw new IllegalArgumentException("[datafeed_id] cannot be supplied when either [job_config] or [datafeed_config] is present");
                }
                return this.datafeedId != null ? new Request(this.datafeedId) : new Request(this.datafeedBuilder == null ? null : this.datafeedBuilder.build(), this.jobBuilder);
            }
        }
    }
}

