/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ml.action;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.support.tasks.BaseTasksRequest;
import org.elasticsearch.action.support.tasks.BaseTasksResponse;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xpack.core.ml.action.StartTrainedModelDeploymentAction;
import org.elasticsearch.xpack.core.ml.inference.TrainedModelConfig;
import org.elasticsearch.xpack.core.ml.utils.ExceptionsHelper;

public class StopTrainedModelDeploymentAction
extends ActionType<Response> {
    public static final StopTrainedModelDeploymentAction INSTANCE = new StopTrainedModelDeploymentAction();
    public static final String NAME = "cluster:admin/xpack/ml/trained_models/deployment/stop";

    public StopTrainedModelDeploymentAction() {
        super(NAME, Response::new);
    }

    public static class Response
    extends BaseTasksResponse
    implements Writeable,
    ToXContentObject {
        private final boolean undeployed;

        public Response(boolean undeployed) {
            super(null, null);
            this.undeployed = undeployed;
        }

        public Response(StreamInput in) throws IOException {
            super(in);
            this.undeployed = in.readBoolean();
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            out.writeBoolean(this.undeployed);
        }

        @Override
        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            this.toXContentCommon(builder, params);
            builder.field("stopped", this.undeployed);
            builder.endObject();
            return builder;
        }

        @Override
        public int hashCode() {
            return Objects.hash(this.undeployed);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Response that = (Response)o;
            return this.undeployed == that.undeployed;
        }
    }

    public static class Request
    extends BaseTasksRequest<Request>
    implements ToXContentObject {
        public static final ParseField ALLOW_NO_MATCH = new ParseField("allow_no_match", new String[0]);
        public static final ParseField FORCE = new ParseField("force", new String[0]);
        private String id;
        private boolean allowNoMatch = true;
        private boolean force;

        public Request(String id) {
            this.setId(id);
        }

        public Request(StreamInput in) throws IOException {
            super(in);
            this.id = in.readString();
            this.allowNoMatch = in.readBoolean();
            this.force = in.readBoolean();
        }

        public final void setId(String id) {
            this.id = ExceptionsHelper.requireNonNull(id, TrainedModelConfig.MODEL_ID);
        }

        public String getId() {
            return this.id;
        }

        public void setAllowNoMatch(boolean allowNoMatch) {
            this.allowNoMatch = allowNoMatch;
        }

        public boolean isAllowNoMatch() {
            return this.allowNoMatch;
        }

        public void setForce(boolean force) {
            this.force = force;
        }

        public boolean isForce() {
            return this.force;
        }

        @Override
        public boolean match(Task task) {
            return StartTrainedModelDeploymentAction.TaskMatcher.match(task, this.id);
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            out.writeString(this.id);
            out.writeBoolean(this.allowNoMatch);
            out.writeBoolean(this.force);
        }

        @Override
        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            builder.field(TrainedModelConfig.MODEL_ID.getPreferredName(), this.id);
            builder.field(ALLOW_NO_MATCH.getPreferredName(), this.allowNoMatch);
            builder.field(FORCE.getPreferredName(), this.force);
            builder.endObject();
            return builder;
        }

        public int hashCode() {
            return Objects.hash(this.id, this.allowNoMatch, this.force);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Request that = (Request)o;
            return Objects.equals(this.id, that.id) && this.allowNoMatch == that.allowNoMatch && this.force == that.force;
        }
    }
}

