/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ml.action;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.action.support.master.MasterNodeRequest;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.xpack.core.ml.inference.allocation.RoutingStateAndReason;
import org.elasticsearch.xpack.core.ml.utils.ExceptionsHelper;

public class UpdateTrainedModelAllocationStateAction
extends ActionType<AcknowledgedResponse> {
    public static final UpdateTrainedModelAllocationStateAction INSTANCE = new UpdateTrainedModelAllocationStateAction();
    public static final String NAME = "cluster:internal/xpack/ml/model_allocation/update";

    private UpdateTrainedModelAllocationStateAction() {
        super(NAME, AcknowledgedResponse::readFrom);
    }

    public static class Request
    extends MasterNodeRequest<Request> {
        private final String nodeId;
        private final String modelId;
        private final RoutingStateAndReason routingState;

        public Request(String nodeId, String modelId, RoutingStateAndReason routingState) {
            this.nodeId = ExceptionsHelper.requireNonNull(nodeId, "node_id");
            this.modelId = ExceptionsHelper.requireNonNull(modelId, "model_id");
            this.routingState = ExceptionsHelper.requireNonNull(routingState, "routing_state");
        }

        public Request(StreamInput in) throws IOException {
            super(in);
            this.nodeId = in.readString();
            this.modelId = in.readString();
            this.routingState = new RoutingStateAndReason(in);
        }

        public String getNodeId() {
            return this.nodeId;
        }

        public String getModelId() {
            return this.modelId;
        }

        public RoutingStateAndReason getRoutingState() {
            return this.routingState;
        }

        @Override
        public ActionRequestValidationException validate() {
            return null;
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            out.writeString(this.nodeId);
            out.writeString(this.modelId);
            this.routingState.writeTo(out);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Request request = (Request)o;
            return Objects.equals(this.nodeId, request.nodeId) && Objects.equals(this.modelId, request.modelId) && Objects.equals(this.routingState, request.routingState);
        }

        public int hashCode() {
            return Objects.hash(this.nodeId, this.modelId, this.routingState);
        }

        @Override
        public String toString() {
            return "Request{nodeId='" + this.nodeId + "', modelId='" + this.modelId + "', routingState=" + this.routingState + "}";
        }
    }
}

