/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ml.inference.results;

import java.io.IOException;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.xcontent.ConstructingObjectParser;
import org.elasticsearch.xcontent.ObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParseException;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xpack.core.ml.inference.results.AbstractFeatureImportance;

public class ClassificationFeatureImportance
extends AbstractFeatureImportance {
    private final List<ClassImportance> classImportance;
    private final String featureName;
    static final String FEATURE_NAME = "feature_name";
    static final String CLASSES = "classes";
    private static final ConstructingObjectParser<ClassificationFeatureImportance, Void> PARSER = new ConstructingObjectParser("classification_feature_importance", a -> new ClassificationFeatureImportance((String)a[0], (List)a[1]));

    public static ClassificationFeatureImportance fromXContent(XContentParser parser) {
        return PARSER.apply(parser, null);
    }

    public ClassificationFeatureImportance(String featureName, List<ClassImportance> classImportance) {
        this.featureName = Objects.requireNonNull(featureName);
        this.classImportance = classImportance == null ? Collections.emptyList() : Collections.unmodifiableList(classImportance);
    }

    public ClassificationFeatureImportance(StreamInput in) throws IOException {
        this.featureName = in.readString();
        this.classImportance = in.readList(ClassImportance::new);
    }

    public List<ClassImportance> getClassImportance() {
        return this.classImportance;
    }

    @Override
    public String getFeatureName() {
        return this.featureName;
    }

    public double getTotalImportance() {
        if (this.classImportance.size() == 2) {
            return Math.abs(this.classImportance.get(0).getImportance());
        }
        return this.classImportance.stream().mapToDouble(ClassImportance::getImportance).map(Math::abs).sum();
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.featureName);
        out.writeList(this.classImportance);
    }

    @Override
    public Map<String, Object> toMap() {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        map.put(FEATURE_NAME, this.featureName);
        if (!this.classImportance.isEmpty()) {
            map.put(CLASSES, this.classImportance.stream().map(ClassImportance::toMap).collect(Collectors.toList()));
        }
        return map;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        ClassificationFeatureImportance that = (ClassificationFeatureImportance)object;
        return Objects.equals(this.featureName, that.featureName) && Objects.equals(this.classImportance, that.classImportance);
    }

    public int hashCode() {
        return Objects.hash(this.featureName, this.classImportance);
    }

    static {
        PARSER.declareString(ConstructingObjectParser.constructorArg(), new ParseField(FEATURE_NAME, new String[0]));
        PARSER.declareObjectArray(ConstructingObjectParser.optionalConstructorArg(), (p, c) -> ClassImportance.fromXContent(p), new ParseField(CLASSES, new String[0]));
    }

    public static class ClassImportance
    implements Writeable,
    ToXContentObject {
        static final String CLASS_NAME = "class_name";
        static final String IMPORTANCE = "importance";
        private static final ConstructingObjectParser<ClassImportance, Void> PARSER = new ConstructingObjectParser("classification_feature_importance_class_importance", a -> new ClassImportance(a[0], (Double)a[1]));
        private final Object className;
        private final double importance;

        public static ClassImportance fromXContent(XContentParser parser) {
            return PARSER.apply(parser, null);
        }

        public ClassImportance(Object className, double importance) {
            this.className = className;
            this.importance = importance;
        }

        public ClassImportance(StreamInput in) throws IOException {
            this.className = in.readGenericValue();
            this.importance = in.readDouble();
        }

        public Object getClassName() {
            return this.className;
        }

        public double getImportance() {
            return this.importance;
        }

        public Map<String, Object> toMap() {
            LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
            map.put(CLASS_NAME, this.className);
            map.put(IMPORTANCE, this.importance);
            return map;
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeGenericValue(this.className);
            out.writeDouble(this.importance);
        }

        @Override
        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            return builder.map(this.toMap());
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ClassImportance that = (ClassImportance)o;
            return Double.compare(that.importance, this.importance) == 0 && Objects.equals(this.className, that.className);
        }

        public int hashCode() {
            return Objects.hash(this.className, this.importance);
        }

        static {
            PARSER.declareField(ConstructingObjectParser.constructorArg(), (p, c) -> {
                if (p.currentToken() == XContentParser.Token.VALUE_STRING) {
                    return p.text();
                }
                if (p.currentToken() == XContentParser.Token.VALUE_NUMBER) {
                    return p.numberValue();
                }
                if (p.currentToken() == XContentParser.Token.VALUE_BOOLEAN) {
                    return Boolean.valueOf(p.booleanValue());
                }
                throw new XContentParseException("Unsupported token [" + p.currentToken() + "]");
            }, new ParseField(CLASS_NAME, new String[0]), ObjectParser.ValueType.VALUE);
            PARSER.declareDouble(ConstructingObjectParser.constructorArg(), new ParseField(IMPORTANCE, new String[0]));
        }
    }
}

