/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ml.inference.trainedmodel;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.Version;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.xcontent.ObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xpack.core.ml.inference.trainedmodel.LenientlyParsedInferenceConfig;
import org.elasticsearch.xpack.core.ml.inference.trainedmodel.StrictlyParsedInferenceConfig;
import org.elasticsearch.xpack.core.ml.inference.trainedmodel.TargetType;

public class RegressionConfig
implements LenientlyParsedInferenceConfig,
StrictlyParsedInferenceConfig {
    public static final ParseField NAME = new ParseField("regression", new String[0]);
    private static final Version MIN_SUPPORTED_VERSION = Version.V_7_6_0;
    public static final ParseField RESULTS_FIELD = new ParseField("results_field", new String[0]);
    public static final ParseField NUM_TOP_FEATURE_IMPORTANCE_VALUES = new ParseField("num_top_feature_importance_values", new String[0]);
    public static RegressionConfig EMPTY_PARAMS = new RegressionConfig("predicted_value", null);
    private static final ObjectParser<Builder, Void> LENIENT_PARSER = RegressionConfig.createParser(true);
    private static final ObjectParser<Builder, Void> STRICT_PARSER = RegressionConfig.createParser(false);
    private final String resultsField;
    private final int numTopFeatureImportanceValues;

    private static ObjectParser<Builder, Void> createParser(boolean lenient) {
        ObjectParser<Builder, Void> parser = new ObjectParser<Builder, Void>(NAME.getPreferredName(), lenient, Builder::new);
        parser.declareString(Builder::setResultsField, RESULTS_FIELD);
        parser.declareInt(Builder::setNumTopFeatureImportanceValues, NUM_TOP_FEATURE_IMPORTANCE_VALUES);
        return parser;
    }

    public static RegressionConfig fromXContentStrict(XContentParser parser) {
        return STRICT_PARSER.apply(parser, null).build();
    }

    public static RegressionConfig fromXContentLenient(XContentParser parser) {
        return LENIENT_PARSER.apply(parser, null).build();
    }

    public RegressionConfig(String resultsField) {
        this(resultsField, 0);
    }

    public RegressionConfig(String resultsField, Integer numTopFeatureImportanceValues) {
        String string = this.resultsField = resultsField == null ? "predicted_value" : resultsField;
        if (numTopFeatureImportanceValues != null && numTopFeatureImportanceValues < 0) {
            throw new IllegalArgumentException("[" + NUM_TOP_FEATURE_IMPORTANCE_VALUES.getPreferredName() + "] must be greater than or equal to 0");
        }
        this.numTopFeatureImportanceValues = numTopFeatureImportanceValues == null ? 0 : numTopFeatureImportanceValues;
    }

    public RegressionConfig(StreamInput in) throws IOException {
        this.resultsField = in.readString();
        this.numTopFeatureImportanceValues = in.readVInt();
    }

    public int getNumTopFeatureImportanceValues() {
        return this.numTopFeatureImportanceValues;
    }

    @Override
    public String getResultsField() {
        return this.resultsField;
    }

    @Override
    public boolean requestingImportance() {
        return this.numTopFeatureImportanceValues > 0;
    }

    @Override
    public boolean isAllocateOnly() {
        return false;
    }

    @Override
    public String getWriteableName() {
        return NAME.getPreferredName();
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.resultsField);
        out.writeVInt(this.numTopFeatureImportanceValues);
    }

    @Override
    public String getName() {
        return NAME.getPreferredName();
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(RESULTS_FIELD.getPreferredName(), this.resultsField);
        builder.field(NUM_TOP_FEATURE_IMPORTANCE_VALUES.getPreferredName(), this.numTopFeatureImportanceValues);
        builder.endObject();
        return builder;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RegressionConfig that = (RegressionConfig)o;
        return Objects.equals(this.resultsField, that.resultsField) && Objects.equals(this.numTopFeatureImportanceValues, that.numTopFeatureImportanceValues);
    }

    public int hashCode() {
        return Objects.hash(this.resultsField, this.numTopFeatureImportanceValues);
    }

    @Override
    public boolean isTargetTypeSupported(TargetType targetType) {
        return TargetType.REGRESSION.equals(targetType);
    }

    @Override
    public Version getMinimalSupportedVersion() {
        return this.requestingImportance() ? Version.V_7_7_0 : MIN_SUPPORTED_VERSION;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private String resultsField;
        private Integer numTopFeatureImportanceValues;

        Builder() {
        }

        Builder(RegressionConfig config) {
            this.resultsField = config.resultsField;
            this.numTopFeatureImportanceValues = config.numTopFeatureImportanceValues;
        }

        public Builder setResultsField(String resultsField) {
            this.resultsField = resultsField;
            return this;
        }

        public Builder setNumTopFeatureImportanceValues(Integer numTopFeatureImportanceValues) {
            this.numTopFeatureImportanceValues = numTopFeatureImportanceValues;
            return this;
        }

        public RegressionConfig build() {
            return new RegressionConfig(this.resultsField, this.numTopFeatureImportanceValues);
        }
    }
}

