/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ml.job.config;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.SortedSet;
import java.util.TreeSet;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.xcontent.ObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xpack.core.ml.job.messages.Messages;
import org.elasticsearch.xpack.core.ml.utils.ExceptionsHelper;
import org.elasticsearch.xpack.core.ml.utils.MlStrings;

public class MlFilter
implements ToXContentObject,
Writeable {
    private static final int MAX_ITEMS = 10000;
    public static final String DOCUMENT_ID_PREFIX = "filter_";
    public static final String FILTER_TYPE = "filter";
    public static final ParseField TYPE = new ParseField("type", new String[0]);
    public static final ParseField ID = new ParseField("filter_id", new String[0]);
    public static final ParseField DESCRIPTION = new ParseField("description", new String[0]);
    public static final ParseField ITEMS = new ParseField("items", new String[0]);
    public static final ParseField RESULTS_FIELD = new ParseField("filters", new String[0]);
    public static final ObjectParser<Builder, Void> STRICT_PARSER = MlFilter.createParser(false);
    public static final ObjectParser<Builder, Void> LENIENT_PARSER = MlFilter.createParser(true);
    private final String id;
    private final String description;
    private final SortedSet<String> items;

    private static ObjectParser<Builder, Void> createParser(boolean ignoreUnknownFields) {
        ObjectParser<Builder, Void> parser = new ObjectParser<Builder, Void>(TYPE.getPreferredName(), ignoreUnknownFields, () -> new Builder());
        parser.declareString((builder, s) -> {}, TYPE);
        parser.declareString(Builder::setId, ID);
        parser.declareStringOrNull(Builder::setDescription, DESCRIPTION);
        parser.declareStringArray(Builder::setItems, ITEMS);
        return parser;
    }

    private MlFilter(String id, String description, SortedSet<String> items) {
        this.id = Objects.requireNonNull(id);
        this.description = description;
        this.items = Objects.requireNonNull(items);
    }

    public MlFilter(StreamInput in) throws IOException {
        this.id = in.readString();
        this.description = in.readOptionalString();
        this.items = new TreeSet<String>(Arrays.asList(in.readStringArray()));
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.id);
        out.writeOptionalString(this.description);
        out.writeStringArray(this.items.toArray(new String[this.items.size()]));
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(ID.getPreferredName(), this.id);
        if (this.description != null) {
            builder.field(DESCRIPTION.getPreferredName(), this.description);
        }
        builder.field(ITEMS.getPreferredName(), this.items);
        if (params.paramAsBoolean("for_internal_storage", false)) {
            builder.field(TYPE.getPreferredName(), FILTER_TYPE);
        }
        builder.endObject();
        return builder;
    }

    public String getId() {
        return this.id;
    }

    public String getDescription() {
        return this.description;
    }

    public SortedSet<String> getItems() {
        return Collections.unmodifiableSortedSet(this.items);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof MlFilter)) {
            return false;
        }
        MlFilter other = (MlFilter)obj;
        return this.id.equals(other.id) && Objects.equals(this.description, other.description) && this.items.equals(other.items);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.description, this.items);
    }

    public String documentId() {
        return MlFilter.documentId(this.id);
    }

    public static String documentId(String filterId) {
        return DOCUMENT_ID_PREFIX + filterId;
    }

    public static Builder builder(String filterId) {
        return new Builder().setId(filterId);
    }

    public static class Builder {
        private String id;
        private String description;
        private SortedSet<String> items = new TreeSet<String>();

        private Builder() {
        }

        public Builder setId(String id) {
            this.id = id;
            return this;
        }

        @Nullable
        public String getId() {
            return this.id;
        }

        public Builder setDescription(String description) {
            this.description = description;
            return this;
        }

        public Builder setItems(SortedSet<String> items) {
            this.items = items;
            return this;
        }

        public Builder setItems(List<String> items) {
            this.items = new TreeSet<String>(items);
            return this;
        }

        public Builder setItems(String ... items) {
            this.setItems(Arrays.asList(items));
            return this;
        }

        public MlFilter build() {
            ExceptionsHelper.requireNonNull(this.id, ID.getPreferredName());
            ExceptionsHelper.requireNonNull(this.items, ITEMS.getPreferredName());
            if (!MlStrings.isValidId(this.id)) {
                throw ExceptionsHelper.badRequestException(Messages.getMessage("Invalid {0}; ''{1}'' can contain lowercase alphanumeric (a-z and 0-9), hyphens or underscores; must start and end with alphanumeric", ID.getPreferredName(), this.id), new Object[0]);
            }
            if (this.items.size() > 10000) {
                throw ExceptionsHelper.badRequestException(Messages.getMessage("Filter [{0}] contains too many items; up to [{1}] items are allowed", this.id, 10000), new Object[0]);
            }
            return new MlFilter(this.id, this.description, this.items);
        }
    }
}

