/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.security;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.List;
import java.util.Objects;
import org.elasticsearch.common.Strings;
import org.elasticsearch.xcontent.ConstructingObjectParser;
import org.elasticsearch.xcontent.DeprecationHandler;
import org.elasticsearch.xcontent.NamedXContentRegistry;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xcontent.json.JsonXContent;

public class EnrollmentToken {
    private final String apiKey;
    private final String fingerprint;
    private final String version;
    private final List<String> boundAddress;
    private static final ParseField API_KEY = new ParseField("key", new String[0]);
    private static final ParseField FINGERPRINT = new ParseField("fgr", new String[0]);
    private static final ParseField VERSION = new ParseField("ver", new String[0]);
    private static final ParseField ADDRESS = new ParseField("adr", new String[0]);
    public static final ConstructingObjectParser<EnrollmentToken, Void> PARSER = new ConstructingObjectParser("enrollment_token", false, a -> new EnrollmentToken((String)a[0], (String)a[1], (String)a[2], (List)a[3]));

    public String getApiKey() {
        return this.apiKey;
    }

    public String getFingerprint() {
        return this.fingerprint;
    }

    public String getVersion() {
        return this.version;
    }

    public List<String> getBoundAddress() {
        return this.boundAddress;
    }

    public EnrollmentToken(String apiKey, String fingerprint, String version, List<String> boundAddress) {
        this.apiKey = Objects.requireNonNull(apiKey);
        this.fingerprint = Objects.requireNonNull(fingerprint);
        this.version = Objects.requireNonNull(version);
        this.boundAddress = Objects.requireNonNull(boundAddress);
    }

    public String getRaw() throws Exception {
        XContentBuilder builder = JsonXContent.contentBuilder();
        builder.startObject();
        builder.field("ver", this.version);
        builder.startArray("adr");
        for (String bound_address : this.boundAddress) {
            builder.value(bound_address);
        }
        builder.endArray();
        builder.field("fgr", this.fingerprint);
        builder.field("key", this.apiKey);
        builder.endObject();
        return Strings.toString(builder);
    }

    public String getEncoded() throws Exception {
        String jsonString = this.getRaw();
        return Base64.getUrlEncoder().encodeToString(jsonString.getBytes(StandardCharsets.UTF_8));
    }

    public static EnrollmentToken decodeFromString(String encoded) throws IOException {
        if (Strings.isNullOrEmpty(encoded)) {
            throw new IOException("Cannot decode enrollment token from an empty string");
        }
        XContentParser jsonParser = JsonXContent.jsonXContent.createParser(NamedXContentRegistry.EMPTY, DeprecationHandler.THROW_UNSUPPORTED_OPERATION, Base64.getDecoder().decode(encoded));
        return PARSER.parse(jsonParser, null);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EnrollmentToken that = (EnrollmentToken)o;
        return this.apiKey.equals(that.apiKey) && this.fingerprint.equals(that.fingerprint) && this.version.equals(that.version) && this.boundAddress.equals(that.boundAddress);
    }

    public int hashCode() {
        return Objects.hash(this.apiKey, this.fingerprint, this.version, this.boundAddress);
    }

    static {
        PARSER.declareString(ConstructingObjectParser.constructorArg(), API_KEY);
        PARSER.declareString(ConstructingObjectParser.constructorArg(), FINGERPRINT);
        PARSER.declareString(ConstructingObjectParser.constructorArg(), VERSION);
        PARSER.declareStringArray(ConstructingObjectParser.constructorArg(), ADDRESS);
    }
}

