/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.security;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.ElasticsearchSecurityException;
import org.elasticsearch.Version;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.common.xcontent.XContentHelper;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.node.Node;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentType;
import org.elasticsearch.xpack.core.security.authc.Authentication;
import org.elasticsearch.xpack.core.security.authc.support.AuthenticationContextSerializer;
import org.elasticsearch.xpack.core.security.authc.support.SecondaryAuthentication;
import org.elasticsearch.xpack.core.security.user.User;

public class SecurityContext {
    private final Logger logger = LogManager.getLogger(SecurityContext.class);
    private final ThreadContext threadContext;
    private final AuthenticationContextSerializer authenticationSerializer;
    private final String nodeName;

    public SecurityContext(Settings settings, ThreadContext threadContext) {
        this.threadContext = threadContext;
        this.authenticationSerializer = new AuthenticationContextSerializer();
        this.nodeName = Node.NODE_NAME_SETTING.get(settings);
    }

    public User requireUser() {
        User user = this.getUser();
        if (user == null) {
            throw new ElasticsearchSecurityException("there is no user available in the current context", new Object[0]);
        }
        return user;
    }

    @Nullable
    public User getUser() {
        Authentication authentication = this.getAuthentication();
        return authentication == null ? null : authentication.getUser();
    }

    @Nullable
    public Authentication getAuthentication() {
        try {
            return this.authenticationSerializer.readFromContext(this.threadContext);
        }
        catch (IOException e) {
            this.logger.error("failed to read authentication", (Throwable)e);
            throw new UncheckedIOException(e);
        }
    }

    public SecondaryAuthentication getSecondaryAuthentication() {
        try {
            return SecondaryAuthentication.readFromContext(this);
        }
        catch (IOException e) {
            this.logger.error("failed to read secondary authentication", (Throwable)e);
            throw new UncheckedIOException(e);
        }
    }

    public ThreadContext getThreadContext() {
        return this.threadContext;
    }

    public void setUser(User user, Version version) {
        Objects.requireNonNull(user);
        Authentication.RealmRef authenticatedBy = new Authentication.RealmRef("__attach", "__attach", this.nodeName);
        Authentication.RealmRef lookedUpBy = user.isRunAs() ? authenticatedBy : null;
        this.setAuthentication(new Authentication(user, authenticatedBy, lookedUpBy, version, Authentication.AuthenticationType.INTERNAL, Collections.emptyMap()));
    }

    private void setAuthentication(Authentication authentication) {
        try {
            authentication.writeToContext(this.threadContext);
        }
        catch (IOException e) {
            throw new AssertionError("how can we have a IOException with a user we set", e);
        }
    }

    public void executeAsUser(User user, Consumer<ThreadContext.StoredContext> consumer, Version version) {
        ThreadContext.StoredContext original = this.threadContext.newStoredContext(true);
        try (ThreadContext.StoredContext ignore = this.threadContext.stashContext();){
            this.setUser(user, version);
            consumer.accept(original);
        }
    }

    public <T> T executeWithAuthentication(Authentication authentication, Function<ThreadContext.StoredContext, T> consumer) {
        ThreadContext.StoredContext original = this.threadContext.newStoredContext(true);
        try (ThreadContext.StoredContext ignore = this.threadContext.stashContext();){
            this.setAuthentication(authentication);
            T t = consumer.apply(original);
            return t;
        }
    }

    public void executeAfterRewritingAuthentication(Consumer<ThreadContext.StoredContext> consumer, Version version) {
        Map<String, String> existingRequestHeaders = this.threadContext.getRequestHeadersOnly();
        ThreadContext.StoredContext original = this.threadContext.newStoredContext(true);
        Authentication authentication = this.getAuthentication();
        try (ThreadContext.StoredContext ignore = this.threadContext.stashContext();){
            this.setAuthentication(new Authentication(authentication.getUser(), authentication.getAuthenticatedBy(), authentication.getLookedUpBy(), version, authentication.getAuthenticationType(), this.rewriteMetadataForApiKeyRoleDescriptors(version, authentication)));
            existingRequestHeaders.forEach((k, v) -> {
                if (this.threadContext.getHeader((String)k) == null) {
                    this.threadContext.putHeader((String)k, (String)v);
                }
            });
            consumer.accept(original);
        }
    }

    private Map<String, Object> rewriteMetadataForApiKeyRoleDescriptors(Version streamVersion, Authentication authentication) {
        Map<String, Object> metadata = authentication.getMetadata();
        if (authentication.getAuthenticationType() == Authentication.AuthenticationType.API_KEY) {
            if (authentication.getVersion().onOrAfter(Authentication.VERSION_API_KEY_ROLES_AS_BYTES) && streamVersion.before(Authentication.VERSION_API_KEY_ROLES_AS_BYTES)) {
                metadata = new HashMap<String, Object>(metadata);
                metadata.put("_security_api_key_role_descriptors", this.convertRoleDescriptorsBytesToMap((BytesReference)metadata.get("_security_api_key_role_descriptors")));
                metadata.put("_security_api_key_limited_by_role_descriptors", this.convertRoleDescriptorsBytesToMap((BytesReference)metadata.get("_security_api_key_limited_by_role_descriptors")));
            } else if (authentication.getVersion().before(Authentication.VERSION_API_KEY_ROLES_AS_BYTES) && streamVersion.onOrAfter(Authentication.VERSION_API_KEY_ROLES_AS_BYTES)) {
                metadata = new HashMap<String, Object>(metadata);
                metadata.put("_security_api_key_role_descriptors", this.convertRoleDescriptorsMapToBytes((Map)metadata.get("_security_api_key_role_descriptors")));
                metadata.put("_security_api_key_limited_by_role_descriptors", this.convertRoleDescriptorsMapToBytes((Map)metadata.get("_security_api_key_limited_by_role_descriptors")));
            }
        }
        return metadata;
    }

    private Map<String, Object> convertRoleDescriptorsBytesToMap(BytesReference roleDescriptorsBytes) {
        return XContentHelper.convertToMap(roleDescriptorsBytes, false, XContentType.JSON).v2();
    }

    private BytesReference convertRoleDescriptorsMapToBytes(Map<String, Object> roleDescriptorsMap) {
        XContentBuilder builder = XContentBuilder.builder(XContentType.JSON.xContent());
        try {
            builder.map(roleDescriptorsMap);
            BytesReference bytesReference = BytesReference.bytes(builder);
            if (builder != null) {
                builder.close();
            }
            return bytesReference;
        }
        catch (Throwable throwable) {
            try {
                if (builder != null) {
                    try {
                        builder.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
    }
}

