/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.security.authz.permission;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import org.apache.lucene.util.automaton.Automaton;
import org.elasticsearch.cluster.metadata.IndexAbstraction;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.util.set.Sets;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.core.Tuple;
import org.elasticsearch.transport.TransportRequest;
import org.elasticsearch.xpack.core.security.authc.Authentication;
import org.elasticsearch.xpack.core.security.authz.RoleDescriptor;
import org.elasticsearch.xpack.core.security.authz.accesscontrol.IndicesAccessControl;
import org.elasticsearch.xpack.core.security.authz.permission.ApplicationPermission;
import org.elasticsearch.xpack.core.security.authz.permission.ClusterPermission;
import org.elasticsearch.xpack.core.security.authz.permission.FieldPermissions;
import org.elasticsearch.xpack.core.security.authz.permission.FieldPermissionsCache;
import org.elasticsearch.xpack.core.security.authz.permission.FieldPermissionsDefinition;
import org.elasticsearch.xpack.core.security.authz.permission.IndicesPermission;
import org.elasticsearch.xpack.core.security.authz.permission.ResourcePrivilegesMap;
import org.elasticsearch.xpack.core.security.authz.permission.RunAsPermission;
import org.elasticsearch.xpack.core.security.authz.privilege.ApplicationPrivilege;
import org.elasticsearch.xpack.core.security.authz.privilege.ApplicationPrivilegeDescriptor;
import org.elasticsearch.xpack.core.security.authz.privilege.ClusterPrivilege;
import org.elasticsearch.xpack.core.security.authz.privilege.ClusterPrivilegeResolver;
import org.elasticsearch.xpack.core.security.authz.privilege.ConfigurableClusterPrivilege;
import org.elasticsearch.xpack.core.security.authz.privilege.IndexPrivilege;
import org.elasticsearch.xpack.core.security.authz.privilege.Privilege;
import org.elasticsearch.xpack.core.security.support.Automatons;

public class Role {
    public static final Role EMPTY = Role.builder(Automatons.EMPTY, "__empty").build();
    private final String[] names;
    private final ClusterPermission cluster;
    private final IndicesPermission indices;
    private final ApplicationPermission application;
    private final RunAsPermission runAs;

    Role(String[] names, ClusterPermission cluster, IndicesPermission indices, ApplicationPermission application, RunAsPermission runAs) {
        this.names = names;
        this.cluster = Objects.requireNonNull(cluster);
        this.indices = Objects.requireNonNull(indices);
        this.application = Objects.requireNonNull(application);
        this.runAs = Objects.requireNonNull(runAs);
    }

    public String[] names() {
        return this.names;
    }

    public ClusterPermission cluster() {
        return this.cluster;
    }

    public IndicesPermission indices() {
        return this.indices;
    }

    public ApplicationPermission application() {
        return this.application;
    }

    public RunAsPermission runAs() {
        return this.runAs;
    }

    public boolean hasFieldOrDocumentLevelSecurity() {
        return this.indices.hasFieldOrDocumentLevelSecurity();
    }

    public static Builder builder(Automaton restrictedIndices, String ... names) {
        return new Builder(restrictedIndices, names);
    }

    public static Builder builder(RoleDescriptor rd, FieldPermissionsCache fieldPermissionsCache, Automaton restrictedIndices) {
        return new Builder(rd, fieldPermissionsCache, restrictedIndices);
    }

    public Predicate<IndexAbstraction> allowedIndicesMatcher(String action) {
        return this.indices.allowedIndicesMatcher(action);
    }

    public Automaton allowedActionsMatcher(String index) {
        return this.indices.allowedActionsMatcher(index);
    }

    public boolean checkRunAs(String runAsName) {
        return this.runAs.check(runAsName);
    }

    public boolean checkIndicesAction(String action) {
        return this.indices.check(action);
    }

    public ResourcePrivilegesMap checkIndicesPrivileges(Set<String> checkForIndexPatterns, boolean allowRestrictedIndices, Set<String> checkForPrivileges) {
        return this.indices.checkResourcePrivileges(checkForIndexPatterns, allowRestrictedIndices, checkForPrivileges);
    }

    public boolean checkClusterAction(String action, TransportRequest request, Authentication authentication) {
        return this.cluster.check(action, request, authentication);
    }

    public boolean grants(ClusterPrivilege clusterPrivilege) {
        return this.cluster.implies(clusterPrivilege.buildPermission(ClusterPermission.builder()).build());
    }

    public ResourcePrivilegesMap checkApplicationResourcePrivileges(String applicationName, Set<String> checkForResources, Set<String> checkForPrivilegeNames, Collection<ApplicationPrivilegeDescriptor> storedPrivileges) {
        return this.application.checkResourcePrivileges(applicationName, checkForResources, checkForPrivilegeNames, storedPrivileges);
    }

    public IndicesAccessControl authorize(String action, Set<String> requestedIndicesOrAliases, Map<String, IndexAbstraction> aliasAndIndexLookup, FieldPermissionsCache fieldPermissionsCache) {
        return this.indices.authorize(action, requestedIndicesOrAliases, aliasAndIndexLookup, fieldPermissionsCache);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Role that = (Role)o;
        return Arrays.equals(this.names, that.names) && this.cluster.equals(that.cluster) && this.indices.equals(that.indices) && this.application.equals(that.application) && this.runAs.equals(that.runAs);
    }

    public int hashCode() {
        int result = Objects.hash(this.cluster, this.indices, this.application, this.runAs);
        result = 31 * result + Arrays.hashCode(this.names);
        return result;
    }

    public static class Builder {
        private final String[] names;
        private ClusterPermission cluster = ClusterPermission.NONE;
        private RunAsPermission runAs = RunAsPermission.NONE;
        private final List<IndicesPermissionGroupDefinition> groups = new ArrayList<IndicesPermissionGroupDefinition>();
        private final List<Tuple<ApplicationPrivilege, Set<String>>> applicationPrivs = new ArrayList<Tuple<ApplicationPrivilege, Set<String>>>();
        private final Automaton restrictedNamesAutomaton;

        private Builder(Automaton restrictedNamesAutomaton, String[] names) {
            this.restrictedNamesAutomaton = restrictedNamesAutomaton;
            this.names = names;
        }

        private Builder(RoleDescriptor rd, @Nullable FieldPermissionsCache fieldPermissionsCache, Automaton restrictedNamesAutomaton) {
            RoleDescriptor.ApplicationResourcePrivileges[] applicationPrivileges;
            this.names = new String[]{rd.getName()};
            this.cluster(Sets.newHashSet(rd.getClusterPrivileges()), Arrays.asList(rd.getConditionalClusterPrivileges()));
            this.groups.addAll(Builder.convertFromIndicesPrivileges(rd.getIndicesPrivileges(), fieldPermissionsCache));
            for (RoleDescriptor.ApplicationResourcePrivileges applicationPrivilege : applicationPrivileges = rd.getApplicationPrivileges()) {
                this.applicationPrivs.add(Builder.convertApplicationPrivilege(applicationPrivilege));
            }
            String[] rdRunAs = rd.getRunAs();
            if (rdRunAs != null && rdRunAs.length > 0) {
                this.runAs(new Privilege(Sets.newHashSet(rdRunAs), rdRunAs));
            }
            this.restrictedNamesAutomaton = restrictedNamesAutomaton;
        }

        public Builder cluster(Set<String> privilegeNames, Iterable<ConfigurableClusterPrivilege> configurableClusterPrivileges) {
            ClusterPermission.Builder builder = ClusterPermission.builder();
            if (!privilegeNames.isEmpty()) {
                for (String name : privilegeNames) {
                    builder = ClusterPrivilegeResolver.resolve(name).buildPermission(builder);
                }
            }
            for (ConfigurableClusterPrivilege ccp : configurableClusterPrivileges) {
                builder = ccp.buildPermission(builder);
            }
            this.cluster = builder.build();
            return this;
        }

        public Builder runAs(Privilege privilege) {
            this.runAs = new RunAsPermission(privilege);
            return this;
        }

        public Builder add(IndexPrivilege privilege, String ... indices) {
            this.groups.add(new IndicesPermissionGroupDefinition(privilege, FieldPermissions.DEFAULT, null, false, indices));
            return this;
        }

        public Builder add(FieldPermissions fieldPermissions, Set<BytesReference> query, IndexPrivilege privilege, boolean allowRestrictedIndices, String ... indices) {
            this.groups.add(new IndicesPermissionGroupDefinition(privilege, fieldPermissions, query, allowRestrictedIndices, indices));
            return this;
        }

        public Builder addApplicationPrivilege(ApplicationPrivilege privilege, Set<String> resources) {
            this.applicationPrivs.add(new Tuple<ApplicationPrivilege, Set<String>>(privilege, resources));
            return this;
        }

        public Role build() {
            IndicesPermission indices;
            if (this.groups.isEmpty()) {
                indices = IndicesPermission.NONE;
            } else {
                IndicesPermission.Builder indicesBuilder = new IndicesPermission.Builder(this.restrictedNamesAutomaton);
                for (IndicesPermissionGroupDefinition group : this.groups) {
                    indicesBuilder.addGroup(group.privilege, group.fieldPermissions, group.query, group.allowRestrictedIndices, group.indices);
                }
                indices = indicesBuilder.build();
            }
            ApplicationPermission applicationPermission = this.applicationPrivs.isEmpty() ? ApplicationPermission.NONE : new ApplicationPermission(this.applicationPrivs);
            return new Role(this.names, this.cluster, indices, applicationPermission, this.runAs);
        }

        static List<IndicesPermissionGroupDefinition> convertFromIndicesPrivileges(RoleDescriptor.IndicesPrivileges[] indicesPrivileges, @Nullable FieldPermissionsCache fieldPermissionsCache) {
            ArrayList<IndicesPermissionGroupDefinition> list = new ArrayList<IndicesPermissionGroupDefinition>(indicesPrivileges.length);
            for (RoleDescriptor.IndicesPrivileges privilege : indicesPrivileges) {
                FieldPermissions fieldPermissions = fieldPermissionsCache != null ? fieldPermissionsCache.getFieldPermissions(privilege.getGrantedFields(), privilege.getDeniedFields()) : new FieldPermissions(new FieldPermissionsDefinition(privilege.getGrantedFields(), privilege.getDeniedFields()));
                Set<BytesReference> query = privilege.getQuery() == null ? null : Collections.singleton(privilege.getQuery());
                list.add(new IndicesPermissionGroupDefinition(IndexPrivilege.get(Sets.newHashSet(privilege.getPrivileges())), fieldPermissions, query, privilege.allowRestrictedIndices(), privilege.getIndices()));
            }
            return list;
        }

        static Tuple<ApplicationPrivilege, Set<String>> convertApplicationPrivilege(RoleDescriptor.ApplicationResourcePrivileges arp) {
            return new Tuple<ApplicationPrivilege, Set<String>>(new ApplicationPrivilege(arp.getApplication(), Sets.newHashSet(arp.getPrivileges()), arp.getPrivileges()), Sets.newHashSet(arp.getResources()));
        }

        private static class IndicesPermissionGroupDefinition {
            private final IndexPrivilege privilege;
            private final FieldPermissions fieldPermissions;
            @Nullable
            private final Set<BytesReference> query;
            private final boolean allowRestrictedIndices;
            private final String[] indices;

            private IndicesPermissionGroupDefinition(IndexPrivilege privilege, FieldPermissions fieldPermissions, @Nullable Set<BytesReference> query, boolean allowRestrictedIndices, String ... indices) {
                this.privilege = privilege;
                this.fieldPermissions = fieldPermissions;
                this.query = query;
                this.allowRestrictedIndices = allowRestrictedIndices;
                this.indices = indices;
            }
        }
    }
}

