/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.sql.cli.command;

import java.sql.SQLException;
import org.elasticsearch.xpack.sql.client.ClientException;
import org.elasticsearch.xpack.sql.client.ClientVersion;
import org.elasticsearch.xpack.sql.client.HttpClient;
import org.elasticsearch.xpack.sql.proto.MainResponse;
import org.elasticsearch.xpack.sql.proto.SqlVersion;

public class CliSession {
    private final HttpClient httpClient;
    private int fetchSize = 1000;
    private String fetchSeparator = "";
    private boolean debug;
    private boolean binary;

    public CliSession(HttpClient httpClient) {
        this.httpClient = httpClient;
    }

    public HttpClient getClient() {
        return this.httpClient;
    }

    public void setFetchSize(int fetchSize) {
        if (fetchSize <= 0) {
            throw new IllegalArgumentException("Must be > 0.");
        }
        this.fetchSize = fetchSize;
    }

    public int getFetchSize() {
        return this.fetchSize;
    }

    public void setFetchSeparator(String fetchSeparator) {
        this.fetchSeparator = fetchSeparator;
    }

    public String getFetchSeparator() {
        return this.fetchSeparator;
    }

    public void setDebug(boolean debug) {
        this.debug = debug;
    }

    public boolean isDebug() {
        return this.debug;
    }

    public void setBinary(boolean binary) {
        this.binary = binary;
    }

    public boolean isBinary() {
        return this.binary;
    }

    public void checkConnection() throws ClientException {
        MainResponse response;
        try {
            response = this.httpClient.serverInfo();
        }
        catch (SQLException ex) {
            throw new ClientException(ex);
        }
        SqlVersion version = SqlVersion.fromString(response.getVersion());
        if (!ClientVersion.isServerCompatible(version)) {
            throw new ClientException("This version of the CLI is only compatible with Elasticsearch version " + ClientVersion.CURRENT.majorMinorToString() + " or newer; attempting to connect to a server version " + version.toString());
        }
    }
}

