/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.sql.proto;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.xcontent.ConstructingObjectParser;
import org.elasticsearch.xcontent.ObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentLocation;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xpack.sql.proto.ProtoUtils;

public class SqlTypedParamValue
implements ToXContentObject {
    private static final ConstructingObjectParser<SqlTypedParamValue, Void> PARSER = new ConstructingObjectParser("params", true, objects -> new SqlTypedParamValue((String)objects[1], objects[0]));
    private static final ParseField VALUE = new ParseField("value", new String[0]);
    private static final ParseField TYPE = new ParseField("type", new String[0]);
    public final Object value;
    public final String type;
    private boolean hasExplicitType;
    private XContentLocation tokenLocation;

    public SqlTypedParamValue(String type, Object value) {
        this(type, value, true);
    }

    public SqlTypedParamValue(String type, Object value, boolean hasExplicitType) {
        this.value = value;
        this.type = type;
        this.hasExplicitType = hasExplicitType;
    }

    public boolean hasExplicitType() {
        return this.hasExplicitType;
    }

    public void hasExplicitType(boolean hasExplicitType) {
        this.hasExplicitType = hasExplicitType;
    }

    public XContentLocation tokenLocation() {
        return this.tokenLocation;
    }

    public void tokenLocation(XContentLocation tokenLocation) {
        this.tokenLocation = tokenLocation;
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field("type", this.type);
        builder.field("value", this.value);
        builder.endObject();
        return builder;
    }

    public static SqlTypedParamValue fromXContent(XContentParser parser) {
        return PARSER.apply(parser, null);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SqlTypedParamValue that = (SqlTypedParamValue)o;
        return Objects.equals(this.value, that.value) && Objects.equals(this.type, that.type) && Objects.equals(this.hasExplicitType, that.hasExplicitType);
    }

    public int hashCode() {
        return Objects.hash(this.value, this.type, this.hasExplicitType);
    }

    public String toString() {
        return String.valueOf(this.value) + " [" + this.type + "][" + this.hasExplicitType + "][" + this.tokenLocation + "]";
    }

    static {
        PARSER.declareField(ConstructingObjectParser.constructorArg(), (p, c) -> ProtoUtils.parseFieldsValue(p), VALUE, ObjectParser.ValueType.VALUE);
        PARSER.declareString(ConstructingObjectParser.constructorArg(), TYPE);
    }
}

