/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.transform.action;

import java.time.Clock;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.ExceptionsHelper;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.client.Client;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.common.logging.LoggerMessageFormat;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.core.Tuple;
import org.elasticsearch.index.engine.VersionConflictEngineException;
import org.elasticsearch.persistent.PersistentTasksCustomMetadata;
import org.elasticsearch.xpack.core.XPackSettings;
import org.elasticsearch.xpack.core.security.SecurityContext;
import org.elasticsearch.xpack.core.transform.action.ValidateTransformAction;
import org.elasticsearch.xpack.core.transform.transforms.TransformCheckpoint;
import org.elasticsearch.xpack.core.transform.transforms.TransformConfig;
import org.elasticsearch.xpack.core.transform.transforms.TransformConfigUpdate;
import org.elasticsearch.xpack.core.transform.transforms.TransformDestIndexSettings;
import org.elasticsearch.xpack.core.transform.transforms.TransformStoredDoc;
import org.elasticsearch.xpack.core.transform.transforms.persistence.TransformInternalIndexConstants;
import org.elasticsearch.xpack.transform.action.TransformPrivilegeChecker;
import org.elasticsearch.xpack.transform.persistence.SeqNoPrimaryTermAndIndex;
import org.elasticsearch.xpack.transform.persistence.TransformConfigManager;
import org.elasticsearch.xpack.transform.persistence.TransformIndex;

public class TransformUpdater {
    private static final Logger logger = LogManager.getLogger(TransformUpdater.class);

    public static void updateTransform(SecurityContext securityContext, IndexNameExpressionResolver indexNameExpressionResolver, ClusterState clusterState, Settings settings, Client client, TransformConfigManager transformConfigManager, TransformConfig config, TransformConfigUpdate update, SeqNoPrimaryTermAndIndex seqNoPrimaryTermAndIndex, boolean deferValidation, boolean dryRun, boolean checkAccess, TimeValue timeout, ActionListener<UpdateResult> listener) {
        TransformConfig rewrittenConfig = TransformConfig.rewriteForUpdate((TransformConfig)config);
        TransformConfig updatedConfig = update != null ? update.apply(rewrittenConfig) : rewrittenConfig;
        ActionListener updateStateListener = ActionListener.wrap(lastCheckpoint -> {
            if (lastCheckpoint == null || lastCheckpoint == -1L) {
                listener.onResponse((Object)new UpdateResult(updatedConfig, UpdateResult.Status.UPDATED));
                return;
            }
            TransformUpdater.updateTransformCheckpoint(config.getId(), lastCheckpoint, transformConfigManager, (ActionListener<Boolean>)ActionListener.wrap(r -> listener.onResponse((Object)new UpdateResult(updatedConfig, UpdateResult.Status.UPDATED)), arg_0 -> ((ActionListener)listener).onFailure(arg_0)));
        }, arg_0 -> listener.onFailure(arg_0));
        ActionListener updateTransformListener = ActionListener.wrap(r -> TransformUpdater.updateTransformStateAndGetLastCheckpoint(config.getId(), transformConfigManager, (ActionListener<Long>)updateStateListener), arg_0 -> listener.onFailure(arg_0));
        ActionListener validateTransformListener = ActionListener.wrap(destIndexMappings -> {
            if (config.getVersion() != null && config.getVersion().onOrAfter(TransformInternalIndexConstants.INDEX_VERSION_LAST_CHANGED) && updatedConfig.equals((Object)config)) {
                listener.onResponse((Object)new UpdateResult(updatedConfig, UpdateResult.Status.NONE));
                return;
            }
            if (dryRun) {
                listener.onResponse((Object)new UpdateResult(updatedConfig, UpdateResult.Status.NEEDS_UPDATE));
                return;
            }
            TransformUpdater.updateTransformConfiguration(client, transformConfigManager, indexNameExpressionResolver, updatedConfig, destIndexMappings, seqNoPrimaryTermAndIndex, clusterState, (ActionListener<Void>)ActionListener.wrap(r -> updateTransformListener.onResponse(null), arg_0 -> ((ActionListener)listener).onFailure(arg_0)));
        }, arg_0 -> listener.onFailure(arg_0));
        ActionListener checkPrivilegesListener = ActionListener.wrap(aVoid -> TransformUpdater.validateTransform(updatedConfig, client, deferValidation, timeout, (ActionListener<Map<String, String>>)validateTransformListener), arg_0 -> listener.onFailure(arg_0));
        if (checkAccess && ((Boolean)XPackSettings.SECURITY_ENABLED.get(settings)).booleanValue() && !deferValidation) {
            TransformPrivilegeChecker.checkPrivileges("update", securityContext, indexNameExpressionResolver, clusterState, client, updatedConfig, true, (ActionListener<Void>)checkPrivilegesListener);
        } else {
            checkPrivilegesListener.onResponse(null);
        }
    }

    private static void validateTransform(TransformConfig config, Client client, boolean deferValidation, TimeValue timeout, ActionListener<Map<String, String>> listener) {
        client.execute((ActionType)ValidateTransformAction.INSTANCE, (ActionRequest)new ValidateTransformAction.Request(config, deferValidation, timeout), ActionListener.wrap(response -> listener.onResponse((Object)response.getDestIndexMappings()), arg_0 -> listener.onFailure(arg_0)));
    }

    private static void updateTransformStateAndGetLastCheckpoint(String transformId, TransformConfigManager transformConfigManager, ActionListener<Long> listener) {
        transformConfigManager.getTransformStoredDoc(transformId, true, (ActionListener<Tuple<TransformStoredDoc, SeqNoPrimaryTermAndIndex>>)ActionListener.wrap(currentState -> {
            if (currentState == null) {
                listener.onResponse((Object)-1L);
                return;
            }
            long lastCheckpoint = ((TransformStoredDoc)currentState.v1()).getTransformState().getCheckpoint();
            if (((SeqNoPrimaryTermAndIndex)currentState.v2()).getIndex().equals(".transform-internal-007")) {
                listener.onResponse((Object)lastCheckpoint);
                return;
            }
            transformConfigManager.putOrUpdateTransformStoredDoc((TransformStoredDoc)currentState.v1(), (SeqNoPrimaryTermAndIndex)currentState.v2(), (ActionListener<SeqNoPrimaryTermAndIndex>)ActionListener.wrap(r -> listener.onResponse((Object)lastCheckpoint), e -> {
                if (ExceptionsHelper.unwrapCause((Throwable)e) instanceof VersionConflictEngineException) {
                    logger.trace("[{}] could not update transform state during update due to running transform", (Object)transformId);
                    listener.onResponse((Object)lastCheckpoint);
                } else {
                    logger.warn("[{}] failed to persist transform state during update.", (Object)transformId);
                    listener.onFailure(e);
                }
            }));
        }, arg_0 -> listener.onFailure(arg_0)));
    }

    private static void updateTransformCheckpoint(String transformId, long lastCheckpoint, TransformConfigManager transformConfigManager, ActionListener<Boolean> listener) {
        transformConfigManager.getTransformCheckpointForUpdate(transformId, lastCheckpoint, (ActionListener<Tuple<TransformCheckpoint, SeqNoPrimaryTermAndIndex>>)ActionListener.wrap(checkpointAndVersion -> {
            if (checkpointAndVersion == null || ((SeqNoPrimaryTermAndIndex)checkpointAndVersion.v2()).getIndex().equals(".transform-internal-007")) {
                listener.onResponse((Object)true);
                return;
            }
            transformConfigManager.putTransformCheckpoint((TransformCheckpoint)checkpointAndVersion.v1(), listener);
        }, arg_0 -> listener.onFailure(arg_0)));
    }

    private static void updateTransformConfiguration(Client client, TransformConfigManager transformConfigManager, IndexNameExpressionResolver indexNameExpressionResolver, TransformConfig config, Map<String, String> mappings, SeqNoPrimaryTermAndIndex seqNoPrimaryTermAndIndex, ClusterState clusterState, ActionListener<Void> listener) {
        ActionListener putTransformConfigurationListener = ActionListener.wrap(putTransformConfigurationResult -> transformConfigManager.deleteOldTransformConfigurations(config.getId(), (ActionListener<Boolean>)ActionListener.wrap(r -> {
            logger.trace("[{}] successfully deleted old transform configurations", (Object)config.getId());
            listener.onResponse(null);
        }, e -> {
            logger.warn(LoggerMessageFormat.format((String)"[{}] failed deleting old transform configurations.", (String)config.getId(), (Object[])new Object[0]), (Throwable)e);
            listener.onResponse(null);
        })), arg_0 -> listener.onFailure(arg_0));
        ActionListener createDestinationListener = ActionListener.wrap(createDestResponse -> transformConfigManager.updateTransformConfiguration(config, seqNoPrimaryTermAndIndex, (ActionListener<Boolean>)putTransformConfigurationListener), arg_0 -> listener.onFailure(arg_0));
        String[] dest = indexNameExpressionResolver.concreteIndexNames(clusterState, IndicesOptions.lenientExpandOpen(), new String[]{config.getDestination().getIndex()});
        String[] src = indexNameExpressionResolver.concreteIndexNames(clusterState, IndicesOptions.lenientExpandOpen(), true, config.getSource().getIndex());
        if (PersistentTasksCustomMetadata.getTaskWithId((ClusterState)clusterState, (String)config.getId()) != null && dest.length == 0 && src.length > 0) {
            TransformUpdater.createDestinationIndex(client, config, mappings, (ActionListener<Boolean>)createDestinationListener);
        } else {
            createDestinationListener.onResponse(null);
        }
    }

    private static void createDestinationIndex(Client client, TransformConfig config, Map<String, String> mappings, ActionListener<Boolean> listener) {
        TransformDestIndexSettings generatedDestIndexSettings = TransformIndex.createTransformDestIndexSettings(mappings, config.getId(), Clock.systemUTC());
        TransformIndex.createDestinationIndex(client, config, generatedDestIndexSettings, listener);
    }

    private TransformUpdater() {
    }

    public static final class UpdateResult {
        private final TransformConfig config;
        private final Status status;

        UpdateResult(TransformConfig config, Status status) {
            this.config = config;
            this.status = status;
        }

        public Status getStatus() {
            return this.status;
        }

        public TransformConfig getConfig() {
            return this.config;
        }

        public static enum Status {
            NONE,
            UPDATED,
            NEEDS_UPDATE;

        }
    }
}

