/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.transform.action;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.ElasticsearchStatusException;
import org.elasticsearch.ExceptionsHelper;
import org.elasticsearch.ResourceNotFoundException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionListenerResponseHandler;
import org.elasticsearch.action.FailedNodeException;
import org.elasticsearch.action.TaskOperationFailure;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.GroupedActionListener;
import org.elasticsearch.action.support.tasks.BaseTasksRequest;
import org.elasticsearch.action.support.tasks.TransportTasksAction;
import org.elasticsearch.client.Client;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.node.DiscoveryNodes;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.logging.LoggerMessageFormat;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.core.Tuple;
import org.elasticsearch.discovery.MasterNotDiscoveredException;
import org.elasticsearch.index.IndexNotFoundException;
import org.elasticsearch.persistent.PersistentTasksCustomMetadata;
import org.elasticsearch.persistent.PersistentTasksService;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportRequest;
import org.elasticsearch.transport.TransportResponseHandler;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.core.action.util.PageParams;
import org.elasticsearch.xpack.core.transform.TransformMessages;
import org.elasticsearch.xpack.core.transform.action.StopTransformAction;
import org.elasticsearch.xpack.core.transform.transforms.TransformConfig;
import org.elasticsearch.xpack.core.transform.transforms.TransformState;
import org.elasticsearch.xpack.core.transform.transforms.TransformTaskState;
import org.elasticsearch.xpack.transform.TransformServices;
import org.elasticsearch.xpack.transform.persistence.TransformConfigManager;
import org.elasticsearch.xpack.transform.transforms.TransformNodeAssignments;
import org.elasticsearch.xpack.transform.transforms.TransformNodes;
import org.elasticsearch.xpack.transform.transforms.TransformTask;

public class TransportStopTransformAction
extends TransportTasksAction<TransformTask, StopTransformAction.Request, StopTransformAction.Response, StopTransformAction.Response> {
    private static final Logger logger = LogManager.getLogger(TransportStopTransformAction.class);
    private final ThreadPool threadPool;
    private final TransformConfigManager transformConfigManager;
    private final PersistentTasksService persistentTasksService;

    @Inject
    public TransportStopTransformAction(TransportService transportService, ActionFilters actionFilters, ClusterService clusterService, ThreadPool threadPool, PersistentTasksService persistentTasksService, TransformServices transformServices, Client client) {
        this("cluster:admin/transform/stop", transportService, actionFilters, clusterService, threadPool, persistentTasksService, transformServices, client);
    }

    protected TransportStopTransformAction(String name, TransportService transportService, ActionFilters actionFilters, ClusterService clusterService, ThreadPool threadPool, PersistentTasksService persistentTasksService, TransformServices transformServices, Client client) {
        super(name, clusterService, transportService, actionFilters, StopTransformAction.Request::new, StopTransformAction.Response::new, StopTransformAction.Response::new, "same");
        this.threadPool = threadPool;
        this.transformConfigManager = transformServices.getConfigManager();
        this.persistentTasksService = persistentTasksService;
    }

    static void validateTaskState(ClusterState state, List<String> transformIds, boolean isForce) {
        PersistentTasksCustomMetadata tasks = (PersistentTasksCustomMetadata)state.metadata().custom("persistent_tasks");
        if (!isForce && tasks != null) {
            ArrayList<String> failedTasks = new ArrayList<String>();
            ArrayList<String> failedReasons = new ArrayList<String>();
            for (String transformId : transformIds) {
                PersistentTasksCustomMetadata.PersistentTask dfTask = tasks.getTask(transformId);
                if (dfTask == null || !(dfTask.getState() instanceof TransformState) || ((TransformState)dfTask.getState()).getTaskState() != TransformTaskState.FAILED) continue;
                failedTasks.add(transformId);
                failedReasons.add(((TransformState)dfTask.getState()).getReason());
            }
            if (!failedTasks.isEmpty()) {
                String msg = failedTasks.size() == 1 ? TransformMessages.getMessage((String)"Unable to stop transform [{0}] as it is in a failed state with reason [{1}]. Use force stop to stop the transform.", (Object[])new Object[]{failedTasks.get(0), failedReasons.get(0)}) : "Unable to stop transforms. The following transforms are in a failed state " + failedTasks + " with reasons " + failedReasons + ". Use force stop to stop the transforms.";
                throw new ElasticsearchStatusException(msg, RestStatus.CONFLICT, new Object[0]);
            }
        }
    }

    protected void doExecute(Task task, StopTransformAction.Request request, ActionListener<StopTransformAction.Response> listener) {
        ClusterState state = this.clusterService.state();
        DiscoveryNodes nodes = state.nodes();
        if (!nodes.isLocalNodeElectedMaster()) {
            if (nodes.getMasterNode() == null) {
                listener.onFailure((Exception)new MasterNotDiscoveredException());
            } else {
                this.transportService.sendRequest(nodes.getMasterNode(), this.actionName, (TransportRequest)request, (TransportResponseHandler)new ActionListenerResponseHandler(listener, StopTransformAction.Response::new));
            }
        } else {
            TransformNodes.warnIfNoTransformNodes(state);
            ActionListener<StopTransformAction.Response> finalListener = request.waitForCompletion() ? this.waitForStopListener(request, listener) : listener;
            this.transformConfigManager.expandTransformIds(request.getId(), new PageParams(0, 10000), request.isAllowNoMatch(), (ActionListener<Tuple<Long, Tuple<List<String>, List<TransformConfig>>>>)ActionListener.wrap(hitsAndIds -> {
                TransportStopTransformAction.validateTaskState(state, (List)((Tuple)hitsAndIds.v2()).v1(), request.isForce());
                request.setExpandedIds(new HashSet((Collection)((Tuple)hitsAndIds.v2()).v1()));
                TransformNodeAssignments transformNodeAssignments = TransformNodes.transformTaskNodes((List)((Tuple)hitsAndIds.v2()).v1(), state);
                ActionListener<StopTransformAction.Response> doExecuteListener = transformNodeAssignments.getWaitingForAssignment().size() > 0 ? this.cancelTransformTasksWithNoAssignment(finalListener, transformNodeAssignments) : finalListener;
                if (transformNodeAssignments.getExecutorNodes().size() > 0) {
                    request.setNodes(transformNodeAssignments.getExecutorNodes().toArray(new String[0]));
                    super.doExecute(task, (BaseTasksRequest)request, doExecuteListener);
                } else {
                    doExecuteListener.onResponse((Object)new StopTransformAction.Response(true));
                }
            }, e -> {
                if (e instanceof ResourceNotFoundException) {
                    TransformNodeAssignments transformNodeAssignments = TransformNodes.findPersistentTasks(request.getId(), state);
                    if (transformNodeAssignments.getAssigned().isEmpty() && transformNodeAssignments.getWaitingForAssignment().isEmpty()) {
                        listener.onFailure(e);
                    } else if (request.isForce()) {
                        ActionListener<StopTransformAction.Response> doExecuteListener = transformNodeAssignments.getWaitingForAssignment().size() > 0 ? this.cancelTransformTasksWithNoAssignment(finalListener, transformNodeAssignments) : finalListener;
                        if (transformNodeAssignments.getExecutorNodes().size() > 0) {
                            request.setExpandedIds(transformNodeAssignments.getAssigned());
                            request.setNodes(transformNodeAssignments.getExecutorNodes().toArray(new String[0]));
                            super.doExecute(task, (BaseTasksRequest)request, doExecuteListener);
                        } else {
                            doExecuteListener.onResponse((Object)new StopTransformAction.Response(true));
                        }
                    } else {
                        Set transformsWithoutConfig = Stream.concat(transformNodeAssignments.getAssigned().stream(), transformNodeAssignments.getWaitingForAssignment().stream()).collect(Collectors.toSet());
                        listener.onFailure((Exception)new ElasticsearchStatusException(TransformMessages.getMessage((String)"Detected transforms with no config [{0}]. Use force to stop/delete them.", (Object[])new Object[]{Strings.collectionToCommaDelimitedString(transformsWithoutConfig)}), RestStatus.CONFLICT, new Object[0]));
                    }
                } else {
                    listener.onFailure(e);
                }
            }));
        }
    }

    protected void taskOperation(StopTransformAction.Request request, TransformTask transformTask, ActionListener<StopTransformAction.Response> listener) {
        Set ids = request.getExpandedIds();
        if (ids == null) {
            listener.onFailure((Exception)new IllegalStateException("Request does not have expandedIds set"));
            return;
        }
        if (ids.contains(transformTask.getTransformId())) {
            this.threadPool.executor("generic").execute(() -> transformTask.setShouldStopAtCheckpoint(request.isWaitForCheckpoint(), (ActionListener<Void>)ActionListener.wrap(r -> {
                try {
                    transformTask.stop(request.isForce(), request.isWaitForCheckpoint());
                    listener.onResponse((Object)new StopTransformAction.Response(true));
                }
                catch (ElasticsearchException ex) {
                    listener.onFailure((Exception)((Object)ex));
                }
            }, e -> listener.onFailure((Exception)new ElasticsearchStatusException("Failed to update transform task [{}] state value should_stop_at_checkpoint from [{}] to [{}]", RestStatus.CONFLICT, (Throwable)e, new Object[]{transformTask.getTransformId(), transformTask.getState().shouldStopAtNextCheckpoint(), request.isWaitForCheckpoint()})))));
        } else {
            listener.onFailure((Exception)new RuntimeException("ID of transform task [" + transformTask.getTransformId() + "] does not match request's ID [" + request.getId() + "]"));
        }
    }

    protected StopTransformAction.Response newResponse(StopTransformAction.Request request, List<StopTransformAction.Response> tasks, List<TaskOperationFailure> taskOperationFailures, List<FailedNodeException> failedNodeExceptions) {
        if (!taskOperationFailures.isEmpty() || !failedNodeExceptions.isEmpty()) {
            return new StopTransformAction.Response(taskOperationFailures, failedNodeExceptions, false);
        }
        return new StopTransformAction.Response(tasks.stream().allMatch(StopTransformAction.Response::isAcknowledged));
    }

    private ActionListener<StopTransformAction.Response> waitForStopListener(StopTransformAction.Request request, ActionListener<StopTransformAction.Response> listener) {
        ActionListener onStopListener = ActionListener.wrap(waitResponse -> this.transformConfigManager.refresh((ActionListener<Boolean>)ActionListener.wrap(r -> listener.onResponse(waitResponse), e -> {
            if (!(ExceptionsHelper.unwrapCause((Throwable)e) instanceof IndexNotFoundException)) {
                logger.warn("Could not refresh state, state information might be outdated", (Throwable)e);
            }
            listener.onResponse(waitResponse);
        })), arg_0 -> listener.onFailure(arg_0));
        return ActionListener.wrap(response -> {
            if (!response.getTaskFailures().isEmpty() || !response.getNodeFailures().isEmpty()) {
                RestStatus status = TransportStopTransformAction.firstNotOKStatus(response.getTaskFailures(), response.getNodeFailures());
                listener.onFailure((Exception)TransportStopTransformAction.buildException(response.getTaskFailures(), response.getNodeFailures(), status));
                return;
            }
            this.threadPool.generic().execute(() -> this.waitForTransformStopped(request.getExpandedIds(), request.getTimeout(), request.isForce(), (ActionListener<StopTransformAction.Response>)onStopListener));
        }, arg_0 -> listener.onFailure(arg_0));
    }

    static ElasticsearchStatusException buildException(List<TaskOperationFailure> taskOperationFailures, List<ElasticsearchException> elasticsearchExceptions, RestStatus status) {
        List exceptions = Stream.concat(taskOperationFailures.stream().map(TaskOperationFailure::getCause), elasticsearchExceptions.stream()).collect(Collectors.toList());
        ElasticsearchStatusException elasticsearchStatusException = new ElasticsearchStatusException(((Exception)exceptions.get(0)).getMessage(), status, new Object[0]);
        for (int i = 1; i < exceptions.size(); ++i) {
            elasticsearchStatusException.addSuppressed((Throwable)exceptions.get(i));
        }
        return elasticsearchStatusException;
    }

    static RestStatus firstNotOKStatus(List<TaskOperationFailure> taskOperationFailures, List<ElasticsearchException> exceptions) {
        RestStatus status;
        block2: {
            ElasticsearchException exception;
            TaskOperationFailure taskOperationFailure;
            status = RestStatus.OK;
            Iterator<Object> iterator = taskOperationFailures.iterator();
            while (iterator.hasNext() && RestStatus.OK.equals((Object)(status = (taskOperationFailure = iterator.next()).getStatus()))) {
            }
            if (status != RestStatus.OK) break block2;
            iterator = exceptions.iterator();
            while (iterator.hasNext() && RestStatus.OK.equals((Object)(status = (exception = (ElasticsearchException)((Object)iterator.next())).status()))) {
            }
        }
        return status == RestStatus.OK ? RestStatus.INTERNAL_SERVER_ERROR : status;
    }

    private void waitForTransformStopped(Set<String> persistentTaskIds, TimeValue timeout, boolean force, ActionListener<StopTransformAction.Response> listener) {
        ConcurrentHashMap exceptions = new ConcurrentHashMap();
        this.persistentTasksService.waitForPersistentTasksCondition(persistentTasksCustomMetadata -> {
            if (persistentTasksCustomMetadata == null) {
                return true;
            }
            for (String persistentTaskId : persistentTaskIds) {
                PersistentTasksCustomMetadata.PersistentTask transformsTask = persistentTasksCustomMetadata.getTask(persistentTaskId);
                if (transformsTask == null || exceptions.containsKey(persistentTaskId)) continue;
                TransformState taskState = (TransformState)transformsTask.getState();
                if (!force && taskState != null && taskState.getTaskState() == TransformTaskState.FAILED) {
                    exceptions.put(persistentTaskId, new ElasticsearchStatusException(TransformMessages.getMessage((String)"Unable to stop transform [{0}] as it is in a failed state with reason [{1}]. Use force stop to stop the transform.", (Object[])new Object[]{persistentTaskId, taskState.getReason()}), RestStatus.CONFLICT, new Object[0]));
                    return persistentTasksCustomMetadata.tasks().stream().allMatch(p -> exceptions.containsKey(p.getId()));
                }
                return false;
            }
            return true;
        }, timeout, ActionListener.wrap(r -> {
            if (exceptions.isEmpty()) {
                listener.onResponse((Object)new StopTransformAction.Response(Boolean.TRUE.booleanValue()));
                return;
            }
            if (persistentTaskIds.size() == 1) {
                listener.onFailure((Exception)exceptions.get(persistentTaskIds.iterator().next()));
                return;
            }
            HashSet stoppedTasks = new HashSet(persistentTaskIds);
            stoppedTasks.removeAll(exceptions.keySet());
            String message = stoppedTasks.isEmpty() ? "Could not stop any of the tasks as all were failed. Use force stop to stop the transforms." : LoggerMessageFormat.format((String)"Successfully stopped [{}] transforms. Could not stop the transforms {} as they were failed. Use force stop to stop the transforms.", (Object[])new Object[]{stoppedTasks.size(), exceptions.keySet()});
            listener.onFailure((Exception)new ElasticsearchStatusException(message, RestStatus.CONFLICT, new Object[0]));
        }, e -> {
            if (e instanceof IllegalStateException && e.getMessage().startsWith("Timed out")) {
                PersistentTasksCustomMetadata persistentTasksCustomMetadata = (PersistentTasksCustomMetadata)this.clusterService.state().metadata().custom("persistent_tasks");
                if (persistentTasksCustomMetadata == null) {
                    listener.onResponse((Object)new StopTransformAction.Response(Boolean.TRUE.booleanValue()));
                    return;
                }
                HashSet<String> stillRunningTasks = new HashSet<String>();
                for (String persistentTaskId : persistentTaskIds) {
                    if (persistentTasksCustomMetadata.getTask(persistentTaskId) == null) continue;
                    stillRunningTasks.add(persistentTaskId);
                }
                if (stillRunningTasks.isEmpty()) {
                    listener.onResponse((Object)new StopTransformAction.Response(Boolean.TRUE.booleanValue()));
                    return;
                }
                StringBuilder message = new StringBuilder();
                if (persistentTaskIds.size() - stillRunningTasks.size() - exceptions.size() > 0) {
                    message.append("Successfully stopped [");
                    message.append(persistentTaskIds.size() - stillRunningTasks.size() - exceptions.size());
                    message.append("] transforms. ");
                }
                if (exceptions.size() > 0) {
                    message.append("Could not stop the transforms ");
                    message.append(exceptions.keySet());
                    message.append(" as they were failed. Use force stop to stop the transforms. ");
                }
                if (stillRunningTasks.size() > 0) {
                    message.append("Could not stop the transforms ");
                    message.append(stillRunningTasks);
                    message.append(" as they timed out [");
                    message.append(timeout.toString());
                    message.append("].");
                }
                listener.onFailure((Exception)new ElasticsearchStatusException(message.toString(), RestStatus.REQUEST_TIMEOUT, new Object[0]));
                return;
            }
            listener.onFailure(e);
        }));
    }

    private ActionListener<StopTransformAction.Response> cancelTransformTasksWithNoAssignment(ActionListener<StopTransformAction.Response> finalListener, TransformNodeAssignments transformNodeAssignments) {
        ActionListener doExecuteListener = ActionListener.wrap(response -> {
            GroupedActionListener groupedListener = new GroupedActionListener(ActionListener.wrap(r -> finalListener.onResponse(response), arg_0 -> ((ActionListener)finalListener).onFailure(arg_0)), transformNodeAssignments.getWaitingForAssignment().size());
            for (String unassignedTaskId : transformNodeAssignments.getWaitingForAssignment()) {
                this.persistentTasksService.sendRemoveRequest(unassignedTaskId, (ActionListener)groupedListener);
            }
        }, e -> {
            GroupedActionListener groupedListener = new GroupedActionListener(ActionListener.wrap(r -> finalListener.onFailure(e), arg_0 -> ((ActionListener)finalListener).onFailure(arg_0)), transformNodeAssignments.getWaitingForAssignment().size());
            for (String unassignedTaskId : transformNodeAssignments.getWaitingForAssignment()) {
                this.persistentTasksService.sendRemoveRequest(unassignedTaskId, (ActionListener)groupedListener);
            }
        });
        return doExecuteListener;
    }
}

