/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.unboundidds.tasks;

import com.unboundid.ldap.sdk.Attribute;
import com.unboundid.ldap.sdk.Entry;
import com.unboundid.ldap.sdk.unboundidds.tasks.FailedDependencyAction;
import com.unboundid.ldap.sdk.unboundidds.tasks.Task;
import com.unboundid.ldap.sdk.unboundidds.tasks.TaskException;
import com.unboundid.ldap.sdk.unboundidds.tasks.TaskMessages;
import com.unboundid.ldap.sdk.unboundidds.tasks.TaskProperty;
import com.unboundid.util.NotMutable;
import com.unboundid.util.NotNull;
import com.unboundid.util.Nullable;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import com.unboundid.util.Validator;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

@NotMutable
@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class DumpDBDetailsTask
extends Task {
    @NotNull
    static final String DUMP_DB_DETAILS_TASK_CLASS = "com.unboundid.directory.server.tasks.DumpDBDetailsTask";
    @NotNull
    private static final String ATTR_BACKEND_ID = "ds-task-dump-db-backend-id";
    @NotNull
    private static final String OC_DUMP_DB_DETAILS_TASK = "ds-task-dump-db";
    @NotNull
    private static final TaskProperty PROPERTY_BACKEND_ID = new TaskProperty("ds-task-dump-db-backend-id", TaskMessages.INFO_DUMP_DB_DISPLAY_NAME_BACKEND_ID.get(), TaskMessages.INFO_DUMP_DB_DESCRIPTION_BACKEND_ID.get(), String.class, true, false, false);
    private static final long serialVersionUID = 7267871080385864231L;
    @NotNull
    private final String backendID;

    public DumpDBDetailsTask() {
        this.backendID = null;
    }

    public DumpDBDetailsTask(@Nullable String taskID, @NotNull String backendID) {
        this(taskID, backendID, null, null, null, null, null);
    }

    public DumpDBDetailsTask(@Nullable String taskID, @NotNull String backendID, @Nullable Date scheduledStartTime, @Nullable List<String> dependencyIDs, @Nullable FailedDependencyAction failedDependencyAction, @Nullable List<String> notifyOnCompletion, @Nullable List<String> notifyOnError) {
        this(taskID, backendID, scheduledStartTime, dependencyIDs, failedDependencyAction, null, notifyOnCompletion, null, notifyOnError, null, null, null);
    }

    public DumpDBDetailsTask(@Nullable String taskID, @NotNull String backendID, @Nullable Date scheduledStartTime, @Nullable List<String> dependencyIDs, @Nullable FailedDependencyAction failedDependencyAction, @Nullable List<String> notifyOnStart, @Nullable List<String> notifyOnCompletion, @Nullable List<String> notifyOnSuccess, @Nullable List<String> notifyOnError, @Nullable Boolean alertOnStart, @Nullable Boolean alertOnSuccess, @Nullable Boolean alertOnError) {
        super(taskID, DUMP_DB_DETAILS_TASK_CLASS, scheduledStartTime, dependencyIDs, failedDependencyAction, notifyOnStart, notifyOnCompletion, notifyOnSuccess, notifyOnError, alertOnStart, alertOnSuccess, alertOnError);
        Validator.ensureNotNull(backendID);
        this.backendID = backendID;
    }

    public DumpDBDetailsTask(@NotNull Entry entry) throws TaskException {
        super(entry);
        this.backendID = entry.getAttributeValue(ATTR_BACKEND_ID);
        if (this.backendID == null) {
            throw new TaskException(TaskMessages.ERR_DUMP_DB_ENTRY_MISSING_BACKEND_ID.get(this.getTaskEntryDN(), ATTR_BACKEND_ID));
        }
    }

    public DumpDBDetailsTask(@NotNull Map<TaskProperty, List<Object>> properties) throws TaskException {
        super(DUMP_DB_DETAILS_TASK_CLASS, properties);
        String id = null;
        for (Map.Entry<TaskProperty, List<Object>> entry : properties.entrySet()) {
            TaskProperty p = entry.getKey();
            String attrName = p.getAttributeName();
            List<Object> values = entry.getValue();
            if (!attrName.equalsIgnoreCase(ATTR_BACKEND_ID)) continue;
            id = DumpDBDetailsTask.parseString(p, values, id);
        }
        if (id == null) {
            throw new TaskException(TaskMessages.ERR_DUMP_DB_ENTRY_MISSING_BACKEND_ID.get(this.getTaskEntryDN(), ATTR_BACKEND_ID));
        }
        this.backendID = id;
    }

    @Override
    @NotNull
    public String getTaskName() {
        return TaskMessages.INFO_TASK_NAME_DUMP_DB.get();
    }

    @Override
    @NotNull
    public String getTaskDescription() {
        return TaskMessages.INFO_TASK_DESCRIPTION_DUMP_DB.get();
    }

    @NotNull
    public String getBackendID() {
        return this.backendID;
    }

    @Override
    @NotNull
    protected List<String> getAdditionalObjectClasses() {
        return Collections.singletonList(OC_DUMP_DB_DETAILS_TASK);
    }

    @Override
    @NotNull
    protected List<Attribute> getAdditionalAttributes() {
        return Collections.singletonList(new Attribute(ATTR_BACKEND_ID, this.backendID));
    }

    @Override
    @NotNull
    public List<TaskProperty> getTaskSpecificProperties() {
        return Collections.singletonList(PROPERTY_BACKEND_ID);
    }

    @Override
    @NotNull
    public Map<TaskProperty, List<Object>> getTaskPropertyValues() {
        LinkedHashMap<TaskProperty, List<Object>> props = new LinkedHashMap<TaskProperty, List<Object>>(StaticUtils.computeMapCapacity(1));
        props.put(PROPERTY_BACKEND_ID, Collections.singletonList(this.backendID));
        props.putAll(super.getTaskPropertyValues());
        return Collections.unmodifiableMap(props);
    }
}

