/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml;

import java.util.Objects;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.cluster.ClusterChangedEvent;
import org.elasticsearch.cluster.ClusterStateListener;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.node.DiscoveryNodes;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.Strings;
import org.elasticsearch.persistent.PersistentTasksCustomMetadata;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.xpack.core.ml.action.OpenJobAction;
import org.elasticsearch.xpack.core.ml.action.StartDataFrameAnalyticsAction;
import org.elasticsearch.xpack.core.ml.action.StartDatafeedAction;
import org.elasticsearch.xpack.ml.notifications.AnomalyDetectionAuditor;
import org.elasticsearch.xpack.ml.notifications.DataFrameAnalyticsAuditor;

public class MlAssignmentNotifier
implements ClusterStateListener {
    private static final Logger logger = LogManager.getLogger(MlAssignmentNotifier.class);
    private final AnomalyDetectionAuditor anomalyDetectionAuditor;
    private final DataFrameAnalyticsAuditor dataFrameAnalyticsAuditor;
    private final ThreadPool threadPool;

    MlAssignmentNotifier(AnomalyDetectionAuditor anomalyDetectionAuditor, DataFrameAnalyticsAuditor dataFrameAnalyticsAuditor, ThreadPool threadPool, ClusterService clusterService) {
        this.anomalyDetectionAuditor = anomalyDetectionAuditor;
        this.dataFrameAnalyticsAuditor = dataFrameAnalyticsAuditor;
        this.threadPool = threadPool;
        clusterService.addListener((ClusterStateListener)this);
    }

    private String executorName() {
        return "generic";
    }

    public void clusterChanged(ClusterChangedEvent event) {
        if (!event.localNodeMaster()) {
            return;
        }
        if (!event.metadataChanged()) {
            return;
        }
        this.threadPool.executor(this.executorName()).execute(() -> this.auditChangesToMlTasks(event));
    }

    private void auditChangesToMlTasks(ClusterChangedEvent event) {
        PersistentTasksCustomMetadata currentTasks;
        PersistentTasksCustomMetadata previousTasks = (PersistentTasksCustomMetadata)event.previousState().getMetadata().custom("persistent_tasks");
        if (Objects.equals(previousTasks, currentTasks = (PersistentTasksCustomMetadata)event.state().getMetadata().custom("persistent_tasks"))) {
            return;
        }
        this.auditMlTasks(event.previousState().nodes(), event.state().nodes(), previousTasks, currentTasks, false);
    }

    public void auditUnassignedMlTasks(DiscoveryNodes nodes, PersistentTasksCustomMetadata tasks) {
        this.auditMlTasks(nodes, nodes, tasks, tasks, true);
    }

    private void auditMlTasks(DiscoveryNodes previousNodes, DiscoveryNodes currentNodes, PersistentTasksCustomMetadata previousTasks, PersistentTasksCustomMetadata currentTasks, boolean alwaysAuditUnassigned) {
        for (PersistentTasksCustomMetadata.PersistentTask currentTask : currentTasks.tasks()) {
            String nodeName;
            boolean wasTaskAssigned;
            boolean isTaskAssigned;
            PersistentTasksCustomMetadata.Assignment currentAssignment = currentTask.getAssignment();
            PersistentTasksCustomMetadata.PersistentTask previousTask = previousTasks != null ? previousTasks.getTask(currentTask.getId()) : null;
            PersistentTasksCustomMetadata.Assignment previousAssignment = previousTask != null ? previousTask.getAssignment() : null;
            boolean bl = isTaskAssigned = currentAssignment.getExecutorNode() != null;
            if (Objects.equals(currentAssignment, previousAssignment) && (isTaskAssigned || !alwaysAuditUnassigned)) continue;
            boolean bl2 = wasTaskAssigned = previousAssignment != null && previousAssignment.getExecutorNode() != null;
            if ("xpack/ml/job".equals(currentTask.getTaskName())) {
                String jobId = ((OpenJobAction.JobParams)currentTask.getParams()).getJobId();
                if (isTaskAssigned) {
                    nodeName = MlAssignmentNotifier.nodeName(currentNodes, currentAssignment.getExecutorNode());
                    this.anomalyDetectionAuditor.info(jobId, "Opening job on node [" + nodeName + "]");
                    continue;
                }
                if (alwaysAuditUnassigned) {
                    this.anomalyDetectionAuditor.warning(jobId, "No node found to open job. Reasons [" + currentAssignment.getExplanation() + "]");
                    continue;
                }
                if (!wasTaskAssigned) continue;
                nodeName = MlAssignmentNotifier.nodeName(previousNodes, previousAssignment.getExecutorNode());
                this.anomalyDetectionAuditor.info(jobId, "Job unassigned from node [" + nodeName + "]");
                continue;
            }
            if ("xpack/ml/datafeed".equals(currentTask.getTaskName())) {
                String nodeName2;
                StartDatafeedAction.DatafeedParams datafeedParams = (StartDatafeedAction.DatafeedParams)currentTask.getParams();
                String jobId = datafeedParams.getJobId();
                if (jobId == null) continue;
                if (isTaskAssigned) {
                    nodeName2 = MlAssignmentNotifier.nodeName(currentNodes, currentAssignment.getExecutorNode());
                    this.anomalyDetectionAuditor.info(jobId, "Starting datafeed [" + datafeedParams.getDatafeedId() + "] on node [" + nodeName2 + "]");
                    continue;
                }
                if (alwaysAuditUnassigned) {
                    this.anomalyDetectionAuditor.warning(jobId, "No node found to start datafeed [" + datafeedParams.getDatafeedId() + "]. Reasons [" + currentAssignment.getExplanation() + "]");
                    continue;
                }
                if (wasTaskAssigned) {
                    nodeName2 = MlAssignmentNotifier.nodeName(previousNodes, previousAssignment.getExecutorNode());
                    this.anomalyDetectionAuditor.info(jobId, "Datafeed [" + datafeedParams.getDatafeedId() + "] unassigned from node [" + nodeName2 + "]");
                    continue;
                }
                logger.warn("[{}] No node found to start datafeed [{}]. Reasons [{}]", (Object)jobId, (Object)datafeedParams.getDatafeedId(), (Object)currentAssignment.getExplanation());
                continue;
            }
            if (!"xpack/ml/data_frame/analytics".equals(currentTask.getTaskName())) continue;
            String id = ((StartDataFrameAnalyticsAction.TaskParams)currentTask.getParams()).getId();
            if (isTaskAssigned) {
                nodeName = MlAssignmentNotifier.nodeName(currentNodes, currentAssignment.getExecutorNode());
                this.dataFrameAnalyticsAuditor.info(id, "Starting analytics on node [" + nodeName + "]");
                continue;
            }
            if (alwaysAuditUnassigned) {
                this.dataFrameAnalyticsAuditor.warning(id, "No node found to start analytics. Reasons [" + currentAssignment.getExplanation() + "]");
                continue;
            }
            if (!wasTaskAssigned) continue;
            nodeName = MlAssignmentNotifier.nodeName(previousNodes, previousAssignment.getExecutorNode());
            this.anomalyDetectionAuditor.info(id, "Analytics unassigned from node [" + nodeName + "]");
        }
    }

    static String nodeName(DiscoveryNodes nodes, String nodeId) {
        DiscoveryNode node = nodes.get(nodeId);
        if (node != null && Strings.hasLength((String)node.getName())) {
            return node.getName();
        }
        return nodeId;
    }
}

