/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml;

import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.elasticsearch.Version;
import org.elasticsearch.cluster.ClusterChangedEvent;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ClusterStateListener;
import org.elasticsearch.gateway.GatewayService;
import org.elasticsearch.threadpool.ThreadPool;

public class MlAutoUpdateService
implements ClusterStateListener {
    private static final Logger logger = LogManager.getLogger(MlAutoUpdateService.class);
    private final List<UpdateAction> updateActions;
    private final Set<String> currentlyUpdating;
    private final Set<String> completedUpdates;
    private final ThreadPool threadPool;

    public MlAutoUpdateService(ThreadPool threadPool, List<UpdateAction> updateActions) {
        this.updateActions = updateActions;
        this.completedUpdates = ConcurrentHashMap.newKeySet();
        this.currentlyUpdating = ConcurrentHashMap.newKeySet();
        this.threadPool = threadPool;
    }

    public void clusterChanged(ClusterChangedEvent event) {
        if (event.state().blocks().hasGlobalBlock(GatewayService.STATE_NOT_RECOVERED_BLOCK)) {
            return;
        }
        if (!event.localNodeMaster()) {
            return;
        }
        Version minNodeVersion = event.state().getNodes().getMinNodeVersion();
        List toRun = this.updateActions.stream().filter(action -> action.isMinNodeVersionSupported(minNodeVersion)).filter(action -> !this.completedUpdates.contains(action.getName())).filter(action -> action.isAbleToRun(event.state())).filter(action -> this.currentlyUpdating.add(action.getName())).collect(Collectors.toList());
        this.threadPool.executor("ml_utility").execute(() -> toRun.forEach(this::runUpdate));
    }

    private void runUpdate(UpdateAction action) {
        try {
            logger.debug(() -> new ParameterizedMessage("[{}] starting executing update action", (Object)action.getName()));
            action.runUpdate();
            this.completedUpdates.add(action.getName());
            logger.debug(() -> new ParameterizedMessage("[{}] succeeded executing update action", (Object)action.getName()));
        }
        catch (Exception ex) {
            logger.warn((Message)new ParameterizedMessage("[{}] failure executing update action", (Object)action.getName()), (Throwable)ex);
        }
        finally {
            this.currentlyUpdating.remove(action.getName());
            logger.debug(() -> new ParameterizedMessage("[{}] no longer executing update action", (Object)action.getName()));
        }
    }

    public static interface UpdateAction {
        public boolean isMinNodeVersionSupported(Version var1);

        public boolean isAbleToRun(ClusterState var1);

        public String getName();

        public void runUpdate();
    }
}

