/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.aggs.categorization;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.lucene.util.Accountable;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.RamUsageEstimator;
import org.elasticsearch.search.aggregations.InternalAggregations;
import org.elasticsearch.xpack.ml.aggs.categorization.CategorizationBytesRefHash;
import org.elasticsearch.xpack.ml.aggs.categorization.InternalCategorizationAggregation;
import org.elasticsearch.xpack.ml.aggs.categorization.TextCategorization;
import org.elasticsearch.xpack.ml.aggs.categorization.TreeNode;

public class CategorizationTokenTree
implements Accountable {
    private static final long SHALLOW_SIZE = RamUsageEstimator.shallowSizeOfInstance(CategorizationTokenTree.class);
    private final int maxMatchTokens;
    private final int maxUniqueTokens;
    private final int similarityThreshold;
    private long idGenerator;
    private final Map<Integer, TreeNode> root = new HashMap<Integer, TreeNode>();
    private long sizeInBytes;

    public CategorizationTokenTree(int maxUniqueTokens, int maxMatchTokens, int similarityThreshold) {
        assert (maxUniqueTokens > 0 && maxMatchTokens >= 0);
        this.maxUniqueTokens = maxUniqueTokens;
        this.maxMatchTokens = maxMatchTokens;
        this.similarityThreshold = similarityThreshold;
        this.sizeInBytes = SHALLOW_SIZE;
    }

    public List<InternalCategorizationAggregation.Bucket> toIntermediateBuckets(CategorizationBytesRefHash hash) {
        return this.root.values().stream().flatMap(c -> c.getAllChildrenTextCategorizations().stream()).map(lg -> {
            int[] categoryTokenIds = lg.getCategorization();
            BytesRef[] bytesRefs = new BytesRef[categoryTokenIds.length];
            for (int i = 0; i < categoryTokenIds.length; ++i) {
                bytesRefs[i] = hash.getDeep(categoryTokenIds[i]);
            }
            InternalCategorizationAggregation.Bucket bucket = new InternalCategorizationAggregation.Bucket(new InternalCategorizationAggregation.BucketKey(bytesRefs), lg.getCount(), InternalAggregations.EMPTY);
            bucket.bucketOrd = lg.bucketOrd;
            return bucket;
        }).collect(Collectors.toList());
    }

    void mergeSmallestChildren() {
        this.root.values().forEach(TreeNode::collapseTinyChildren);
    }

    public Optional<TextCategorization> parseTokensConst(int[] tokenIds) {
        TreeNode currentNode = this.root.get(tokenIds.length);
        if (currentNode == null) {
            return Optional.empty();
        }
        return Optional.ofNullable(currentNode.getCategorization(tokenIds));
    }

    public TextCategorization parseTokens(int[] tokenIds, long docCount) {
        TreeNode currentNode = this.root.get(tokenIds.length);
        if (currentNode == null) {
            currentNode = this.newNode(docCount, 0, tokenIds);
            this.incSize(currentNode.ramBytesUsed() + RamUsageEstimator.HASHTABLE_RAM_BYTES_PER_ENTRY + (long)RamUsageEstimator.NUM_BYTES_OBJECT_REF);
            this.root.put(tokenIds.length, currentNode);
        } else {
            currentNode.incCount(docCount);
        }
        return currentNode.addText(tokenIds, docCount, this);
    }

    TreeNode newNode(long docCount, int tokenPos, int[] tokenIds) {
        return tokenPos < this.maxMatchTokens - 1 && tokenPos < tokenIds.length ? new TreeNode.InnerTreeNode(docCount, tokenPos, this.maxUniqueTokens) : new TreeNode.LeafTreeNode(docCount, this.similarityThreshold);
    }

    TextCategorization newCategorization(long docCount, int[] tokenIds) {
        return new TextCategorization(tokenIds, docCount, this.idGenerator++);
    }

    void incSize(long size) {
        this.sizeInBytes += size;
    }

    public long ramBytesUsed() {
        return this.sizeInBytes;
    }
}

