/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.datafeed;

import java.util.Objects;
import java.util.function.Consumer;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.xpack.core.ml.datafeed.DatafeedConfig;
import org.elasticsearch.xpack.core.ml.datafeed.DatafeedTimingStats;
import org.elasticsearch.xpack.core.ml.job.config.Job;
import org.elasticsearch.xpack.ml.datafeed.DatafeedContext;
import org.elasticsearch.xpack.ml.datafeed.persistence.DatafeedConfigProvider;
import org.elasticsearch.xpack.ml.job.persistence.JobConfigProvider;
import org.elasticsearch.xpack.ml.job.persistence.JobResultsProvider;
import org.elasticsearch.xpack.ml.job.persistence.RestartTimeInfo;

public class DatafeedContextProvider {
    private final JobConfigProvider jobConfigProvider;
    private final DatafeedConfigProvider datafeedConfigProvider;
    private final JobResultsProvider resultsProvider;

    public DatafeedContextProvider(JobConfigProvider jobConfigProvider, DatafeedConfigProvider datafeedConfigProvider, JobResultsProvider jobResultsProvider) {
        this.jobConfigProvider = Objects.requireNonNull(jobConfigProvider);
        this.datafeedConfigProvider = Objects.requireNonNull(datafeedConfigProvider);
        this.resultsProvider = Objects.requireNonNull(jobResultsProvider);
    }

    public void buildDatafeedContext(String datafeedId, ActionListener<DatafeedContext> listener) {
        DatafeedContext.Builder context = DatafeedContext.builder();
        Consumer<DatafeedTimingStats> timingStatsListener = timingStats -> {
            context.setTimingStats((DatafeedTimingStats)timingStats);
            listener.onResponse((Object)context.build());
        };
        ActionListener restartTimeInfoListener = ActionListener.wrap(restartTimeInfo -> {
            context.setRestartTimeInfo((RestartTimeInfo)restartTimeInfo);
            this.resultsProvider.datafeedTimingStats(context.getJob().getId(), timingStatsListener, arg_0 -> ((ActionListener)listener).onFailure(arg_0));
        }, arg_0 -> listener.onFailure(arg_0));
        ActionListener jobConfigListener = ActionListener.wrap(jobBuilder -> {
            context.setJob(jobBuilder.build());
            this.resultsProvider.getRestartTimeInfo(jobBuilder.getId(), (ActionListener<RestartTimeInfo>)restartTimeInfoListener);
        }, arg_0 -> listener.onFailure(arg_0));
        ActionListener datafeedListener = ActionListener.wrap(datafeedConfigBuilder -> {
            DatafeedConfig datafeedConfig = datafeedConfigBuilder.build();
            context.setDatafeedConfig(datafeedConfig);
            this.jobConfigProvider.getJob(datafeedConfig.getJobId(), (ActionListener<Job.Builder>)jobConfigListener);
        }, arg_0 -> listener.onFailure(arg_0));
        this.datafeedConfigProvider.getDatafeedConfig(datafeedId, (ActionListener<DatafeedConfig.Builder>)datafeedListener);
    }
}

