/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.dataframe.stats;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.elasticsearch.xpack.core.ml.utils.PhaseProgress;

public class ProgressTracker {
    public static final String REINDEXING = "reindexing";
    public static final String LOADING_DATA = "loading_data";
    public static final String WRITING_RESULTS = "writing_results";
    public static final String INFERENCE = "inference";
    private final String[] phasesInOrder;
    private final Map<String, Integer> progressPercentPerPhase;

    public static ProgressTracker fromZeroes(List<String> analysisProgressPhases, boolean hasInferencePhase) {
        ArrayList<PhaseProgress> phases = new ArrayList<PhaseProgress>(3 + analysisProgressPhases.size() + (hasInferencePhase ? 1 : 0));
        phases.add(new PhaseProgress(REINDEXING, 0));
        phases.add(new PhaseProgress(LOADING_DATA, 0));
        analysisProgressPhases.forEach(analysisPhase -> phases.add(new PhaseProgress(analysisPhase, 0)));
        phases.add(new PhaseProgress(WRITING_RESULTS, 0));
        if (hasInferencePhase) {
            phases.add(new PhaseProgress(INFERENCE, 0));
        }
        return new ProgressTracker(phases);
    }

    public ProgressTracker(List<PhaseProgress> phaseProgresses) {
        this.phasesInOrder = new String[phaseProgresses.size()];
        this.progressPercentPerPhase = new ConcurrentHashMap<String, Integer>();
        for (int i = 0; i < phaseProgresses.size(); ++i) {
            PhaseProgress phaseProgress = phaseProgresses.get(i);
            this.phasesInOrder[i] = phaseProgress.getPhase();
            this.progressPercentPerPhase.put(phaseProgress.getPhase(), phaseProgress.getProgressPercent());
        }
        assert (this.progressPercentPerPhase.containsKey(REINDEXING));
        assert (this.progressPercentPerPhase.containsKey(LOADING_DATA));
        assert (this.progressPercentPerPhase.containsKey(WRITING_RESULTS));
        assert (!this.progressPercentPerPhase.containsKey(INFERENCE) || INFERENCE.equals(this.phasesInOrder[this.phasesInOrder.length - 1]));
    }

    public void updateReindexingProgress(int progressPercent) {
        this.updatePhase(REINDEXING, progressPercent);
    }

    public int getReindexingProgressPercent() {
        return this.progressPercentPerPhase.get(REINDEXING);
    }

    public void updateLoadingDataProgress(int progressPercent) {
        this.updatePhase(LOADING_DATA, progressPercent);
    }

    public int getLoadingDataProgressPercent() {
        return this.progressPercentPerPhase.get(LOADING_DATA);
    }

    public void updateWritingResultsProgress(int progressPercent) {
        this.updatePhase(WRITING_RESULTS, progressPercent);
    }

    public int getWritingResultsProgressPercent() {
        return this.progressPercentPerPhase.get(WRITING_RESULTS);
    }

    public void updateInferenceProgress(int progressPercent) {
        this.updatePhase(INFERENCE, progressPercent);
    }

    public int getInferenceProgressPercent() {
        return this.progressPercentPerPhase.getOrDefault(INFERENCE, 0);
    }

    public void updatePhase(PhaseProgress phase) {
        this.updatePhase(phase.getPhase(), phase.getProgressPercent());
    }

    private void updatePhase(String phase, int progress) {
        this.progressPercentPerPhase.computeIfPresent(phase, (k, v) -> Math.max(v, progress));
    }

    public void resetForInference() {
        for (Map.Entry<String, Integer> phaseProgress : this.progressPercentPerPhase.entrySet()) {
            if (phaseProgress.getKey().equals(INFERENCE)) {
                this.progressPercentPerPhase.put(phaseProgress.getKey(), 0);
                continue;
            }
            this.progressPercentPerPhase.put(phaseProgress.getKey(), 100);
        }
    }

    public boolean areAllPhasesExceptInferenceComplete() {
        for (Map.Entry<String, Integer> phaseProgress : this.progressPercentPerPhase.entrySet()) {
            if (phaseProgress.getKey().equals(INFERENCE) || phaseProgress.getValue() >= 100) continue;
            return false;
        }
        return true;
    }

    public List<PhaseProgress> report() {
        return Arrays.stream(this.phasesInOrder).map(phase -> new PhaseProgress(phase, this.progressPercentPerPhase.get(phase).intValue())).collect(Collectors.toUnmodifiableList());
    }
}

