/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.rest.cat;

import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.client.node.NodeClient;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.Table;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.RestChannel;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.RestResponse;
import org.elasticsearch.rest.action.RestActionListener;
import org.elasticsearch.rest.action.RestResponseListener;
import org.elasticsearch.rest.action.cat.AbstractCatAction;
import org.elasticsearch.rest.action.cat.RestTable;
import org.elasticsearch.xpack.core.common.table.TableColumnAttributeBuilder;
import org.elasticsearch.xpack.core.ml.action.GetDataFrameAnalyticsAction;
import org.elasticsearch.xpack.core.ml.action.GetDataFrameAnalyticsStatsAction;
import org.elasticsearch.xpack.core.ml.dataframe.DataFrameAnalyticsConfig;
import org.elasticsearch.xpack.core.ml.utils.PhaseProgress;

public class RestCatDataFrameAnalyticsAction
extends AbstractCatAction {
    public List<RestHandler.Route> routes() {
        return List.of(new RestHandler.Route(RestRequest.Method.GET, "_cat/ml/data_frame/analytics/{" + DataFrameAnalyticsConfig.ID + "}"), new RestHandler.Route(RestRequest.Method.GET, "_cat/ml/data_frame/analytics"));
    }

    public String getName() {
        return "cat_ml_get_data_frame_analytics_action";
    }

    protected BaseRestHandler.RestChannelConsumer doCatRequest(RestRequest restRequest, final NodeClient client) {
        String dataFrameAnalyticsId = restRequest.param(DataFrameAnalyticsConfig.ID.getPreferredName());
        if (Strings.isNullOrEmpty((String)dataFrameAnalyticsId)) {
            dataFrameAnalyticsId = "_all";
        }
        GetDataFrameAnalyticsAction.Request getRequest = new GetDataFrameAnalyticsAction.Request(dataFrameAnalyticsId);
        getRequest.setAllowNoResources(restRequest.paramAsBoolean(GetDataFrameAnalyticsAction.Request.ALLOW_NO_MATCH.getPreferredName(), getRequest.isAllowNoResources()));
        final GetDataFrameAnalyticsStatsAction.Request getStatsRequest = new GetDataFrameAnalyticsStatsAction.Request(dataFrameAnalyticsId);
        getStatsRequest.setAllowNoMatch(true);
        return channel -> client.execute((ActionType)GetDataFrameAnalyticsAction.INSTANCE, (ActionRequest)getRequest, (ActionListener)new RestActionListener<GetDataFrameAnalyticsAction.Response>(channel){

            public void processResponse(final GetDataFrameAnalyticsAction.Response getResponse) {
                client.execute((ActionType)GetDataFrameAnalyticsStatsAction.INSTANCE, (ActionRequest)getStatsRequest, (ActionListener)new RestResponseListener<GetDataFrameAnalyticsStatsAction.Response>(this.channel){

                    public RestResponse buildResponse(GetDataFrameAnalyticsStatsAction.Response getStatsResponse) throws Exception {
                        return RestTable.buildResponse((Table)RestCatDataFrameAnalyticsAction.buildTable(getResponse, getStatsResponse), (RestChannel)this.channel);
                    }
                });
            }
        });
    }

    protected void documentation(StringBuilder sb) {
        sb.append("/_cat/ml/data_frame/analytics\n");
        sb.append("/_cat/ml/data_frame/analytics/{").append(DataFrameAnalyticsConfig.ID.getPreferredName()).append("}\n");
    }

    protected Table getTableWithHeader(RestRequest unused) {
        return RestCatDataFrameAnalyticsAction.getTableWithHeader();
    }

    private static Table getTableWithHeader() {
        return new Table().startHeaders().addCell((Object)"id", TableColumnAttributeBuilder.builder((String)"the id").build()).addCell((Object)"type", TableColumnAttributeBuilder.builder((String)"analysis type").setAliases(new String[]{"t"}).build()).addCell((Object)"create_time", TableColumnAttributeBuilder.builder((String)"job creation time").setAliases(new String[]{"ct", "createTime"}).build()).addCell((Object)"version", TableColumnAttributeBuilder.builder((String)"the version of Elasticsearch when the analytics was created", (boolean)false).setAliases(new String[]{"v"}).build()).addCell((Object)"source_index", TableColumnAttributeBuilder.builder((String)"source index", (boolean)false).setAliases(new String[]{"si", "sourceIndex"}).build()).addCell((Object)"dest_index", TableColumnAttributeBuilder.builder((String)"destination index", (boolean)false).setAliases(new String[]{"di", "destIndex"}).build()).addCell((Object)"description", TableColumnAttributeBuilder.builder((String)"description", (boolean)false).setAliases(new String[]{"d"}).build()).addCell((Object)"model_memory_limit", TableColumnAttributeBuilder.builder((String)"model memory limit", (boolean)false).setAliases(new String[]{"mml", "modelMemoryLimit"}).build()).addCell((Object)"state", TableColumnAttributeBuilder.builder((String)"job state").setAliases(new String[]{"s"}).setTextAlignment(TableColumnAttributeBuilder.TextAlign.RIGHT).build()).addCell((Object)"failure_reason", TableColumnAttributeBuilder.builder((String)"failure reason", (boolean)false).setAliases(new String[]{"fr", "failureReason"}).build()).addCell((Object)"progress", TableColumnAttributeBuilder.builder((String)"progress", (boolean)false).setAliases(new String[]{"p"}).build()).addCell((Object)"assignment_explanation", TableColumnAttributeBuilder.builder((String)"why the job is or is not assigned to a node", (boolean)false).setAliases(new String[]{"ae", "assignmentExplanation"}).build()).addCell((Object)"node.id", TableColumnAttributeBuilder.builder((String)"id of the assigned node", (boolean)false).setAliases(new String[]{"ni", "nodeId"}).build()).addCell((Object)"node.name", TableColumnAttributeBuilder.builder((String)"name of the assigned node", (boolean)false).setAliases(new String[]{"nn", "nodeName"}).build()).addCell((Object)"node.ephemeral_id", TableColumnAttributeBuilder.builder((String)"ephemeral id of the assigned node", (boolean)false).setAliases(new String[]{"ne", "nodeEphemeralId"}).build()).addCell((Object)"node.address", TableColumnAttributeBuilder.builder((String)"network address of the assigned node", (boolean)false).setAliases(new String[]{"na", "nodeAddress"}).build()).endHeaders();
    }

    private static Table buildTable(GetDataFrameAnalyticsAction.Response getResponse, GetDataFrameAnalyticsStatsAction.Response getStatsResponse) {
        Map statsById = getStatsResponse.getResponse().results().stream().collect(Collectors.toMap(GetDataFrameAnalyticsStatsAction.Response.Stats::getId, Function.identity()));
        Table table = RestCatDataFrameAnalyticsAction.getTableWithHeader();
        for (DataFrameAnalyticsConfig config : getResponse.getResources().results()) {
            GetDataFrameAnalyticsStatsAction.Response.Stats stats = (GetDataFrameAnalyticsStatsAction.Response.Stats)statsById.get(config.getId());
            DiscoveryNode node = stats == null ? null : stats.getNode();
            table.startRow().addCell((Object)config.getId()).addCell((Object)config.getAnalysis().getWriteableName()).addCell((Object)config.getCreateTime()).addCell((Object)config.getVersion()).addCell((Object)String.join((CharSequence)",", config.getSource().getIndex())).addCell((Object)config.getDest().getIndex()).addCell((Object)config.getDescription()).addCell((Object)config.getModelMemoryLimit()).addCell((Object)(stats == null ? null : stats.getState())).addCell((Object)(stats == null ? null : stats.getFailureReason())).addCell(stats == null ? null : RestCatDataFrameAnalyticsAction.progressToString(stats.getProgress())).addCell((Object)(stats == null ? null : stats.getAssignmentExplanation())).addCell((Object)(node == null ? null : node.getId())).addCell((Object)(node == null ? null : node.getName())).addCell((Object)(node == null ? null : node.getEphemeralId())).addCell(node == null ? null : node.getAddress().toString()).endRow();
        }
        return table;
    }

    private static String progressToString(List<PhaseProgress> phases) {
        return phases.stream().map(p -> p.getPhase() + ":" + p.getProgressPercent()).collect(Collectors.joining(","));
    }
}

